/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.repository;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.internal.p2.repository.AuthenticationFailedException;
import org.eclipse.equinox.internal.p2.repository.CacheManager;
import org.eclipse.equinox.internal.p2.repository.Messages;
import org.eclipse.equinox.internal.p2.repository.Transport;
import org.eclipse.equinox.p2.core.IAgentLocation;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.IProvisioningAgentProvider;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.osgi.util.NLS;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class CacheManagerTest {
    private static final int ONE_HOUR = 3600000;
    URI repositoryLocation;
    private File contentXmlFile;
    private CacheManager cacheManager;
    private final String cachePrefix = "content";

    @Before
    public void setUp() throws Exception {
        this.repositoryLocation = this.createRepistory();
        BundleContext bundle = Platform.getBundle((String)"org.eclipse.equinox.p2.repository").getBundleContext();
        ServiceReference serviceReference = bundle.getServiceReference(IProvisioningAgentProvider.class);
        IProvisioningAgentProvider agentServiceFactory = (IProvisioningAgentProvider)bundle.getService(serviceReference);
        IProvisioningAgent agent = agentServiceFactory.createAgent(this.repositoryLocation);
        Transport transport = (Transport)agent.getService(Transport.class);
        this.cacheManager = new CacheManager((IAgentLocation)new AgentLocationMock(), transport);
    }

    @After
    public void tearDown() throws Exception {
        this.deleteFileOrDirectory(new File(this.repositoryLocation));
    }

    @Test
    public void testRepositoryDowngraded() throws ProvisionException, IOException {
        File cache = this.cacheManager.createCache(this.repositoryLocation, "content", (IProgressMonitor)new NullProgressMonitor());
        long lastModifiedInitial = cache.lastModified();
        long lastModifiedContent = this.contentXmlFile.lastModified();
        this.contentXmlFile.setLastModified(lastModifiedContent - 3600000L);
        File cache2 = this.cacheManager.createCache(this.repositoryLocation, "content", (IProgressMonitor)new NullProgressMonitor());
        Assert.assertFalse((String)"Cache haven't been updated after repository downgrade", (lastModifiedInitial == cache2.lastModified() ? 1 : 0) != 0);
    }

    @Test
    public void testClientDifferentTimeZone() throws ProvisionException, IOException {
        File cache = this.cacheManager.createCache(this.repositoryLocation, "content", (IProgressMonitor)new NullProgressMonitor());
        long lastModifiedInitial = cache.lastModified();
        this.contentXmlFile.setLastModified(this.contentXmlFile.lastModified() + 1800000L);
        cache.setLastModified(lastModifiedInitial + 3600000L);
        File cache2 = this.cacheManager.createCache(this.repositoryLocation, "content", (IProgressMonitor)new NullProgressMonitor());
        Assert.assertFalse((String)"Cache haven't been updated after repository update", (lastModifiedInitial + 3600000L == cache2.lastModified() ? 1 : 0) != 0);
    }

    @Test
    public void testRepositoryUpdate() throws ProvisionException, IOException {
        File cache = this.cacheManager.createCache(this.repositoryLocation, "content", (IProgressMonitor)new NullProgressMonitor());
        long lastModifiedInitial = cache.lastModified();
        long lastModifiedContent = this.contentXmlFile.lastModified();
        this.contentXmlFile.setLastModified(lastModifiedContent + 3600000L);
        File cache2 = this.cacheManager.createCache(this.repositoryLocation, "content", (IProgressMonitor)new NullProgressMonitor());
        Assert.assertFalse((String)"Cache haven't been updated after repository update", (lastModifiedInitial == cache2.lastModified() ? 1 : 0) != 0);
    }

    @Test
    public void testStatusCodeMustBeRepositoryNotFoundInCaseOfFileNotFound() throws IOException, ProvisionException {
        CacheManager cacheManagerWithStubTransport = new CacheManager((IAgentLocation)new AgentLocationMock(), new Transport(){

            public InputStream stream(URI toDownload, IProgressMonitor monitor) throws FileNotFoundException, CoreException, AuthenticationFailedException {
                throw new UnsupportedOperationException();
            }

            public long getLastModified(URI toDownload, IProgressMonitor monitor) throws CoreException, FileNotFoundException, AuthenticationFailedException {
                throw new FileNotFoundException();
            }

            public IStatus download(URI toDownload, OutputStream target, IProgressMonitor monitor) {
                throw new UnsupportedOperationException();
            }
        });
        URI uriNonExistent = URI.create("https://foo.bar/nonexistent/content.xml.xz");
        try {
            cacheManagerWithStubTransport.createCacheFromFile(uriNonExistent, (IProgressMonitor)new NullProgressMonitor());
            Assert.fail((String)(FileNotFoundException.class.getName() + " expected"));
        }
        catch (FileNotFoundException e) {
            Assert.assertEquals((Object)NLS.bind((String)Messages.CacheManager_Repository_not_found, (Object)uriNonExistent.toString()), (Object)e.getMessage());
        }
    }

    private URI createRepistory() throws IOException {
        File repository = File.createTempFile("remoteFile", "");
        repository.deleteOnExit();
        Assert.assertTrue((boolean)repository.delete());
        Assert.assertTrue((boolean)repository.mkdirs());
        File contentXmlPath = new File(repository, "content.xml");
        Assert.assertTrue((boolean)contentXmlPath.createNewFile());
        this.contentXmlFile = contentXmlPath;
        return repository.toURI();
    }

    private void deleteFileOrDirectory(File path) {
        if (path.exists()) {
            if (path.isDirectory()) {
                this.handleDirectory(path);
            } else {
                Assert.assertTrue((boolean)path.delete());
            }
        }
    }

    private void handleDirectory(File path) {
        File[] files;
        File[] fileArray = files = path.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory()) {
                this.deleteFileOrDirectory(file);
            } else {
                Assert.assertTrue((boolean)file.delete());
            }
            ++n2;
        }
    }

    class AgentLocationMock
    implements IAgentLocation {
        AgentLocationMock() {
        }

        public URI getDataArea(String namespace) {
            return CacheManagerTest.this.repositoryLocation;
        }

        public URI getRootLocation() {
            return null;
        }
    }
}

