/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.repository;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.transport.ecf.RepositoryTransport;
import org.eclipse.equinox.p2.tests.testserver.helper.AbstractTestServerClientCase;

public class FileReaderTest
extends AbstractTestServerClientCase {
    public void testUnknownHost() throws URISyntaxException {
        RepositoryTransport transport = new RepositoryTransport();
        URI toDownload = new URI("http://bogus.nowhere/nothing.xml");
        ByteArrayOutputStream target = new ByteArrayOutputStream();
        IStatus status = transport.download(toDownload, (OutputStream)target, (IProgressMonitor)new NullProgressMonitor());
        FileReaderTest.assertEquals((String)"Should be an error", (int)status.getSeverity(), (int)4);
        FileReaderTest.assertTrue((String)"Should begin with 'Unknown Host'", (boolean)status.getMessage().startsWith("Unknown Host"));
    }

    public void testBadPort() throws URISyntaxException {
        RepositoryTransport transport = new RepositoryTransport();
        URI toDownload = new URI("http://localhost:1/nothing.xml");
        ByteArrayOutputStream target = new ByteArrayOutputStream();
        IStatus status = transport.download(toDownload, (OutputStream)target, (IProgressMonitor)new NullProgressMonitor());
        FileReaderTest.assertEquals((String)"Should be an error", (int)status.getSeverity(), (int)4);
        FileReaderTest.assertTrue((String)"Should be a connect exception", (boolean)(status.getException() instanceof ConnectException));
        FileReaderTest.assertTrue((String)"Should begin with 'Connection refused'", (boolean)status.getException().getMessage().startsWith("Connection refused"));
    }

    public void testReadStream() throws URISyntaxException, CoreException, IOException {
        RepositoryTransport transport = new RepositoryTransport();
        URI toDownload = new URI(this.getBaseURL() + "/public/index.html");
        NullProgressMonitor monitor = new NullProgressMonitor();
        Throwable throwable = null;
        Object var5_5 = null;
        try {
            InputStream stream = transport.stream(toDownload, (IProgressMonitor)monitor);
            if (stream != null) {
                stream.close();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        FileReaderTest.assertFalse((String)"1.0", (boolean)monitor.isCanceled());
    }

    public void testRead() throws URISyntaxException {
        RepositoryTransport transport = new RepositoryTransport();
        URI toDownload = new URI(this.getBaseURL() + "/public/index.html");
        ByteArrayOutputStream target = new ByteArrayOutputStream();
        NullProgressMonitor monitor = new NullProgressMonitor();
        IStatus result = transport.download(toDownload, (OutputStream)target, (IProgressMonitor)monitor);
        FileReaderTest.assertTrue((String)"1.0", (boolean)result.isOK());
    }
}

