/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.repository;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.internal.p2.repository.helpers.RepositoryHelper;
import org.junit.Assert;
import org.junit.Test;

public class RepositoryHelperTest {
    @Test
    public void testURISyntaxChecker() throws URISyntaxException {
        URI location = new URI("http://somwhere.com/path");
        IStatus result = RepositoryHelper.checkRepositoryLocationSyntax((URI)location);
        Assert.assertTrue((String)"1.0 Valid URI should be ok", (boolean)result.isOK());
        location = new URI("ftp://somwhere.com/path");
        result = RepositoryHelper.checkRepositoryLocationSyntax((URI)location);
        Assert.assertTrue((String)"2.0 Valid URI should be ok", (boolean)result.isOK());
        location = new URI("https://somwhere.com/path");
        result = RepositoryHelper.checkRepositoryLocationSyntax((URI)location);
        Assert.assertTrue((String)"3.0 Valid URI should be ok", (boolean)result.isOK());
        location = new URI("htp://somwhere.com/path");
        result = RepositoryHelper.checkRepositoryLocationSyntax((URI)location);
        Assert.assertFalse((String)"4.0 Invalid URI should not be ok", (boolean)result.isOK());
        location = new URI("/somwhere.com/path");
        result = RepositoryHelper.checkRepositoryLocationSyntax((URI)location);
        Assert.assertFalse((String)"5.0 Invalid URI should not be ok", (boolean)result.isOK());
    }
}

