/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.sharedinstall;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.AclEntry;
import java.nio.file.attribute.AclEntryFlag;
import java.nio.file.attribute.AclEntryPermission;
import java.nio.file.attribute.AclEntryType;
import java.nio.file.attribute.AclFileAttributeView;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.internal.p2.engine.SimpleProfileRegistry;
import org.eclipse.equinox.p2.tests.reconciler.dropins.AbstractReconcilerTest;

public abstract class AbstractSharedInstallTest
extends AbstractReconcilerTest {
    public static final boolean WINDOWS = File.separatorChar == '\\';
    protected static File readOnlyBase;
    protected static File userBase;
    protected static String profileId;
    public boolean runningWithReconciler = true;

    public File getUserBundleInfo() {
        return new File(userBase, "configuration/org.eclipse.equinox.simpleconfigurator/bundles.info");
    }

    protected String getTestRepo() {
        return AbstractSharedInstallTest.getTestData("repo for shared install tests", "testData/sharedInstall/repo").toURI().toString();
    }

    protected File getUserBundleInfoTimestamp() {
        return new File(userBase, "configuration/org.eclipse.equinox.simpleconfigurator/.baseBundlesInfoTimestamp");
    }

    protected File getUserProfileRegistryFolder() {
        return new File(userBase, "p2/org.eclipse.equinox.p2.engine/profileRegistry/");
    }

    protected File getUserProfileFolder() {
        return new File(this.getUserProfileRegistryFolder(), profileId + ".profile");
    }

    protected File getBaseProfileRegistryFolder() {
        return new File(output, AbstractSharedInstallTest.getRootFolder() + "p2/org.eclipse.equinox.p2.engine/profileRegistry/");
    }

    protected long[] getProfileTimestampsFromUser() {
        return new SimpleProfileRegistry(AbstractSharedInstallTest.getAgent(), this.getUserProfileRegistryFolder()).listProfileTimestamps(profileId);
    }

    protected long getMostRecentProfileTimestamp(File profileFolder) {
        long[] ts = new SimpleProfileRegistry(AbstractSharedInstallTest.getAgent(), profileFolder).listProfileTimestamps(profileId);
        return ts[ts.length - 1];
    }

    protected long getMostRecentProfileTimestampFromBase() {
        return this.getMostRecentProfileTimestamp(this.getBaseProfileRegistryFolder());
    }

    protected void assertProfileStatePropertiesHasValue(File profileFolder, String value) throws IOException {
        Properties p = AbstractSharedInstallTest.loadProperties(new File(profileFolder, "state.properties").toPath());
        Collection<Object> values = p.values();
        for (Object v : values) {
            if (!((String)v).contains(value)) continue;
            return;
        }
        AbstractSharedInstallTest.fail((String)("Value: " + value + " not found."));
    }

    protected File getConfigIniTimestamp() {
        return new File(userBase, "configuration/.baseConfigIniTimestamp");
    }

    protected void assertProfileStatePropertiesHasKey(File profileFolder, String key) throws IOException {
        Properties p = AbstractSharedInstallTest.loadProperties(new File(profileFolder, "state.properties").toPath());
        Set<Object> keys = p.keySet();
        for (Object k : keys) {
            if (!((String)k).contains(key)) continue;
            return;
        }
        AbstractSharedInstallTest.fail((String)("Key: " + key + " not found."));
    }

    protected void installFeature1AndVerifierInUser() {
        this.runEclipse("Installing in user", output, new String[]{"-configuration", userBase.getAbsolutePath() + File.separatorChar + "configuration", "-application", "org.eclipse.equinox.p2.director", "-installIU", "p2TestFeature1.feature.group,Verifier.feature.group", "-repository", this.getTestRepo()});
    }

    @Override
    protected void tearDown() throws Exception {
        if (readOnlyBase != null && readOnlyBase.exists()) {
            AbstractSharedInstallTest.setReadOnly(readOnlyBase, false);
        }
        AbstractSharedInstallTest.delete(readOnlyBase);
        AbstractSharedInstallTest.delete(userBase);
        super.tearDown();
    }

    protected void installFeature1InUser() {
        this.runEclipse("user2", output, new String[]{"-configuration", userBase.getAbsolutePath() + File.separatorChar + "configuration", "-application", "org.eclipse.equinox.p2.director", "-installIU", "p2TestFeature1.feature.group", "-repository", this.getTestRepo()});
    }

    protected void installFeature1InUserWithoutSpecifyingConfiguration() {
        this.runEclipse("user2", output, new String[]{"-application", "org.eclipse.equinox.p2.director", "-installIU", "p2TestFeature1.feature.group", "-repository", this.getTestRepo()});
    }

    protected void installFeature2InUser() {
        this.runEclipse("user2", output, new String[]{"-configuration", userBase.getAbsolutePath() + File.separatorChar + "configuration", "-application", "org.eclipse.equinox.p2.director", "-installIU", "p2TestFeature2.feature.group", "-repository", this.getTestRepo()});
    }

    protected void installVerifierInBase() {
        AbstractSharedInstallTest.setReadOnly(readOnlyBase, false);
        this.runEclipse("Running eclipse", output, new String[]{"-application", "org.eclipse.equinox.p2.director", "-installIU", "Verifier.feature.group", "-repository", this.getTestRepo()});
        AbstractSharedInstallTest.setReadOnly(readOnlyBase, true);
    }

    protected void installVerifierAndFeature1InBase() {
        AbstractSharedInstallTest.setReadOnly(readOnlyBase, false);
        this.runEclipse("Running eclipse", output, new String[]{"-application", "org.eclipse.equinox.p2.director", "-installIU", "Verifier.feature.group,p2TestFeature1.feature.group", "-repository", this.getTestRepo()});
        AbstractSharedInstallTest.setReadOnly(readOnlyBase, true);
    }

    protected void uninstallFeature1InBase() {
        AbstractSharedInstallTest.setReadOnly(readOnlyBase, false);
        this.runEclipse("Running eclipse", output, new String[]{"-application", "org.eclipse.equinox.p2.director", "-uninstallIU", "p2TestFeature1.feature.group", "-repository", this.getTestRepo()});
        AbstractSharedInstallTest.setReadOnly(readOnlyBase, true);
    }

    protected void installFeature2InBase() {
        AbstractSharedInstallTest.setReadOnly(readOnlyBase, false);
        this.runEclipse("Running eclipse", output, new String[]{"-application", "org.eclipse.equinox.p2.director", "-installIU", "p2TestFeature2.feature.group", "-repository", this.getTestRepo()});
        AbstractSharedInstallTest.setReadOnly(readOnlyBase, true);
    }

    protected boolean isInUserBundlesInfo(String bundleId) throws IOException {
        return this.isInBundlesInfo(this.getUserBundlesInfo(), bundleId, null, null);
    }

    protected File getUserBundlesInfo() {
        return new File(userBase, "configuration/org.eclipse.equinox.simpleconfigurator/bundles.info");
    }

    protected void startEclipseAsUser() {
        this.runEclipse("Running eclipse", output, new String[]{"-configuration", userBase.getAbsolutePath() + File.separatorChar + "configuration", "-application", "org.eclipse.equinox.p2.director", "-listInstalledRoots"});
    }

    protected void executeVerifierWithoutSpecifyingConfiguration(Properties verificationProperties) throws IOException {
        this.realExecuteVerifier(verificationProperties, false);
    }

    protected void realExecuteVerifier(Properties verificationProperties, boolean withConfigFlag) throws IOException {
        File verifierConfig = new File(this.getTempFolder(), "verification.properties");
        AbstractSharedInstallTest.writeProperties(verifierConfig, verificationProperties);
        String[] args = null;
        args = withConfigFlag ? new String[]{"-configuration", userBase.getAbsolutePath() + File.separatorChar + "configuration", "-application", "org.eclipse.equinox.p2.tests.verifier.application", "-verifier.properties", verifierConfig.getAbsolutePath(), "-consoleLog"} : new String[]{"-application", "org.eclipse.equinox.p2.tests.verifier.application", "-verifier.properties", verifierConfig.getAbsolutePath(), "-consoleLog"};
        AbstractSharedInstallTest.assertEquals((int)0, (int)this.runEclipse("Running verifier", output, args));
    }

    protected void executeVerifier(Properties verificationProperties) throws IOException {
        this.realExecuteVerifier(verificationProperties, true);
    }

    public static void reallyReadOnly(File folder, boolean recurse) throws IOException {
        AbstractSharedInstallTest.reallyReadOnly(folder);
        if (folder.exists() && recurse) {
            File[] dirs;
            File[] fileArray = dirs = folder.listFiles(File::isDirectory);
            int n = dirs.length;
            int n2 = 0;
            while (n2 < n) {
                File dir = fileArray[n2];
                AbstractSharedInstallTest.reallyReadOnly(dir, true);
                ++n2;
            }
        }
    }

    public static void reallyReadOnly(File folder) throws IOException {
        if (Platform.OS.isWindows()) {
            Path path = folder.toPath();
            AclFileAttributeView view = Files.getFileAttributeView(path, AclFileAttributeView.class, new LinkOption[0]);
            AclEntry newEntry = AclEntry.newBuilder().setFlags(AclEntryFlag.FILE_INHERIT, AclEntryFlag.DIRECTORY_INHERIT).setPermissions(AclEntryPermission.WRITE_DATA, AclEntryPermission.APPEND_DATA, AclEntryPermission.WRITE_NAMED_ATTRS, AclEntryPermission.WRITE_ATTRIBUTES).setPrincipal(view.getOwner()).setType(AclEntryType.DENY).build();
            List<AclEntry> acl = view.getAcl();
            acl.add(0, newEntry);
            view.setAcl(acl);
        }
    }

    public static void removeReallyReadOnly(File folder, boolean recurse) throws IOException {
        AbstractSharedInstallTest.removeReallyReadOnly(folder);
        if (folder.exists() && recurse) {
            File[] dirs;
            File[] fileArray = dirs = folder.listFiles(File::isDirectory);
            int n = dirs.length;
            int n2 = 0;
            while (n2 < n) {
                File dir = fileArray[n2];
                AbstractSharedInstallTest.removeReallyReadOnly(dir, true);
                ++n2;
            }
        }
    }

    public static void removeReallyReadOnly(File folder) throws IOException {
        if (Platform.OS.isWindows()) {
            Path path = folder.toPath();
            AclFileAttributeView view = Files.getFileAttributeView(path, AclFileAttributeView.class, new LinkOption[0]);
            List<AclEntry> acl = view.getAcl();
            acl.remove(0);
            view.setAcl(acl);
        }
    }

    public static Properties loadProperties(Path inputFile) throws FileNotFoundException, IOException {
        Properties props = new Properties();
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream is = Files.newInputStream(inputFile, new OpenOption[0]);){
            props.load(is);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return props;
    }

    public static void setupReadOnlyInstall() {
        readOnlyBase = new File(output, AbstractSharedInstallTest.getRootFolder());
        readOnlyBase.mkdirs();
        AbstractSharedInstallTest.assertTrue((boolean)readOnlyBase.canWrite());
        AbstractSharedInstallTest.setReadOnly(readOnlyBase, true);
        userBase = new File(output, "user");
        userBase.mkdir();
        String[] files = new File(readOnlyBase, "p2/org.eclipse.equinox.p2.engine/profileRegistry/").list();
        if (files.length > 1 || files.length == 0) {
            AbstractSharedInstallTest.fail((String)("The profile for the read only install located at: " + String.valueOf(output) + "could not be determined"));
        } else {
            profileId = files[0].substring(0, files[0].indexOf(46));
        }
    }

    public static void setReadOnly(File target, boolean readOnly) {
        if (WINDOWS) {
            Object targetPath = target.getAbsolutePath();
            String[] command = new String[]{"attrib", readOnly ? "+r" : "-r", targetPath, "/s", "/d"};
            AbstractSharedInstallTest.run("setReadOnly " + readOnly + " failed on" + target.getAbsolutePath(), command);
            if (target.isDirectory()) {
                targetPath = (String)targetPath + "\\*.*";
                command = new String[]{"attrib", readOnly ? "+r" : "-r", targetPath, "/s", "/d"};
                AbstractSharedInstallTest.run("setReadOnly " + readOnly + " failed on" + target.getAbsolutePath(), command);
            }
        } else {
            String[] command = new String[]{"chmod", "-R", readOnly ? "a-w" : "a+w", target.getAbsolutePath()};
            AbstractSharedInstallTest.run("setReadOnly " + readOnly + " failed on" + target.getAbsolutePath(), command);
        }
    }

    public AbstractSharedInstallTest(String name) {
        super(name);
    }

    public void replaceDotEclipseProductFile(File base, String id, String version) throws IOException {
        File eclipseProductFile = new File(base, ".eclipseproduct");
        eclipseProductFile.delete();
        Properties newProps = new Properties();
        newProps.put("id", id);
        newProps.put("version", version);
        Throwable throwable = null;
        Object var7_8 = null;
        try (BufferedWriter os = Files.newBufferedWriter(eclipseProductFile.toPath(), new OpenOption[0]);){
            newProps.store(os, "file generated for tests " + this.getName());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

