/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.sharedinstall;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;
import junit.framework.Test;
import org.eclipse.equinox.internal.p2.updatesite.Activator;
import org.eclipse.equinox.p2.tests.reconciler.dropins.ReconcilerTestSuite;
import org.eclipse.equinox.p2.tests.sharedinstall.BaseChange;

public class BaseChangeExtendedConfigured
extends BaseChange {
    private File extensions;

    public static Test suite() {
        ReconcilerTestSuite suite = new ReconcilerTestSuite();
        suite.setName(BaseChangeExtendedConfigured.class.getName());
        suite.addTest((Test)new BaseChangeExtendedConfigured("testBaseWithExtensionsChange"));
        return suite;
    }

    public BaseChangeExtendedConfigured(String name) {
        super(name);
    }

    protected void realExecuteVerifier(Properties verificationProperties, boolean withConfigFlag, File ... files) {
        File verifierConfig = new File(this.getTempFolder(), "verification.properties");
        try {
            BaseChangeExtendedConfigured.writeProperties(verifierConfig, verificationProperties);
        }
        catch (IOException e) {
            BaseChangeExtendedConfigured.fail("Failing to write out properties to configure verifier", e);
        }
        String[] args = null;
        args = withConfigFlag ? new String[]{"-configuration", userBase.getAbsolutePath() + File.separatorChar + "configuration", "-application", "org.eclipse.equinox.p2.tests.verifier.application", "-verifier.properties", verifierConfig.getAbsolutePath(), "-consoleLog"} : new String[]{"-application", "org.eclipse.equinox.p2.tests.verifier.application", "-verifier.properties", verifierConfig.getAbsolutePath(), "-consoleLog"};
        BaseChangeExtendedConfigured.assertEquals((int)0, (int)this.runEclipse("Running verifier", output, args, files));
    }

    protected void executeVerifier(Properties verificationProperties, File ... files) {
        this.realExecuteVerifier(verificationProperties, true, files);
    }

    protected int runEclipse(String message, File location, String[] args, File ... files) {
        int result;
        File root = new File(Activator.getBundleContext().getProperty("java.home"));
        File exe = new File(root = new File(root, "bin"), "javaw.exe");
        if (!exe.exists()) {
            exe = new File(root, "java");
        }
        BaseChangeExtendedConfigured.assertTrue((String)("Java executable not found in: " + exe.getAbsolutePath()), (boolean)exe.exists());
        ArrayList command = new ArrayList();
        Collections.addAll(command, new File(location == null ? output : location, BaseChangeExtendedConfigured.getExeFolder() + "eclipse").getAbsolutePath(), "--launcher.suppressErrors", "-nosplash", "-vm", exe.getAbsolutePath());
        Collections.addAll(command, args);
        Collections.addAll(command, "-vmArgs", "-Dosgi.checkConfiguration=true", "-Dosgi.dataAreaRequiresExplicitInit=false");
        if (files != null) {
            Object extensionParameter = "";
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                extensionParameter = (String)extensionParameter + f.toString() + ",";
                ++n2;
            }
            extensionParameter = ((String)extensionParameter).substring(0, ((String)extensionParameter).length() - 1);
            Collections.addAll(command, "-Dp2.fragments=" + (String)extensionParameter);
        }
        if (this.debug) {
            Collections.addAll(command, "-Xdebug", "-Xnoagent", "-Xrunjdwp:transport=dt_socket,server=y,suspend=y,address=8000");
        }
        if ((result = BaseChangeExtendedConfigured.run(message, command.toArray(new String[command.size()]))) == 13) {
            this.parseExitdata(message);
        }
        return result;
    }

    protected void installFeature1AndVerifierInUser(File ... extension) {
        this.runEclipse("Installing in user", output, new String[]{"-configuration", userBase.getAbsolutePath() + File.separatorChar + "configuration", "-application", "org.eclipse.equinox.p2.director", "-installIU", "p2TestFeature1.feature.group,Verifier.feature.group", "-repository", this.getTestRepo()}, extension);
    }

    protected void installFeature2InUser(File ... extension) {
        this.runEclipse("user2", output, new String[]{"-configuration", userBase.getAbsolutePath() + File.separatorChar + "configuration", "-application", "org.eclipse.equinox.p2.director", "-installIU", "p2TestFeature2.feature.group", "-repository", this.getTestRepo()}, extension);
    }

    @Override
    protected void installVerifierInBase() {
        BaseChangeExtendedConfigured.setReadOnly(readOnlyBase, false);
        this.runEclipse("Running eclipse", output, new String[]{"-application", "org.eclipse.equinox.p2.director", "-installIU", "Verifier.feature.group", "-repository", this.getTestRepo()});
        BaseChangeExtendedConfigured.setReadOnly(readOnlyBase, true);
    }

    @Override
    protected void tearDown() throws Exception {
        BaseChangeExtendedConfigured.setReadOnly(this.extensions, false);
        this.extensions.delete();
        super.tearDown();
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.extensions = this.getTestFolder("ext");
        BaseChangeExtendedConfigured.copy("", BaseChangeExtendedConfigured.getTestData("", "testData/reconciler/extensions/ext1"), this.extensions);
        BaseChangeExtendedConfigured.setReadOnly(this.extensions, true);
    }

    public void testBaseWithExtensionsChange() throws IOException {
        this.assertInitialized();
        BaseChangeExtendedConfigured.setupReadOnlyInstall();
        this.installFeature1AndVerifierInUser(this.extensions);
        Properties verificationProperties = new Properties();
        verificationProperties.setProperty("expectedBundleList", "p2TestBundle1,org.eclipse.equinox.p2.tests.verifier,zzz");
        verificationProperties.setProperty("checkProfileResetFlag", "false");
        verificationProperties.setProperty("not.sysprop.eclipse.ignoreUserConfiguration", "");
        this.executeVerifier(verificationProperties, this.extensions);
        BaseChangeExtendedConfigured.assertTrue((boolean)this.isInUserBundlesInfo("p2TestBundle1"));
        BaseChangeExtendedConfigured.assertTrue((boolean)this.isInUserBundlesInfo("zzz"));
        this.assertProfileStatePropertiesHasKey(this.getUserProfileFolder(), "_simpleProfileRegistry_internal_" + this.getMostRecentProfileTimestampFromBase());
        this.installVerifierInBase();
        verificationProperties = new Properties();
        verificationProperties.setProperty("checkPresenceOfVerifier", "true");
        verificationProperties.setProperty("unexpectedBundleList", "p2TestBundle1,yyy");
        verificationProperties.setProperty("checkPresenceOfVerifier", "false");
        verificationProperties.setProperty("expectedBundleList", "org.eclipse.equinox.p2.tests.verifier,zzz");
        verificationProperties.setProperty("checkProfileResetFlag", "false");
        verificationProperties.setProperty("checkMigrationWizard", "true");
        verificationProperties.setProperty("checkMigrationWizard.open", "true");
        this.executeVerifier(verificationProperties, this.extensions);
        BaseChangeExtendedConfigured.assertTrue((boolean)this.isInUserBundlesInfo("p2TestBundle1"));
        this.assertProfileStatePropertiesHasKey(this.getUserProfileFolder(), "_simpleProfileRegistry_internal_" + this.getMostRecentProfileTimestampFromBase());
        verificationProperties = new Properties();
        verificationProperties.setProperty("checkProfileResetFlag", "false");
        verificationProperties.setProperty("checkPresenceOfVerifier", "false");
        verificationProperties.setProperty("expectedBundleList", "org.eclipse.equinox.p2.tests.verifier,zzz");
        this.executeVerifier(verificationProperties, this.extensions);
        this.installFeature2InUser(this.extensions);
        verificationProperties = new Properties();
        verificationProperties.setProperty("expectedBundleList", "org.eclipse.equinox.p2.tests.verifier,zzz,p2TestBundle2");
        this.executeVerifier(verificationProperties, this.extensions);
        BaseChangeExtendedConfigured.assertFalse((boolean)this.isInUserBundlesInfo("p2TestBundle1"));
        BaseChangeExtendedConfigured.assertTrue((boolean)this.isInUserBundlesInfo("p2TestBundle2"));
        BaseChangeExtendedConfigured.assertTrue((boolean)this.isInUserBundlesInfo("org.eclipse.equinox.p2.tests.verifier"));
        BaseChangeExtendedConfigured.assertTrue((boolean)this.isInUserBundlesInfo("zzz"));
        verificationProperties.setProperty("expectedBundleList", "org.eclipse.equinox.p2.tests.verifier,zzz,p2TestBundle2");
        this.executeVerifier(verificationProperties, this.extensions);
        Properties newVerificationProperties = new Properties();
        newVerificationProperties.setProperty("expectedBundleList", "org.eclipse.equinox.p2.tests.verifier");
        newVerificationProperties.setProperty("unexpectedBundleList", "zzz,p2TestBundle2,p2TestBundle1");
        this.executeVerifier(newVerificationProperties);
        verificationProperties.setProperty("expectedBundleList", "org.eclipse.equinox.p2.tests.verifier,zzz,p2TestBundle2,");
        verificationProperties.setProperty("unexpectedBundleList", "p2TestBundle1");
        this.executeVerifier(verificationProperties, this.extensions);
    }
}

