/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.sharedinstall;

import java.io.File;
import java.net.URI;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.repository.Activator;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.p2.tests.TestActivator;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class SharedProfilePreferencesTestWithDataInUser
extends AbstractProvisioningTest {
    @Override
    protected void setUp() throws Exception {
        Bundle p2Core = Platform.getBundle((String)"org.eclipse.equinox.p2.core");
        p2Core.stop();
        File baseInstallToCopy = SharedProfilePreferencesTestWithDataInUser.getTestData("baseInstall", "testData/sharedPrefs/test2/baseInstall");
        File baseInstall = this.getTempFolder();
        File baseInstallToCopyTo = new File(baseInstall, "p2/org.eclipse.equinox.p2.engine/profileRegistry");
        baseInstallToCopy.mkdirs();
        SharedProfilePreferencesTestWithDataInUser.copy("copy base install", baseInstallToCopy, baseInstallToCopyTo);
        File userHomeToCopy = SharedProfilePreferencesTestWithDataInUser.getTestData("useHome", "testData/sharedPrefs/test2/userHome");
        File userHome = this.getTempFolder();
        File userHomeToCopyTo = new File(userHome, "p2/org.eclipse.equinox.p2.engine/profileRegistry");
        userHomeToCopyTo.mkdirs();
        SharedProfilePreferencesTestWithDataInUser.copy("copy user home data", userHomeToCopy, userHomeToCopyTo);
        System.setProperty("osgi.sharedConfiguration.area", new File(baseInstall, "configuration").toURI().toString());
        System.setProperty("osgi.configuration.area", new File(userHome, "configuration").toURI().toString() + "/");
        System.setProperty("eclipse.p2.profile", "epp.package.java");
        System.setProperty("eclipse.p2.data.area", "@config.dir/../p2");
        IPreferencesService prefService = (IPreferencesService)ServiceHelper.getService((BundleContext)Activator.getContext(), IPreferencesService.class);
        prefService.getRootNode().node("/profile/").removeNode();
        p2Core.start();
        IProvisioningAgent currentAgent = SharedProfilePreferencesTestWithDataInUser.getAgent();
        SharedProfilePreferencesTestWithDataInUser.assertEquals((Object)currentAgent, (Object)ServiceHelper.getService((BundleContext)TestActivator.getContext(), IProvisioningAgent.class));
        currentAgent.getService("org.eclipse.equinox.shared.base.agent");
        currentAgent.getService("org.eclipse.equinox.shared.current.agent");
    }

    public void testCountRepoInSharedInstallThroughRepoManagerAPI() {
        IMetadataRepositoryManager repoMgr = (IMetadataRepositoryManager)SharedProfilePreferencesTestWithDataInUser.getAgent().getService(IMetadataRepositoryManager.class);
        URI[] repos = repoMgr.getKnownRepositories(0);
        SharedProfilePreferencesTestWithDataInUser.assertEquals((int)4, (int)repos.length);
    }
}

