/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.simpleconfigurator;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.p2.tests.TestActivator;
import org.eclipse.equinox.p2.tests.embeddedequinox.EmbeddedEquinox;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public abstract class AbstractSimpleConfiguratorTest
extends AbstractProvisioningTest {
    static String BUNDLE_JAR_DIRECTORY = "simpleConfiguratorTest/bundlesTxt2";
    private EmbeddedEquinox equinox = null;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.equinox != null) {
            this.equinox.shutdown();
        }
    }

    protected void assertJarsInstalled(File[] jars, Bundle[] bundles) {
        File[] fileArray = jars;
        int n = jars.length;
        int n2 = 0;
        while (n2 < n) {
            File jar = fileArray[n2];
            boolean found = false;
            String jarName = this.getManifestEntry(jar, "Bundle-SymbolicName");
            Bundle[] bundleArray = bundles;
            int n3 = bundles.length;
            int n4 = 0;
            while (n4 < n3) {
                Bundle bundle = bundleArray[n4];
                String bundleName = bundle.getSymbolicName();
                if (bundleName.equalsIgnoreCase(jarName)) {
                    found = true;
                }
                ++n4;
            }
            if (!found) {
                AbstractSimpleConfiguratorTest.fail((String)("Bundle should be present:  " + jarName));
            }
            ++n2;
        }
    }

    private File getLocation(String bundleId) {
        try {
            URL u = FileLocator.resolve((URL)Platform.getBundle((String)bundleId).getEntry(""));
            String urlString = u.toExternalForm();
            if (urlString.startsWith("file:")) {
                return new File(urlString.substring(5));
            }
            if (urlString.startsWith("jar:")) {
                return new File(urlString.substring(9, urlString.length() - 2));
            }
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    protected BundleContext startFramework(File bundleInfo, File[] additionalBundle) {
        try {
            URL[] uRLArray;
            File simpleConfiguratorBundle = this.getLocation("org.eclipse.equinox.simpleconfigurator");
            File osgiBundleLoc = this.getLocation("org.eclipse.osgi");
            File installarea = TestActivator.context.getDataFile(this.getName() + "/" + System.currentTimeMillis() + "/eclipse");
            File configarea = new File(installarea, "configuration");
            URL osgiBundle = osgiBundleLoc.toURI().toURL();
            URL osgiBundleDevPath = null;
            if (!osgiBundle.getPath().endsWith(".jar")) {
                osgiBundleDevPath = new URL(osgiBundle, "bin/");
            }
            HashMap<String, String> frameworkProperties = new HashMap<String, String>();
            frameworkProperties.put("osgi.framework", null);
            frameworkProperties.put("osgi.install.area", installarea.toURL().toExternalForm());
            frameworkProperties.put("osgi.configuration.area", configarea.toURL().toExternalForm());
            StringBuilder osgiBundles = new StringBuilder();
            int i = 0;
            while (additionalBundle != null && i < additionalBundle.length) {
                osgiBundles.append("reference:").append(additionalBundle[i].toURL().toExternalForm()).append(",");
                ++i;
            }
            osgiBundles.append("reference:").append(simpleConfiguratorBundle.toURL().toExternalForm()).append("@1:start");
            frameworkProperties.put("osgi.bundles", osgiBundles.toString());
            frameworkProperties.put("org.eclipse.equinox.simpleconfigurator.configUrl", bundleInfo.toURL().toExternalForm());
            frameworkProperties.put("osgi.dev", "bin/");
            if (osgiBundleDevPath == null) {
                URL[] uRLArray2 = new URL[1];
                uRLArray = uRLArray2;
                uRLArray2[0] = osgiBundle;
            } else {
                URL[] uRLArray3 = new URL[2];
                uRLArray3[0] = osgiBundle;
                uRLArray = uRLArray3;
                uRLArray3[1] = osgiBundleDevPath;
            }
            URL[] osgiPath = uRLArray;
            this.equinox = new EmbeddedEquinox(frameworkProperties, new String[0], osgiPath);
            return this.equinox.startFramework();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    protected File createBundlesTxt(File[] jars) throws IOException {
        File bundlesTxt = File.createTempFile("bundles", ".txt");
        bundlesTxt.deleteOnExit();
        Throwable throwable = null;
        Object var4_5 = null;
        try (BufferedWriter bundlesTxtOut = new BufferedWriter(new FileWriter(bundlesTxt));){
            File[] fileArray = jars;
            int n = jars.length;
            int n2 = 0;
            while (n2 < n) {
                File bundleJar = fileArray[n2];
                bundlesTxtOut.write(this.getBundlesTxtEntry(bundleJar) + "\n");
                ++n2;
            }
            bundlesTxtOut.write(this.getBundlesTxtEntry(this.getLocation("org.eclipse.equinox.simpleconfigurator")) + "\n");
            bundlesTxtOut.write(this.getBundlesTxtEntry(this.getLocation("org.eclipse.osgi")) + "\n");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return bundlesTxt;
    }

    private String getBundlesTxtEntry(File bundleJar) {
        String name = this.getManifestEntry(bundleJar, "Bundle-SymbolicName");
        String version = this.getManifestEntry(bundleJar, "Bundle-Version");
        return name + "," + version + "," + String.valueOf(bundleJar.toURI()) + "," + this.getStartLevel(name) + ",true";
    }

    private String getManifestEntry(File bundleFile, String entry) {
        try {
            String value;
            block22: {
                Serializable m;
                value = null;
                if (bundleFile.isDirectory()) {
                    m = new File(bundleFile, "META-INF/MANIFEST.MF");
                    Throwable throwable = null;
                    Object var6_11 = null;
                    try (InputStream os = Files.newInputStream(((File)m).toPath(), new OpenOption[0]);){
                        Manifest mf = new Manifest(os);
                        value = mf.getMainAttributes().getValue(entry);
                        break block22;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                m = null;
                Object var5_9 = null;
                try (JarFile bundleJar = new JarFile(bundleFile);){
                    value = bundleJar.getManifest().getMainAttributes().getValue(entry);
                }
                catch (Throwable throwable) {
                    if (m == null) {
                        m = throwable;
                    } else if (m != throwable) {
                        ((Throwable)m).addSuppressed(throwable);
                    }
                    throw m;
                }
            }
            if (value.contains(";")) {
                String[] valueElements = value.split(";");
                return valueElements[0];
            }
            return value;
        }
        catch (IOException e) {
            return null;
        }
    }

    private int getStartLevel(String bundleName) {
        int startLevel = 4;
        if (bundleName.matches("org.eclipse.osgi")) {
            startLevel = -1;
        } else if (bundleName.matches("org.eclipse.equinox.common")) {
            startLevel = 2;
        } else if (bundleName.matches("org.eclipse.equinox.simpleconfigurator")) {
            startLevel = 1;
        }
        return startLevel;
    }

    protected File[] getBundleJars(File directory) {
        FilenameFilter bundleFilter = (directoryName, filename) -> !filename.startsWith(".") && !filename.equals("CVS");
        return directory.listFiles(bundleFilter);
    }
}

