/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.simpleconfigurator;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileTime;
import java.util.Properties;
import org.eclipse.equinox.internal.simpleconfigurator.SimpleConfiguratorImpl;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.p2.tests.sharedinstall.AbstractSharedInstallTest;

public class SimpleConfiguratorTest
extends AbstractProvisioningTest {
    protected URL relativeURL;
    protected File userConfiguration;
    protected File masterConfguration;
    protected URL[] sharedConfiguration = new URL[2];
    protected URL[] localConfiguration = new URL[1];
    protected SimpleConfiguratorImpl configurator;

    @Override
    public void setUp() throws Exception {
        this.relativeURL = new URL("file://bundles.info");
        File tmp = this.getTempFolder();
        String USER_PATH = "testData/simpleconfigurator/user";
        this.userConfiguration = new File(tmp, "testData/simpleconfigurator/user");
        SimpleConfiguratorTest.copy("copyUserConfiguration", SimpleConfiguratorTest.getTestData("userConfiguration", "testData/simpleconfigurator/user"), this.userConfiguration);
        String MASTER_PATH = "testData/simpleconfigurator/master";
        this.masterConfguration = new File(tmp, "testData/simpleconfigurator/master");
        SimpleConfiguratorTest.copy("copymasterConfiguration", SimpleConfiguratorTest.getTestData("masterConfiguration", "testData/simpleconfigurator/master"), this.masterConfguration);
        this.sharedConfiguration[0] = this.userConfiguration.toURL();
        this.sharedConfiguration[1] = this.masterConfguration.toURL();
        this.localConfiguration[0] = this.sharedConfiguration[1];
        this.configurator = this.getSimpleConfigurator();
    }

    private SimpleConfiguratorImpl getSimpleConfigurator() {
        return new SimpleConfiguratorImpl(null, null);
    }

    protected void storeTimestamp(long timestamp) throws IOException {
        File f = new File(this.userConfiguration.getParent(), ".baseBundlesInfoTimestamp");
        Properties p = new Properties();
        p.put("bundlesInfoTimestamp", "" + timestamp);
        p.store(Files.newOutputStream(f.toPath(), new OpenOption[0]), "");
    }

    @Override
    protected void tearDown() throws Exception {
        System.setProperty("eclipse.ignoreUserConfiguration", "false");
        super.tearDown();
    }

    protected void assertIsPropertySet(boolean set) {
        SimpleConfiguratorTest.assertEquals((boolean)set, (boolean)Boolean.TRUE.toString().equalsIgnoreCase(System.getProperty("eclipse.ignoreUserConfiguration")));
    }

    public void testSimpleConfiguration() throws MalformedURLException {
        SimpleConfiguratorTest.assertEquals((Object)this.localConfiguration[0], (Object)this.configurator.chooseConfigurationURL(this.relativeURL, this.localConfiguration));
        this.assertIsPropertySet(false);
    }

    public void testNotExistingConfigiration() throws MalformedURLException {
        SimpleConfiguratorTest.assertNull((Object)this.configurator.chooseConfigurationURL(this.relativeURL, new URL[]{new File(".", "notexisting").toURL()}));
        this.assertIsPropertySet(false);
    }

    public void testSharedConfigurationUserNotExisting() throws MalformedURLException {
        this.sharedConfiguration[0] = new File(".", "notexisting").toURL();
        SimpleConfiguratorTest.assertEquals((Object)this.sharedConfiguration[1], (Object)this.configurator.chooseConfigurationURL(this.relativeURL, this.sharedConfiguration));
        this.assertIsPropertySet(false);
    }

    public void testSharedConfigurationNoTimestamp() throws MalformedURLException {
        SimpleConfiguratorTest.assertEquals((Object)this.sharedConfiguration[0], (Object)this.configurator.chooseConfigurationURL(this.relativeURL, this.sharedConfiguration));
        this.assertIsPropertySet(false);
    }

    public void testSharedConfigurationMasterModified() throws IOException {
        this.storeTimestamp(1000L);
        SimpleConfiguratorTest.assertEquals((Object)this.sharedConfiguration[1], (Object)this.configurator.chooseConfigurationURL(this.relativeURL, this.sharedConfiguration));
        this.assertIsPropertySet(true);
    }

    public void testSharedConfigurationMasterUnmodified() throws IOException {
        this.storeTimestamp(new File(this.masterConfguration, this.relativeURL.getFile()).lastModified());
        SimpleConfiguratorTest.assertEquals((Object)this.sharedConfiguration[0], (Object)this.configurator.chooseConfigurationURL(this.relativeURL, this.sharedConfiguration));
        this.assertIsPropertySet(false);
    }

    public void testSharedConfigurationMasterUnmodifiedPropertySet() throws IOException {
        System.setProperty("eclipse.ignoreUserConfiguration", "true");
        this.storeTimestamp(new File(this.masterConfguration, this.relativeURL.getFile()).lastModified());
        SimpleConfiguratorTest.assertEquals((Object)this.sharedConfiguration[1], (Object)this.configurator.chooseConfigurationURL(this.relativeURL, this.sharedConfiguration));
        this.assertIsPropertySet(true);
    }

    protected void clearLastModified(File file, boolean storeZero) throws IOException {
        long ctime = file.lastModified();
        file.setLastModified(0L);
        try {
            FileTime ft = (FileTime)Files.getAttribute(file.toPath(), "unix:ctime", new LinkOption[0]);
            ctime = ft.toMillis();
        }
        catch (IOException | IllegalArgumentException | UnsupportedOperationException exception) {
            // empty catch block
        }
        if (storeZero) {
            this.storeTimestamp(0L);
        } else {
            this.storeTimestamp(ctime);
        }
    }

    public void testSharedConfigurationMasterModifiedNoMtime() throws IOException {
        if (AbstractSharedInstallTest.WINDOWS) {
            return;
        }
        this.clearLastModified(this.masterConfguration, true);
        SimpleConfiguratorTest.assertEquals((Object)this.sharedConfiguration[1], (Object)this.configurator.chooseConfigurationURL(this.relativeURL, this.sharedConfiguration));
        this.assertIsPropertySet(true);
    }

    public void testSharedConfigurationMasterUnmodifiedNoMtime() throws IOException {
        if (AbstractSharedInstallTest.WINDOWS) {
            return;
        }
        this.clearLastModified(this.masterConfguration, false);
        SimpleConfiguratorTest.assertEquals((Object)this.sharedConfiguration[0], (Object)this.configurator.chooseConfigurationURL(this.relativeURL, this.sharedConfiguration));
        this.assertIsPropertySet(false);
    }
}

