/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.simpleconfigurator;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.List;
import org.eclipse.equinox.internal.simpleconfigurator.Activator;
import org.eclipse.equinox.internal.simpleconfigurator.utils.BundleInfo;
import org.eclipse.equinox.internal.simpleconfigurator.utils.SimpleConfiguratorUtils;
import org.eclipse.equinox.p2.tests.sharedinstall.AbstractSharedInstallTest;
import org.eclipse.equinox.p2.tests.simpleconfigurator.SimpleConfiguratorUtilsExtendedTest;

public class SimpleConfiguratorUtilsExtendedConfiguredTest
extends SimpleConfiguratorUtilsExtendedTest {
    private File testData;
    private File mainBundlesInfo;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.testData = this.getTempFolder();
        SimpleConfiguratorUtilsExtendedConfiguredTest.copy("preparing readonly data", SimpleConfiguratorUtilsExtendedConfiguredTest.getTestData("simpleconfigurator extensions", "testData/simpleConfiguratorExtendedTest"), this.testData);
        this.testData = new File(this.testData, "extensions");
        AbstractSharedInstallTest.setReadOnly(this.testData.getParentFile(), true);
        AbstractSharedInstallTest.reallyReadOnly(this.testData.getParentFile(), true);
        Activator.EXTENSIONS = this.testData.toString();
        this.mainBundlesInfo = SimpleConfiguratorUtilsExtendedConfiguredTest.getTestData("simpleconfigurator extensions - main bundles.info", "testData/simpleConfiguratorExtendedTest/main/bundles.info");
    }

    @Override
    protected void tearDown() throws Exception {
        Activator.EXTENSIONS = null;
        AbstractSharedInstallTest.removeReallyReadOnly(this.testData.getParentFile(), true);
        AbstractSharedInstallTest.setReadOnly(this.testData.getParentFile(), false);
        this.testData.getParentFile().delete();
        super.tearDown();
    }

    public void testMultipleInfoFiles() throws MalformedURLException, IOException {
        List readConfiguration = SimpleConfiguratorUtils.readConfiguration((URL)this.mainBundlesInfo.toURL(), (URI)this.mainBundlesInfo.getParentFile().toURI());
        BundleInfo a = this.getBundle("a", readConfiguration);
        SimpleConfiguratorUtilsExtendedConfiguredTest.assertNotNull((String)"Bundle from the main list not loaded", (Object)a);
        SimpleConfiguratorUtilsExtendedConfiguredTest.assertEquals((String)"Path not resolved properly for the main bundles.info", (Object)new File(this.mainBundlesInfo.getParentFile(), "plugins/a_1.0.0.jar").toURI(), (Object)this.getLocation(a));
        if (!AbstractSharedInstallTest.WINDOWS) {
            BundleInfo b = this.getBundle("b", readConfiguration);
            SimpleConfiguratorUtilsExtendedConfiguredTest.assertNotNull((String)"Bundle from the main list not loaded", (Object)b);
            SimpleConfiguratorUtilsExtendedConfiguredTest.assertEquals((String)"Path not resolved properly for the main bundles.info", (Object)new File("/b_1.0.0.jar").toURI(), (Object)this.getLocation(b));
        }
        BundleInfo x = this.getBundle("x", readConfiguration);
        SimpleConfiguratorUtilsExtendedConfiguredTest.assertNull((String)"This bundle is not listed anywhere!", (Object)x);
        BundleInfo g = this.getBundle("g", readConfiguration);
        SimpleConfiguratorUtilsExtendedConfiguredTest.assertNotNull((String)"Bundle from the direct extension not loaded", (Object)g);
        SimpleConfiguratorUtilsExtendedConfiguredTest.assertEquals((String)"Path not resolved properly from direct extension", (Object)new File(this.testData, "extension1/plugins/g_1.0.0.jar").toURI(), (Object)this.getLocation(g));
        if (!AbstractSharedInstallTest.WINDOWS) {
            BundleInfo h = this.getBundle("h", readConfiguration);
            SimpleConfiguratorUtilsExtendedConfiguredTest.assertNotNull((String)"Bundle from the direct extension not loaded", (Object)h);
            SimpleConfiguratorUtilsExtendedConfiguredTest.assertEquals((String)"Path not resolved properly from direct extension", (Object)new File("/h_1.0.0.jar").toURI(), (Object)this.getLocation(h));
        }
        BundleInfo m = this.getBundle("m", readConfiguration);
        SimpleConfiguratorUtilsExtendedConfiguredTest.assertNotNull((String)"Bundle from the linked extension not loaded", (Object)m);
        SimpleConfiguratorUtilsExtendedConfiguredTest.assertEquals((String)"Path not resolved properly from linked extension", (Object)new File(this.testData.getParentFile(), "extension2/m_1.0.0.jar").toURI(), (Object)this.getLocation(m));
        if (!AbstractSharedInstallTest.WINDOWS) {
            BundleInfo n = this.getBundle("n", readConfiguration);
            SimpleConfiguratorUtilsExtendedConfiguredTest.assertNotNull((String)"Bundle from the linked extension not loaded", (Object)n);
            SimpleConfiguratorUtilsExtendedConfiguredTest.assertEquals((String)"Path not resolved properly from linked extension", (Object)new File("/n_1.0.0.jar").toURI(), (Object)this.getLocation(n));
        }
    }

    public void testMultipleLocations() throws MalformedURLException, IOException {
        Activator.EXTENSIONS = this.testData.toString() + "," + String.valueOf(new File(this.testData.getParentFile(), "extensionsForReconciler1"));
        List readConfiguration = SimpleConfiguratorUtils.readConfiguration((URL)this.mainBundlesInfo.toURL(), (URI)this.mainBundlesInfo.getParentFile().toURI());
        BundleInfo a = this.getBundle("a", readConfiguration);
        SimpleConfiguratorUtilsExtendedConfiguredTest.assertNotNull((String)"Bundle from the main list not loaded", (Object)a);
        SimpleConfiguratorUtilsExtendedConfiguredTest.assertEquals((String)"Path not resolved properly for the main bundles.info", (Object)new File(this.mainBundlesInfo.getParentFile(), "plugins/a_1.0.0.jar").toURI(), (Object)this.getLocation(a));
        if (!AbstractSharedInstallTest.WINDOWS) {
            BundleInfo b = this.getBundle("b", readConfiguration);
            SimpleConfiguratorUtilsExtendedConfiguredTest.assertNotNull((String)"Bundle from the main list not loaded", (Object)b);
            SimpleConfiguratorUtilsExtendedConfiguredTest.assertEquals((String)"Path not resolved properly for the main bundles.info", (Object)new File("/b_1.0.0.jar").toURI(), (Object)this.getLocation(b));
        }
        BundleInfo x = this.getBundle("x", readConfiguration);
        SimpleConfiguratorUtilsExtendedConfiguredTest.assertNull((String)"This bundle is not listed anywhere!", (Object)x);
        BundleInfo g = this.getBundle("g", readConfiguration);
        SimpleConfiguratorUtilsExtendedConfiguredTest.assertNotNull((String)"Bundle from the direct extension not loaded", (Object)g);
        SimpleConfiguratorUtilsExtendedConfiguredTest.assertEquals((String)"Path not resolved properly from direct extension", (Object)new File(this.testData, "extension1/plugins/g_1.0.0.jar").toURI(), (Object)this.getLocation(g));
        if (!AbstractSharedInstallTest.WINDOWS) {
            BundleInfo h = this.getBundle("h", readConfiguration);
            SimpleConfiguratorUtilsExtendedConfiguredTest.assertNotNull((String)"Bundle from the direct extension not loaded", (Object)h);
            SimpleConfiguratorUtilsExtendedConfiguredTest.assertEquals((String)"Path not resolved properly from direct extension", (Object)new File("/h_1.0.0.jar").toURI(), (Object)this.getLocation(h));
        }
        BundleInfo m = this.getBundle("m", readConfiguration);
        SimpleConfiguratorUtilsExtendedConfiguredTest.assertNotNull((String)"Bundle from the linked extension not loaded", (Object)m);
        SimpleConfiguratorUtilsExtendedConfiguredTest.assertEquals((String)"Path not resolved properly from linked extension", (Object)new File(this.testData.getParentFile(), "extension2/m_1.0.0.jar").toURI(), (Object)this.getLocation(m));
        if (!AbstractSharedInstallTest.WINDOWS) {
            BundleInfo n = this.getBundle("n", readConfiguration);
            SimpleConfiguratorUtilsExtendedConfiguredTest.assertNotNull((String)"Bundle from the linked extension not loaded", (Object)n);
            SimpleConfiguratorUtilsExtendedConfiguredTest.assertEquals((String)"Path not resolved properly from linked extension", (Object)new File("/n_1.0.0.jar").toURI(), (Object)this.getLocation(n));
        }
    }

    private BundleInfo getBundle(String name, List<BundleInfo> list) {
        for (BundleInfo info : list) {
            if (!info.getSymbolicName().equals(name)) continue;
            return info;
        }
        return null;
    }

    private URI getLocation(BundleInfo b) {
        if (b.getBaseLocation() != null) {
            return b.getBaseLocation().resolve(b.getLocation());
        }
        return b.getLocation();
    }
}

