/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.simpleconfigurator;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import org.eclipse.equinox.internal.simpleconfigurator.Activator;
import org.eclipse.equinox.internal.simpleconfigurator.utils.BundleInfo;
import org.eclipse.equinox.internal.simpleconfigurator.utils.SimpleConfiguratorUtils;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class SimpleConfiguratorUtilsTest
extends AbstractProvisioningTest {
    private static final boolean WINDOWS = File.separatorChar == '\\';

    public void testParseBundleInfoUNC() throws MalformedURLException, URISyntaxException {
        File baseFile = new File("//SERVER/some/path/");
        URI baseURI = new URI("file:////SERVER/some/path/");
        String canonicalForm = "javax.servlet,2.4.0.v200806031604,plugins/javax.servlet_2.4.0.v200806031604.jar,4,false";
        BundleInfo canonicalInfo = SimpleConfiguratorUtils.parseBundleInfoLine((String)canonicalForm, (URI)baseURI);
        File canonicalFile = new File(baseFile, "plugins/javax.servlet_2.4.0.v200806031604.jar");
        String canonicalFileURLString = canonicalFile.toURL().toExternalForm();
        String[] line = new String[]{"javax.servlet,2.4.0.v200806031604,file:plugins/javax.servlet_2.4.0.v200806031604.jar,4,false", "javax.servlet,2.4.0.v200806031604,plugins\\javax.servlet_2.4.0.v200806031604.jar,4,false", "javax.servlet,2.4.0.v200806031604,file:plugins\\javax.servlet_2.4.0.v200806031604.jar,4,false", "javax.servlet,2.4.0.v200806031604,file:" + canonicalFile.toString() + ",4,false", "javax.servlet,2.4.0.v200806031604," + canonicalFileURLString + ",4,false", "javax.servlet,2.4.0.v200806031604," + canonicalFile.toURI().toString() + ",4,false"};
        String relativeBundleLocation = "reference:file:plugins/javax.servlet_2.4.0.v200806031604.jar";
        String absoluteBundleLocation = "reference:" + canonicalFileURLString;
        int i = 0;
        while (i < line.length) {
            if (line[i].indexOf(92) == -1 || WINDOWS) {
                BundleInfo info = SimpleConfiguratorUtils.parseBundleInfoLine((String)line[i], (URI)baseURI);
                SimpleConfiguratorUtilsTest.assertEquals((String)("[" + i + "]"), (Object)canonicalInfo, (Object)info);
                if (info.getLocation().isAbsolute()) {
                    SimpleConfiguratorUtilsTest.assertEquals((String)("[" + i + "]"), (String)absoluteBundleLocation, (String)SimpleConfiguratorUtils.getBundleLocation((BundleInfo)info, (boolean)true));
                } else {
                    SimpleConfiguratorUtilsTest.assertEquals((String)("[" + i + "]"), (String)relativeBundleLocation, (String)SimpleConfiguratorUtils.getBundleLocation((BundleInfo)info, (boolean)true));
                }
            }
            ++i;
        }
    }

    public void testParseBundleInfo() throws MalformedURLException {
        File baseFile = this.getTempFolder();
        URI baseURI = baseFile.toURI();
        String canonicalForm = "javax.servlet,2.4.0.v200806031604,plugins/javax.servlet_2.4.0.v200806031604.jar,4,false";
        BundleInfo canonicalInfo = SimpleConfiguratorUtils.parseBundleInfoLine((String)canonicalForm, (URI)baseURI);
        File canonicalFile = new File(baseFile, "plugins/javax.servlet_2.4.0.v200806031604.jar");
        String[] line = new String[]{"javax.servlet,2.4.0.v200806031604,file:plugins/javax.servlet_2.4.0.v200806031604.jar,4,false", "javax.servlet,2.4.0.v200806031604,plugins\\javax.servlet_2.4.0.v200806031604.jar,4,false", "javax.servlet,2.4.0.v200806031604,file:plugins\\javax.servlet_2.4.0.v200806031604.jar,4,false", "javax.servlet,2.4.0.v200806031604,file:" + canonicalFile.toString() + ",4,false", "javax.servlet,2.4.0.v200806031604," + canonicalFile.toURL().toExternalForm() + ",4,false", "javax.servlet,2.4.0.v200806031604," + canonicalFile.toURI().toString() + ",4,false"};
        String relativeBundleLocation = "reference:file:plugins/javax.servlet_2.4.0.v200806031604.jar";
        String absoluteBundleLocation = "reference:" + canonicalFile.toURL().toExternalForm();
        int i = 0;
        while (i < line.length) {
            if (line[i].indexOf(92) == -1 || WINDOWS) {
                BundleInfo info = SimpleConfiguratorUtils.parseBundleInfoLine((String)line[i], (URI)baseURI);
                SimpleConfiguratorUtilsTest.assertEquals((String)("[" + i + "]"), (Object)canonicalInfo, (Object)info);
                if (info.getLocation().isAbsolute()) {
                    SimpleConfiguratorUtilsTest.assertEquals((String)("[" + i + "]"), (String)absoluteBundleLocation, (String)SimpleConfiguratorUtils.getBundleLocation((BundleInfo)info, (boolean)true));
                } else {
                    SimpleConfiguratorUtilsTest.assertEquals((String)("[" + i + "]"), (String)relativeBundleLocation, (String)SimpleConfiguratorUtils.getBundleLocation((BundleInfo)info, (boolean)true));
                }
            }
            ++i;
        }
    }

    public void testParseBundleInfoWithSpaces() throws MalformedURLException {
        File baseFile = this.getTempFolder();
        URI baseURI = baseFile.toURI();
        String canonicalForm = "javax.servlet,2.4.0.v200806031604,plugin%20s/javax.servlet_2.4.0.v200806031604.jar,4,false";
        BundleInfo canonicalInfo = SimpleConfiguratorUtils.parseBundleInfoLine((String)canonicalForm, (URI)baseURI);
        File canonicalFile = new File(baseFile, "plugin s/javax.servlet_2.4.0.v200806031604.jar");
        String[] line = new String[]{"javax.servlet,2.4.0.v200806031604,file:plugin s/javax.servlet_2.4.0.v200806031604.jar,4,false", "javax.servlet,2.4.0.v200806031604,plugin s\\javax.servlet_2.4.0.v200806031604.jar,4,false", "javax.servlet,2.4.0.v200806031604,file:plugin s\\javax.servlet_2.4.0.v200806031604.jar,4,false", "javax.servlet,2.4.0.v200806031604,file:" + canonicalFile.toString() + ",4,false", "javax.servlet,2.4.0.v200806031604," + canonicalFile.toURL().toExternalForm() + ",4,false", "javax.servlet,2.4.0.v200806031604," + canonicalFile.toURI().toString() + ",4,false"};
        String relativeBundleLocation = "reference:file:plugin s/javax.servlet_2.4.0.v200806031604.jar";
        String absoluteBundleLocation = "reference:" + canonicalFile.toURL().toExternalForm();
        int i = 0;
        while (i < line.length) {
            if (line[i].indexOf(92) == -1 || WINDOWS) {
                BundleInfo info = SimpleConfiguratorUtils.parseBundleInfoLine((String)line[i], (URI)baseURI);
                SimpleConfiguratorUtilsTest.assertEquals((String)("[" + i + "]"), (Object)canonicalInfo, (Object)info);
                if (info.getLocation().isAbsolute()) {
                    SimpleConfiguratorUtilsTest.assertEquals((String)("[" + i + "]"), (String)absoluteBundleLocation, (String)SimpleConfiguratorUtils.getBundleLocation((BundleInfo)info, (boolean)true));
                } else {
                    SimpleConfiguratorUtilsTest.assertEquals((String)("[" + i + "]"), (String)relativeBundleLocation, (String)SimpleConfiguratorUtils.getBundleLocation((BundleInfo)info, (boolean)true));
                }
            }
            ++i;
        }
    }

    public void testParseUNCBundleInfo() throws MalformedURLException {
        if (!WINDOWS) {
            return;
        }
        File baseFile = new File("\\\\127.0.0.1\\somefolder\\");
        URI baseURI = baseFile.toURI();
        String canonicalForm = "javax.servlet,2.4.0.v200806031604,plugins/javax.servlet_2.4.0.v200806031604.jar,4,false";
        BundleInfo canonicalInfo = SimpleConfiguratorUtils.parseBundleInfoLine((String)canonicalForm, (URI)baseURI);
        File canonicalFile = new File(baseFile, "plugins/javax.servlet_2.4.0.v200806031604.jar");
        String[] line = new String[]{"javax.servlet,2.4.0.v200806031604,file:plugins/javax.servlet_2.4.0.v200806031604.jar,4,false", "javax.servlet,2.4.0.v200806031604,plugins\\javax.servlet_2.4.0.v200806031604.jar,4,false", "javax.servlet,2.4.0.v200806031604,file:plugins\\javax.servlet_2.4.0.v200806031604.jar,4,false"};
        String relativeBundleLocation = "reference:file:plugins/javax.servlet_2.4.0.v200806031604.jar";
        String absoluteBundleLocation = "reference:" + canonicalFile.toURL().toExternalForm();
        int i = 0;
        while (i < line.length) {
            BundleInfo info = SimpleConfiguratorUtils.parseBundleInfoLine((String)line[i], (URI)baseURI);
            SimpleConfiguratorUtilsTest.assertEquals((String)("[" + i + "]"), (Object)canonicalInfo, (Object)info);
            if (info.getLocation().isAbsolute()) {
                SimpleConfiguratorUtilsTest.assertEquals((String)("[" + i + "]"), (String)absoluteBundleLocation, (String)SimpleConfiguratorUtils.getBundleLocation((BundleInfo)info, (boolean)true));
            } else {
                SimpleConfiguratorUtilsTest.assertEquals((String)("[" + i + "]"), (String)relativeBundleLocation, (String)SimpleConfiguratorUtils.getBundleLocation((BundleInfo)info, (boolean)true));
            }
            ++i;
        }
    }

    public void testRead34BundlesInfo() {
        File data = SimpleConfiguratorUtilsTest.getTestData("1.0", "testData/simpleConfiguratorTest/3.4.bundles.info");
        File baseFile = this.getTempFolder();
        URI baseURI = baseFile.toURI();
        try {
            List infos = SimpleConfiguratorUtils.readConfiguration((URL)data.toURL(), (URI)baseURI);
            if (Activator.EXTENSIONS == null) {
                SimpleConfiguratorUtilsTest.assertEquals((String)"1.1", (int)2, (int)infos.size());
            } else {
                SimpleConfiguratorUtilsTest.assertEquals((String)"1.1", (int)6, (int)infos.size());
            }
            BundleInfo a = new BundleInfo("a", "1.0.0", new URI("plugins/a_1.0.0.jar"), 4, false);
            a.setBaseLocation(baseURI);
            BundleInfo b = new BundleInfo("b", "1.0.0", new URI("plugins/b_1.0.0.jar"), -1, true);
            b.setBaseLocation(baseURI);
            SimpleConfiguratorUtilsTest.assertEquals((String)"1.2", (Object)a, infos.get(0));
            SimpleConfiguratorUtilsTest.assertEquals((String)"1.3", (Object)b, infos.get(1));
        }
        catch (URISyntaxException e) {
            SimpleConfiguratorUtilsTest.fail("1.97", e);
        }
        catch (MalformedURLException e) {
            SimpleConfiguratorUtilsTest.fail("1.98", e);
        }
        catch (IOException e) {
            SimpleConfiguratorUtilsTest.fail("1.99", e);
        }
    }

    public void testReadVersionLine() {
        String versionPrefix = "#version=";
        SimpleConfiguratorUtils.parseCommentLine((String)(versionPrefix + "1"));
        try {
            SimpleConfiguratorUtils.parseCommentLine((String)(versionPrefix + "999"));
        }
        catch (IllegalArgumentException e) {
            return;
        }
        SimpleConfiguratorUtilsTest.fail((String)"improper version error not caught");
    }

    public void testReadMissingBundleInfo() throws MalformedURLException, IOException {
        File bundleInfoFile = new File(this.getTempFolder(), "bundle.info");
        SimpleConfiguratorUtilsTest.assertFalse((boolean)bundleInfoFile.exists());
        if (Activator.EXTENSIONS == null) {
            SimpleConfiguratorUtilsTest.assertEquals((int)0, (int)SimpleConfiguratorUtils.readConfiguration((URL)bundleInfoFile.toURL(), null).size());
        } else {
            SimpleConfiguratorUtilsTest.assertEquals((int)4, (int)SimpleConfiguratorUtils.readConfiguration((URL)bundleInfoFile.toURL(), null).size());
        }
    }
}

