/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.simpleconfigurator.manipulator;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.equinox.internal.simpleconfigurator.Activator;
import org.eclipse.equinox.internal.simpleconfigurator.manipulator.SimpleConfiguratorManipulatorImpl;
import org.eclipse.equinox.internal.simpleconfigurator.utils.EquinoxUtils;
import org.eclipse.equinox.internal.simpleconfigurator.utils.URIUtil;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.p2.tests.TestActivator;
import org.eclipse.equinox.p2.tests.reconciler.dropins.SharedInstallTests;
import org.eclipse.equinox.p2.tests.sharedinstall.AbstractSharedInstallTest;
import org.osgi.framework.BundleContext;

public class SimpleConfiguratorManipulatorTests
extends AbstractProvisioningTest {
    public void testSaveConfiguration() throws Exception {
        File folder = this.getTestFolder("saveConfiguration");
        File infoFile = new File(folder, "bundle.info");
        URI baseFile = this.getTempFolder().toURI();
        BundleInfo[] bundles = new BundleInfo[]{new BundleInfo("a", "1.0.0", new File(folder, "plugins/a_1.0.0.jar").toURI(), -1, false)};
        SimpleConfiguratorManipulatorImpl manipulator = new SimpleConfiguratorManipulatorImpl();
        manipulator.saveConfiguration(bundles, infoFile, folder.toURI());
        bundles = manipulator.loadConfiguration(Files.newInputStream(infoFile.toPath(), new OpenOption[0]), baseFile);
        SimpleConfiguratorManipulatorTests.assertEquals((Object)bundles[0].getLocation(), (Object)URIUtil.append((URI)baseFile, (String)"plugins/a_1.0.0.jar"));
        bundles = new BundleInfo[]{new BundleInfo("b", "1.0.0", new URI("plugins/b_1.0.0.jar"), -1, false)};
        manipulator.saveConfiguration(bundles, infoFile, null);
        bundles = manipulator.loadConfiguration(Files.newInputStream(infoFile.toPath(), new OpenOption[0]), baseFile);
        SimpleConfiguratorManipulatorTests.assertEquals((Object)bundles[0].getLocation(), (Object)URIUtil.append((URI)baseFile, (String)"plugins/b_1.0.0.jar"));
        URI absolute = new File(folder, "plugins/c_1.0.0.jar").toURI();
        bundles = new BundleInfo[]{new BundleInfo("c", "1.0.0", absolute, -1, false)};
        manipulator.saveConfiguration(bundles, infoFile, null);
        bundles = manipulator.loadConfiguration(Files.newInputStream(infoFile.toPath(), new OpenOption[0]), baseFile);
        SimpleConfiguratorManipulatorTests.assertEquals((Object)bundles[0].getLocation(), (Object)absolute);
    }

    public void testLocationEncoding() throws Exception {
        File folder = this.getTestFolder("locationEncoding");
        File configurationFile = new File(folder, "bundle.info");
        BundleInfo[] bundles = new BundleInfo[]{new BundleInfo("a", "1.0.0", new File(folder, "plu%2Cins/a_1.0.0.jar").toURI(), -1, false), new BundleInfo("b", "1.0.0", new File(folder, "plu,ins/b_1.0.0.jar").toURI(), -1, false)};
        SimpleConfiguratorManipulatorImpl manipulator = new SimpleConfiguratorManipulatorImpl();
        manipulator.saveConfiguration(bundles, configurationFile, folder.toURI());
        bundles = manipulator.loadConfiguration(Files.newInputStream(configurationFile.toPath(), new OpenOption[0]), folder.toURI());
        SimpleConfiguratorManipulatorTests.assertEquals((Object)bundles[0].getLocation(), (Object)new File(folder, "plu%2Cins/a_1.0.0.jar").toURI());
        SimpleConfiguratorManipulatorTests.assertEquals((Object)bundles[1].getLocation(), (Object)new File(folder, "plu,ins/b_1.0.0.jar").toURI());
    }

    public void testUTF8Encoding() throws Exception {
        File folder = this.getTestFolder("utf8Test");
        File configurationFile = new File(folder, "bundle.info");
        BundleInfo[] bundles = new BundleInfo[]{new BundleInfo("a", "1.0.0", new File(folder, "\u0ca0_\u0ca0.jar").toURI(), -1, false)};
        SimpleConfiguratorManipulatorImpl manipulator = new SimpleConfiguratorManipulatorImpl();
        manipulator.saveConfiguration(bundles, configurationFile, folder.toURI());
        bundles = manipulator.loadConfiguration(Files.newInputStream(configurationFile.toPath(), new OpenOption[0]), folder.toURI());
        SimpleConfiguratorManipulatorTests.assertEquals((Object)bundles[0].getLocation(), (Object)new File(folder, "\u0ca0_\u0ca0.jar").toURI());
    }

    public void testLoadConfigurationExtended() throws Exception {
        URI installArea = EquinoxUtils.getInstallLocationURI((BundleContext)TestActivator.getContext());
        File mainTestData = SimpleConfiguratorManipulatorTests.getTestData("0.0", "testData/simpleConfiguratorExtendedTest/main/bundles.info");
        URL configURL = EquinoxUtils.getConfigLocation((BundleContext)TestActivator.getContext()).getDataArea("org.eclipse.equinox.simpleconfigurator/bundles.info");
        File target = new File(configURL.getPath());
        target.getParentFile().mkdirs();
        target.createNewFile();
        SimpleConfiguratorManipulatorTests.copy("Copying ..", mainTestData, target);
        File fragTestData = SimpleConfiguratorManipulatorTests.getTestData("0.1", "/testData/simpleConfiguratorExtendedTest");
        File fragDir = this.getTempFolder();
        SimpleConfiguratorManipulatorTests.copy("Copying ..", fragTestData, fragDir);
        SharedInstallTests.setReadOnly(fragDir, true);
        AbstractSharedInstallTest.reallyReadOnly(fragDir, true);
        Activator.EXTENDED = true;
        Activator.EXTENSIONS = fragDir.getAbsolutePath();
        List<String> expected = Arrays.asList("m,1.0.0", "n,1.0.0", "a,1.0.0", "b,1.0.0");
        SimpleConfiguratorManipulatorImpl manipulator = new SimpleConfiguratorManipulatorImpl();
        BundleInfo[] installedInfo = manipulator.loadConfiguration(configURL.openStream(), installArea);
        BundleInfo[] installedAndExtendedInfo = manipulator.loadConfiguration(TestActivator.getContext(), "org.eclipse.equinox.simpleconfigurator/bundles.info");
        List<BundleInfo> installedAndExtendedL = Arrays.asList(installedAndExtendedInfo);
        List<BundleInfo> installedL = Arrays.asList(installedInfo);
        ArrayList<BundleInfo> extendedL = new ArrayList<BundleInfo>(installedAndExtendedL);
        extendedL.removeAll(installedL);
        SimpleConfiguratorManipulatorTests.assertTrue((boolean)installedAndExtendedL.containsAll(installedL));
        SimpleConfiguratorManipulatorTests.assertFalse((boolean)extendedL.isEmpty());
        for (BundleInfo b : extendedL) {
            String actual = b.getSymbolicName() + "," + b.getVersion();
            if (expected.contains(actual)) continue;
            SimpleConfiguratorManipulatorTests.fail((String)(actual + " Could not be found in the list of expected bundle info entries."));
        }
        AbstractSharedInstallTest.removeReallyReadOnly(fragDir, true);
        SharedInstallTests.setReadOnly(fragDir, false);
    }
}

