/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.touchpoint.eclipse;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.p2.metadata.TouchpointInstruction;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.Util;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.actions.AddRepositoryAction;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.ProfileScope;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.ITouchpointData;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class AddRepositoryActionTest
extends AbstractProvisioningTest {
    private static final String TEST_LOCATION = "http://eclipse.org/eclipse/updates/AddRepositoryActionTest";
    private static final String KEY_URI = "uri";
    AddRepositoryAction action;
    private URI locationURI;

    private Map<String, Object> getValidArguments() {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("location", TEST_LOCATION);
        args.put("type", Integer.toString(1));
        args.put("enabled", "true");
        return args;
    }

    private Map<String, String> getValidStringArguments() {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("location", TEST_LOCATION);
        args.put("type", Integer.toString(1));
        args.put("enabled", "true");
        return args;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.action = new AddRepositoryAction();
        this.locationURI = new URI(TEST_LOCATION);
        AddRepositoryActionTest.getArtifactRepositoryManager().removeRepository(this.locationURI);
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        AddRepositoryActionTest.getArtifactRepositoryManager().removeRepository(this.locationURI);
    }

    public void testInvalidEnablement() {
        Map<String, Object> args = this.getValidArguments();
        this.addAgent(args);
        args.put("enabled", "bogus enablement");
        IStatus result = this.action.execute(args);
        AddRepositoryActionTest.assertTrue((String)"1.0", (boolean)result.isOK());
        AddRepositoryActionTest.assertTrue((String)"1.1", (!AddRepositoryActionTest.getArtifactRepositoryManager().isEnabled(this.locationURI) ? 1 : 0) != 0);
    }

    private void addAgent(Map<String, Object> args) {
        args.put("agent", AddRepositoryActionTest.getAgent());
    }

    public void testInvalidLocation() {
        Map<String, Object> args = this.getValidArguments();
        this.addAgent(args);
        args.put("location", "bogus location");
        IStatus result = this.action.execute(args);
        AddRepositoryActionTest.assertTrue((String)"1.0", (!result.isOK() ? 1 : 0) != 0);
    }

    public void testInvalidType() {
        Map<String, Object> args = this.getValidArguments();
        this.addAgent(args);
        args.put("type", "bogus type");
        IStatus result = this.action.execute(args);
        AddRepositoryActionTest.assertTrue((String)"1.0", (!result.isOK() ? 1 : 0) != 0);
    }

    public void testMissingEnablement() {
        Map<String, Object> args = this.getValidArguments();
        this.addAgent(args);
        args.remove("enabled");
        IStatus result = this.action.execute(args);
        AddRepositoryActionTest.assertTrue((String)"1.0", (boolean)result.isOK());
    }

    public void testMissingType() {
        Map<String, Object> args = this.getValidArguments();
        this.addAgent(args);
        args.remove("type");
        IStatus result = this.action.execute(args);
        AddRepositoryActionTest.assertTrue((String)"1.0", (!result.isOK() ? 1 : 0) != 0);
    }

    public void testNoArguments() {
        IStatus result = this.action.execute(new HashMap());
        AddRepositoryActionTest.assertTrue((String)"1.0", (!result.isOK() ? 1 : 0) != 0);
    }

    public void testUndo() {
        Map<String, Object> args = this.getValidArguments();
        this.addAgent(args);
        IStatus result = this.action.execute(args);
        AddRepositoryActionTest.assertTrue((String)"1.0", (boolean)result.isOK());
        result = this.action.undo(args);
        AddRepositoryActionTest.assertTrue((String)"1.1", (boolean)result.isOK());
    }

    public void testMultipleActionAdd() {
        Map<String, Object> args = this.getValidArguments();
        this.addAgent(args);
        IStatus result = this.action.execute(args);
        AddRepositoryActionTest.assertTrue((String)"1.0", (boolean)result.isOK());
        result = this.action.execute(args);
        AddRepositoryActionTest.assertTrue((String)"1.1", (boolean)result.isOK());
        result = this.action.undo(args);
        AddRepositoryActionTest.assertTrue((String)"1.2", (boolean)result.isOK());
        AddRepositoryActionTest.assertTrue((String)"2.0", (boolean)this.locationExists(null, TEST_LOCATION));
    }

    public void testUserWins() {
        try {
            AddRepositoryActionTest.getArtifactRepositoryManager().addRepository(new URI(TEST_LOCATION));
            AddRepositoryActionTest.assertTrue((String)"0.1", (boolean)this.locationExists(null, TEST_LOCATION));
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        Map<String, Object> args = this.getValidArguments();
        this.addAgent(args);
        IStatus result = this.action.execute(args);
        AddRepositoryActionTest.assertTrue((String)"1.0", (boolean)result.isOK());
        result = this.action.undo(args);
        AddRepositoryActionTest.assertTrue((String)"1.1", (boolean)result.isOK());
        AddRepositoryActionTest.assertTrue((String)"2.0", (boolean)this.locationExists(null, TEST_LOCATION));
    }

    public void testFullInstall() {
        String id = "AddRepositoryActionTest.testFullInstall";
        Version version = Version.createOSGi((int)1, (int)0, (int)0);
        HashMap<String, String> instructions = new HashMap<String, String>();
        instructions.put("configure", TouchpointInstruction.encodeAction((String)"addRepository", this.getValidStringArguments()));
        ITouchpointData tpData = MetadataFactory.createTouchpointData(instructions);
        IInstallableUnit iu = AddRepositoryActionTest.createIU(id, version, null, (IRequirement[])NO_REQUIRES, NO_PROVIDES, NO_PROPERTIES, TOUCHPOINT_OSGI, tpData, true, this.createUpdateDescriptor(id, version), null);
        IProfile profile = this.createProfile(id);
        ProfileChangeRequest request = new ProfileChangeRequest(profile);
        request.addInstallableUnits(new IInstallableUnit[]{iu});
        AddRepositoryActionTest.assertTrue((String)"0.1", (!AddRepositoryActionTest.getArtifactRepositoryManager().contains(this.locationURI) ? 1 : 0) != 0);
        IStatus result = AddRepositoryActionTest.createDirector().provision((IProfileChangeRequest)request, new ProvisioningContext(AddRepositoryActionTest.getAgent()), this.getMonitor());
        AddRepositoryActionTest.assertTrue((String)"1.0", (boolean)result.isOK());
        profile = this.getProfile(id);
        IEclipsePreferences pref = new ProfileScope(AddRepositoryActionTest.getAgentLocation(), profile.getProfileId()).getNode("org.eclipse.equinox.p2.artifact.repository/repositories/" + this.getKey(TEST_LOCATION));
        String value = pref.get(KEY_URI, null);
        AddRepositoryActionTest.assertEquals((String)"2.0", (String)value, (String)TEST_LOCATION);
    }

    public void testBug266881() throws ProvisionException {
        URI site = AddRepositoryActionTest.getTestData("0.1", "/testData/testRepos/simple.1").toURI();
        AddRepositoryActionTest.getMetadataRepositoryManager().addRepository(site);
        AddRepositoryActionTest.getArtifactRepositoryManager().addRepository(site);
        String id = "AddRepositoryActionTest.testUpdate";
        Version version = Version.createOSGi((int)1, (int)0, (int)0);
        IInstallableUnit oldIU = AddRepositoryActionTest.createIU(id, version);
        IProfile profile = this.createProfile(id);
        ProfileChangeRequest request = new ProfileChangeRequest(profile);
        IInstallableUnit[] oldIUs = new IInstallableUnit[]{oldIU};
        request.addInstallableUnits(oldIUs);
        IStatus result = AddRepositoryActionTest.createDirector().provision((IProfileChangeRequest)request, new ProvisioningContext(AddRepositoryActionTest.getAgent()), this.getMonitor());
        AddRepositoryActionTest.assertTrue((String)"1.0", (boolean)result.isOK());
        AddRepositoryActionTest.assertTrue((String)"1.1", (!AddRepositoryActionTest.getArtifactRepositoryManager().contains(this.locationURI) ? 1 : 0) != 0);
        version = Version.createOSGi((int)1, (int)1, (int)0);
        HashMap<String, String> instructions = new HashMap<String, String>();
        instructions.put("configure", TouchpointInstruction.encodeAction((String)"addRepository", this.getValidStringArguments()));
        ITouchpointData tpData = MetadataFactory.createTouchpointData(instructions);
        IInstallableUnit newIU = AddRepositoryActionTest.createIU(id, version, null, (IRequirement[])NO_REQUIRES, NO_PROVIDES, NO_PROPERTIES, TOUCHPOINT_OSGI, tpData, true, this.createUpdateDescriptor(id, version), null);
        IMetadataRepository repo = AddRepositoryActionTest.getMetadataRepositoryManager().loadRepository(site, this.getMonitor());
        IInstallableUnit bundle = (IInstallableUnit)repo.query(QueryUtil.createIUQuery((String)"aBundle"), this.getMonitor()).iterator().next();
        request = new ProfileChangeRequest(profile);
        IInstallableUnit[] newIUs = new IInstallableUnit[]{newIU, bundle};
        request.addInstallableUnits(newIUs);
        request.removeInstallableUnits(oldIUs);
        result = AddRepositoryActionTest.createDirector().provision((IProfileChangeRequest)request, new ProvisioningContext(AddRepositoryActionTest.getAgent()), this.getMonitor());
        if (!result.isOK()) {
            LogHelper.log((IStatus)result);
        }
        AddRepositoryActionTest.assertTrue((String)"2.0", (boolean)result.isOK());
        profile = this.getProfile(id);
        IArtifactRepository artifacts = AddRepositoryActionTest.getArtifactRepositoryManager().loadRepository(Util.getBundlePoolLocation((IProvisioningAgent)AddRepositoryActionTest.getAgent(), (IProfile)profile), this.getMonitor());
        AddRepositoryActionTest.assertEquals((String)"3.0", (int)1, (int)this.getArtifactKeyCount(artifacts));
        AddRepositoryActionTest.assertProfileContains("3.1", profile, newIUs);
        IEclipsePreferences pref = new ProfileScope(AddRepositoryActionTest.getAgentLocation(), profile.getProfileId()).getNode("org.eclipse.equinox.p2.artifact.repository/repositories/" + this.getKey(TEST_LOCATION));
        String value = pref.get(KEY_URI, null);
        AddRepositoryActionTest.assertEquals((String)"3.2", (String)value, (String)TEST_LOCATION);
    }

    private String getKey(String location) {
        String key = location.replace('/', '_');
        if (key.endsWith("_")) {
            key = key.substring(0, key.length() - 1);
        }
        return key;
    }

    private boolean locationExists(IProfile profile, String location) {
        String profileId = profile != null ? profile.getProfileId() : "_SELF_";
        IEclipsePreferences pref = new ProfileScope(AddRepositoryActionTest.getAgentLocation(), profileId).getNode("org.eclipse.equinox.p2.artifact.repository/repositories/" + this.getKey(location));
        return location.equals(pref.get(KEY_URI, null));
    }
}

