/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.touchpoint.eclipse;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.equinox.internal.p2.engine.InstallableUnitOperand;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.EclipseTouchpoint;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.SourceManipulator;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.Util;
import org.eclipse.equinox.internal.p2.touchpoint.eclipse.actions.RemoveSourceBundleAction;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.publisher.eclipse.BundlesAction;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IFileArtifactRepository;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.spi.p2.publisher.PublisherHelper;
import org.eclipse.osgi.service.resolver.BundleDescription;

public class RemoveSourceBundleActionTest
extends AbstractProvisioningTest {
    public RemoveSourceBundleActionTest(String name) {
        super(name);
    }

    public RemoveSourceBundleActionTest() {
        super("");
    }

    public void testExecuteUndo() throws Exception {
        HashMap<String, String> profileProperties = new HashMap<String, String>();
        File installFolder = this.getTempFolder();
        profileProperties.put("org.eclipse.equinox.p2.installFolder", installFolder.toString());
        profileProperties.put("org.eclipse.equinox.p2.cache", installFolder.toString());
        IProfile profile = this.createProfile("test", profileProperties);
        IFileArtifactRepository bundlePool = Util.getBundlePoolRepository((IProvisioningAgent)RemoveSourceBundleActionTest.getAgent(), (IProfile)profile);
        File osgiSource = RemoveSourceBundleActionTest.getTestData("1.0", "/testData/eclipseTouchpoint/bundles/org.eclipse.osgi.source_3.4.2.R34x_v20080826-1230.jar");
        File targetPlugins = new File(installFolder, "plugins");
        RemoveSourceBundleActionTest.assertTrue((boolean)targetPlugins.mkdir());
        File osgiTarget = new File(targetPlugins, "org.eclipse.osgi.source_3.4.2.R34x_v20080826-1230.jar");
        RemoveSourceBundleActionTest.copy("2.0", osgiSource, osgiTarget);
        BundleDescription bundleDescription = BundlesAction.createBundleDescription((File)osgiTarget);
        IArtifactKey key = BundlesAction.createBundleArtifactKey((String)bundleDescription.getSymbolicName(), (String)bundleDescription.getVersion().toString());
        IArtifactDescriptor descriptor = PublisherHelper.createArtifactDescriptor((IArtifactKey)key, (File)osgiTarget);
        IInstallableUnit iu = this.createBundleIU(bundleDescription, osgiTarget.isDirectory(), key);
        bundlePool.addDescriptor(descriptor, (IProgressMonitor)new NullProgressMonitor());
        Map parameters = new HashMap<String, Object>();
        parameters.put("agent", RemoveSourceBundleActionTest.getAgent());
        parameters.put("profile", profile);
        EclipseTouchpoint touchpoint = new EclipseTouchpoint();
        touchpoint.initializePhase(null, profile, "test", parameters);
        InstallableUnitOperand operand = new InstallableUnitOperand(null, iu);
        parameters.put("iu", operand.second());
        touchpoint.initializeOperand(profile, parameters);
        parameters.put("bundle", key.toString());
        parameters = Collections.unmodifiableMap(parameters);
        SourceManipulator manipulator = (SourceManipulator)parameters.get("sourceBundles");
        RemoveSourceBundleActionTest.assertNotNull((Object)manipulator);
        manipulator.addBundle(osgiTarget, key.getId(), key.getVersion());
        RemoveSourceBundleActionTest.assertTrue((boolean)this.inBundles(manipulator, osgiTarget));
        RemoveSourceBundleAction action = new RemoveSourceBundleAction();
        action.execute(parameters);
        RemoveSourceBundleActionTest.assertFalse((boolean)this.inBundles(manipulator, osgiTarget));
        action.undo(parameters);
        RemoveSourceBundleActionTest.assertTrue((boolean)this.inBundles(manipulator, osgiTarget));
    }

    private boolean inBundles(SourceManipulator manipulator, File osgiTarget) throws IOException {
        BundleInfo[] bundles;
        URI location = osgiTarget.toURI();
        BundleInfo[] bundleInfoArray = bundles = manipulator.getBundles();
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            BundleInfo bundle = bundleInfoArray[n2];
            if (location.equals(bundle.getLocation())) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

