/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.touchpoint.natives;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.equinox.internal.p2.touchpoint.natives.IBackupStore;
import org.eclipse.equinox.internal.p2.touchpoint.natives.NativeTouchpoint;
import org.eclipse.equinox.internal.p2.touchpoint.natives.actions.RmdirAction;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class RmdirActionTest
extends AbstractProvisioningTest {
    public RmdirActionTest(String name) {
        super(name);
    }

    public RmdirActionTest() {
        super("");
    }

    public void testExecuteUndo() {
        HashMap<String, String> profileProperties = new HashMap<String, String>();
        File installFolder = this.getTempFolder();
        profileProperties.put("org.eclipse.equinox.p2.installFolder", installFolder.toString());
        IProfile profile = this.createProfile("testExecuteUndo", profileProperties);
        Map parameters = new HashMap<String, Object>();
        parameters.put("profile", profile);
        NativeTouchpoint touchpoint = new NativeTouchpoint();
        touchpoint.initializePhase(null, profile, "testExecuteUndo", parameters);
        File testFolder = new File(installFolder, "testExecuteUndo");
        parameters.put("path", testFolder.getAbsolutePath());
        parameters = Collections.unmodifiableMap(parameters);
        testFolder.mkdir();
        RmdirActionTest.assertTrue((boolean)testFolder.exists());
        RmdirAction action = new RmdirAction();
        action.execute(parameters);
        RmdirActionTest.assertFalse((boolean)testFolder.exists());
        action.undo(parameters);
        IBackupStore store = (IBackupStore)parameters.get("backup");
        if (store != null) {
            try {
                store.restore();
            }
            catch (IOException e) {
                RmdirActionTest.fail((String)"Restore of backup failed");
            }
        }
        RmdirActionTest.assertTrue((boolean)testFolder.exists());
        if (store != null) {
            store.discard();
        }
        testFolder.delete();
    }
}

