/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.touchpoint.natives;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import org.eclipse.equinox.internal.p2.touchpoint.natives.SimpleBackupStore;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;

public class SimpleBackupStoreTest
extends AbstractProvisioningTest {
    private static final String BACKUP_PREFIX = "backup-test";
    private Path sourceDir;
    private Path aDir;
    private Path aaDir;
    private Path aFile;

    @Override
    public void setUp() throws IOException {
        String userHome = System.getProperty("user.home");
        this.sourceDir = Path.of(userHome, "p2-backup-test");
        SimpleBackupStoreTest.deleteAll(this.sourceDir);
        this.aDir = this.sourceDir.resolve("a");
        Files.createDirectories(this.aDir, new FileAttribute[0]);
        this.aaDir = this.aDir.resolve("aa");
        Files.createDirectories(this.aaDir, new FileAttribute[0]);
        this.aFile = this.aaDir.resolve("eclipse.exe");
        Files.createFile(this.aFile, new FileAttribute[0]);
    }

    @Override
    public void tearDown() throws IOException {
        SimpleBackupStoreTest.deleteAll(this.sourceDir);
    }

    private static void deleteAll(Path path) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                if (exc != null) {
                    throw exc;
                }
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public void testBackupInPlace() throws IOException {
        class TestMoveInPlaceStore
        extends SimpleBackupStore {
            public TestMoveInPlaceStore() {
                super(null, SimpleBackupStoreTest.BACKUP_PREFIX);
            }

            public Path toInPlaceBackupPath(Path path) {
                return super.toInPlaceBackupPath(path);
            }

            protected void move(Path a, Path b) throws IOException {
                if (b.equals(this.toInPlaceBackupPath(a))) {
                    super.move(a, b);
                } else if (a.equals(this.toInPlaceBackupPath(b))) {
                    super.move(a, b);
                } else if (a.getFileName().endsWith("eclipse.exe")) {
                    Files.copy(a, b, new CopyOption[0]);
                } else {
                    throw new IOException("Test fail move: " + String.valueOf(a) + " -> " + String.valueOf(b));
                }
            }
        }
        TestMoveInPlaceStore buStore = new TestMoveInPlaceStore();
        Path path = this.aFile;
        Path inPlaceBuPath = buStore.toInPlaceBackupPath(this.aFile);
        buStore.backup(path.toFile());
        SimpleBackupStoreTest.assertFalse((boolean)Files.exists(path, new LinkOption[0]));
        SimpleBackupStoreTest.assertTrue((boolean)Files.exists(inPlaceBuPath, new LinkOption[0]));
        buStore.restore();
        SimpleBackupStoreTest.assertTrue((boolean)Files.exists(path, new LinkOption[0]));
        SimpleBackupStoreTest.assertFalse((boolean)Files.exists(inPlaceBuPath, new LinkOption[0]));
    }

    public void testNoBackupInPlace() throws IOException {
        class TestNoBackupInPlaceStore
        extends SimpleBackupStore {
            public TestNoBackupInPlaceStore() {
                super(null, SimpleBackupStoreTest.BACKUP_PREFIX);
            }

            public Path toInPlaceBackupPath(Path path) {
                return super.toInPlaceBackupPath(path);
            }
        }
        TestNoBackupInPlaceStore buStore = new TestNoBackupInPlaceStore();
        Path path = this.aFile;
        Path inPlaceBuPath = buStore.toInPlaceBackupPath(this.aFile);
        buStore.backup(path.toFile());
        SimpleBackupStoreTest.assertFalse((boolean)Files.exists(path, new LinkOption[0]));
        SimpleBackupStoreTest.assertFalse((boolean)Files.exists(inPlaceBuPath, new LinkOption[0]));
        buStore.restore();
        SimpleBackupStoreTest.assertTrue((boolean)Files.exists(path, new LinkOption[0]));
    }
}

