/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.updatechecker;

import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.internal.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.internal.provisional.p2.director.IDirector;
import org.eclipse.equinox.internal.provisional.p2.updatechecker.IUpdateChecker;
import org.eclipse.equinox.internal.provisional.p2.updatechecker.IUpdateListener;
import org.eclipse.equinox.internal.provisional.p2.updatechecker.UpdateEvent;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.ITouchpointType;
import org.eclipse.equinox.p2.metadata.IUpdateDescriptor;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.p2.tests.TestActivator;
import org.eclipse.equinox.p2.tests.updatechecker.TestUpdateListener;

public class UpdateCheckerTest
extends AbstractProvisioningTest {
    IProfile profile;
    IInstallableUnit toInstallIU;
    IInstallableUnit update;

    protected IUpdateChecker getChecker() {
        IUpdateChecker checker = (IUpdateChecker)UpdateCheckerTest.getAgent().getService(IUpdateChecker.class);
        UpdateCheckerTest.assertNotNull((Object)checker);
        return checker;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        UpdateCheckerTest.startBundle(TestActivator.getBundle("org.eclipse.equinox.p2.updatechecker"));
        String id = "toInstall." + this.getName();
        this.toInstallIU = UpdateCheckerTest.createIU(id, Version.createOSGi((int)1, (int)0, (int)0));
        IUpdateDescriptor updateDescriptor = this.createUpdateDescriptor(id, Version.createOSGi((int)2, (int)0, (int)0));
        this.update = UpdateCheckerTest.createIU(id, Version.createOSGi((int)2, (int)0, (int)0), null, (IRequirement[])NO_REQUIRES, NO_PROVIDES, NO_PROPERTIES, ITouchpointType.NONE, NO_TP_DATA, true, updateDescriptor, null);
        IInstallableUnit[] allUnits = new IInstallableUnit[]{this.toInstallIU, this.update};
        IInstallableUnit[] toInstallArray = new IInstallableUnit[]{this.toInstallIU};
        this.createTestMetdataRepository(allUnits);
        this.profile = this.createProfile("TestProfile." + this.getName());
        IDirector director = UpdateCheckerTest.createDirector();
        ProfileChangeRequest request = new ProfileChangeRequest(this.profile);
        request.addInstallableUnits(toInstallArray);
        IStatus result = director.provision((IProfileChangeRequest)request, null, null);
        UpdateCheckerTest.assertTrue((String)"setup.1", (boolean)result.isOK());
    }

    public void testAddListener() {
        IUpdateChecker checker = this.getChecker();
        ArrayList<IInstallableUnit> toUpdate = new ArrayList<IInstallableUnit>();
        toUpdate.add(this.toInstallIU);
        TestUpdateListener listener = new TestUpdateListener(new UpdateEvent(this.profile.getProfileId(), toUpdate));
        checker.addUpdateCheck(this.profile.getProfileId(), QueryUtil.createIUAnyQuery(), -1L, 0L, (IUpdateListener)listener);
        listener.waitForEvent();
        listener.verify(1);
        listener.reset();
        checker.addUpdateCheck(this.profile.getProfileId(), QueryUtil.createIUAnyQuery(), -1L, 0L, (IUpdateListener)listener);
        listener.waitForEvent();
        listener.verify(0);
        listener.reset();
        checker.removeUpdateCheck((IUpdateListener)listener);
        checker.addUpdateCheck(this.profile.getProfileId(), QueryUtil.createIUAnyQuery(), -1L, 0L, (IUpdateListener)listener);
        listener.waitForEvent();
        listener.verify(1);
    }
}

