/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.tests.updatesite;

import java.io.File;
import java.io.PrintStream;
import java.net.URI;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.updatesite.SiteXMLAction;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.publisher.IPublisherAction;
import org.eclipse.equinox.p2.publisher.IPublisherInfo;
import org.eclipse.equinox.p2.publisher.IPublisherResult;
import org.eclipse.equinox.p2.publisher.PublisherInfo;
import org.eclipse.equinox.p2.publisher.PublisherResult;
import org.eclipse.equinox.p2.publisher.actions.MergeResultsAction;
import org.eclipse.equinox.p2.publisher.eclipse.BundlesAction;
import org.eclipse.equinox.p2.publisher.eclipse.FeaturesAction;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.IRepositoryReference;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.tests.AbstractProvisioningTest;
import org.eclipse.equinox.p2.tests.StringBufferStream;
import org.eclipse.equinox.p2.tests.TestData;
import org.eclipse.equinox.p2.tests.TestMetadataRepository;

public class SiteXMLActionTest
extends AbstractProvisioningTest {
    private TestMetadataRepository metadataRepository;
    private IPublisherResult actionResult;
    private URI siteLocation;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.actionResult = new PublisherResult();
        PublisherInfo info = new PublisherInfo();
        this.metadataRepository = new TestMetadataRepository(SiteXMLActionTest.getAgent(), new IInstallableUnit[0]);
        info.setMetadataRepository((IMetadataRepository)this.metadataRepository);
        File siteLocationFile = TestData.getFile("updatesite", "SiteXMLActionTest/site.xml");
        this.siteLocation = siteLocationFile.toURI();
        FeaturesAction featuresAction = new FeaturesAction(new File[]{TestData.getFile("updatesite", "SiteXMLActionTest")});
        BundlesAction bundlesAction = new BundlesAction(new File[]{TestData.getFile("updatesite", "SiteXMLActionTest")});
        MergeResultsAction publishAction = new MergeResultsAction(new IPublisherAction[]{bundlesAction, featuresAction}, 2);
        publishAction.perform((IPublisherInfo)info, this.actionResult, (IProgressMonitor)new NullProgressMonitor());
        SiteXMLAction action = new SiteXMLAction(this.siteLocation, null);
        PrintStream out = System.out;
        try {
            System.setOut(new PrintStream(new StringBufferStream()));
            action.perform((IPublisherInfo)info, this.actionResult, this.getMonitor());
        }
        finally {
            System.setOut(out);
        }
    }

    public void testQualifier() {
        IQueryResult results = this.actionResult.query(QueryUtil.createIUCategoryQuery(), (IProgressMonitor)new NullProgressMonitor());
        for (IInstallableUnit unit : results) {
            String sitelocation = URIUtil.toUnencodedString((URI)this.siteLocation);
            SiteXMLActionTest.assertTrue((String)"1.0", (boolean)unit.getId().startsWith(sitelocation));
            SiteXMLActionTest.assertEquals((String)"2.0", (String)"Test Category Label", (String)unit.getProperty("org.eclipse.equinox.p2.name"));
            Collection provided = unit.getProvidedCapabilities();
            SiteXMLActionTest.assertEquals((int)1, (int)provided.size());
            SiteXMLActionTest.assertTrue((boolean)((IProvidedCapability)provided.iterator().next()).getName().startsWith(sitelocation));
            SiteXMLActionTest.assertEquals((Object)((IProvidedCapability)provided.iterator().next()).getVersion(), (Object)unit.getVersion());
        }
    }

    public void testAssociateSite() {
        Collection<IRepositoryReference> references = this.metadataRepository.getReferences();
        SiteXMLActionTest.assertEquals((String)"1.0", (int)2, (int)references.size());
        boolean metadataFound = false;
        boolean artifactFound = false;
        for (IRepositoryReference ref : references) {
            SiteXMLActionTest.assertEquals((String)"1.1", (String)"https://download.eclipse.org/eclipse/updates/4.21", (String)ref.getLocation().toString());
            SiteXMLActionTest.assertEquals((String)"1.2", (int)1, (int)ref.getOptions());
            SiteXMLActionTest.assertEquals((String)"1.3", (String)"Eclipse Project Update Site", (String)ref.getNickname());
            if (ref.getType() == 0) {
                metadataFound = true;
                continue;
            }
            if (ref.getType() != 1) continue;
            artifactFound = true;
        }
        SiteXMLActionTest.assertTrue((String)"1.3", (boolean)metadataFound);
        SiteXMLActionTest.assertTrue((String)"1.4", (boolean)artifactFound);
    }

    public void testMirrorsURL() {
        String mirrorsURL = (String)this.metadataRepository.getProperties().get("p2.mirrorsURL");
        SiteXMLActionTest.assertEquals((String)"1.0", (String)"https://www.eclipse.org/downloads/download.php?file=/eclipse/updates/4.21&format=xml", (String)mirrorsURL);
    }

    public void testBundleInCategory() {
        IQueryResult results = this.actionResult.query(QueryUtil.createIUCategoryQuery(), (IProgressMonitor)new NullProgressMonitor());
        Iterator iter = results.iterator();
        IInstallableUnit unit = (IInstallableUnit)iter.next();
        IQuery memberQuery = QueryUtil.createIUCategoryMemberQuery((IInstallableUnit)unit);
        IQueryResult categoryMembers = this.actionResult.query(memberQuery, (IProgressMonitor)new NullProgressMonitor());
        HashSet<String> membersId = new HashSet<String>();
        for (IInstallableUnit iu : categoryMembers.toUnmodifiableSet()) {
            membersId.add(iu.getId());
        }
        SiteXMLActionTest.assertEquals((String)"1.0", (int)2, (int)membersId.size());
        SiteXMLActionTest.assertTrue((String)"2.0", (boolean)membersId.contains("test.bundle"));
    }
}

