/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.saveparticipant3;

import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.tests.resources.saveparticipant3.SaveParticipantPlugin;

public class SaveParticipant3Plugin
extends SaveParticipantPlugin {
    protected boolean shouldFail = false;
    protected static final String file1 = "file_1";
    private static SaveParticipant3Plugin instance;

    public SaveParticipant3Plugin() {
        instance = this;
    }

    protected IPath getFilePath(String name) {
        return this.getStateLocation().append(name);
    }

    protected IPath getRealPath(String name, int saveNumber) {
        return this.getFilePath(name + "." + saveNumber);
    }

    @Override
    public void prepareToSave(ISaveContext context) throws CoreException {
        this.resetSaveLifecycleLog();
        context.needSaveNumber();
        IPath file = this.getFilePath(file1);
        if (context.lookup(file) != null) {
            this.validate(context);
            this.shouldFail = true;
            return;
        }
        IPath realPath = this.getRealPath(file1, context.getSaveNumber());
        context.map(file, realPath);
    }

    @Override
    public void rollback(ISaveContext context) {
    }

    @Override
    public void saving(ISaveContext context) throws CoreException {
        if (this.shouldFail) {
            throw new CoreException((IStatus)new Status(0, this.getPluginId(), 0, "fake failure", null));
        }
    }

    protected void validate(ISaveContext context) {
        IPath file = this.getFilePath(file1);
        IPath realPath = this.getRealPath(file1, context.getPreviousSaveNumber());
        IPath value = context.lookup(file);
        if (value != null && value.equals((Object)realPath)) {
            return;
        }
        String message = "Name of configuration file is different than expected.";
        this.saveLifecycleLog.add((IStatus)new Status(4, this.getPluginId(), 111, message, null));
    }

    public static SaveParticipant3Plugin getInstance() {
        return instance;
    }
}

