/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.test.internal.performance.data;

import java.io.EOFException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.test.internal.performance.data.DataPoint;
import org.eclipse.test.internal.performance.data.Dim;
import org.eclipse.test.internal.performance.data.Sample;
import org.eclipse.test.internal.performance.data.Scalar;
import org.eclipse.test.internal.performance.db.Variations;

public class ResultsData {
    private static Map<String, Sample> CURRENT_SCENARIO_DATA;
    private static Map<String, Sample> BASELINE_SCENARIO_DATA;
    private static String CURRENT_BUILD;
    private static String BASELINE_BUILD;
    private static final String[] ECLIPSE_COMPONENTS;

    static {
        BASELINE_BUILD = null;
        ECLIPSE_COMPONENTS = new String[]{"org.eclipse.ant", "org.eclipse.compare", "org.eclipse.core", "org.eclipse.help", "org.eclipse.jdt.core", "org.eclipse.jdt.debug", "org.eclipse.jdt.text", "org.eclipse.jdt.ui", "org.eclipse.jface", "org.eclipse.osgi", "org.eclipse.pde.api.tools", "org.eclipse.pde.ui", "org.eclipse.swt", "org.eclipse.team", "org.eclipse.ua", "org.eclipse.ui"};
    }

    public ResultsData(String current, String baseline) {
        CURRENT_BUILD = current;
        BASELINE_BUILD = baseline;
        CURRENT_SCENARIO_DATA = new HashMap<String, Sample>();
        BASELINE_SCENARIO_DATA = new HashMap<String, Sample>();
    }

    public void importData(Path inputFile) {
        System.out.println("INFO: Reading data from " + String.valueOf(inputFile));
        Properties variations = null;
        try {
            Throwable throwable = null;
            Object var4_7 = null;
            try {
                InputStream is = Files.newInputStream(inputFile, new OpenOption[0]);
                try {
                    while (true) {
                        ObjectInputStream ois = new ObjectInputStream(is);
                        String scenarioID = null;
                        Sample sample = null;
                        while (scenarioID == null || variations == null || sample == null) {
                            Object o = ois.readObject();
                            if (String.class.equals(o.getClass())) {
                                scenarioID = (String)o;
                                continue;
                            }
                            if (Variations.class.equals(o.getClass())) {
                                if (variations != null) continue;
                                variations = (Variations)o;
                                continue;
                            }
                            if (Sample.class.equals(o.getClass())) {
                                sample = (Sample)o;
                                continue;
                            }
                            System.err.println("WARN: Input contains unexpected object of type " + o.getClass().getCanonicalName());
                        }
                        String build = variations.getProperty("build");
                        if (build.equals(CURRENT_BUILD) && !CURRENT_SCENARIO_DATA.containsKey(scenarioID)) {
                            CURRENT_SCENARIO_DATA.put(scenarioID, sample);
                            continue;
                        }
                        if (build.contains(BASELINE_BUILD) && !BASELINE_SCENARIO_DATA.containsKey(scenarioID)) {
                            BASELINE_SCENARIO_DATA.put(scenarioID, sample);
                            continue;
                        }
                        System.err.println("WARN: Input contains Data from the wrong build or baseline");
                    }
                }
                catch (Throwable throwable2) {
                    if (is != null) {
                        is.close();
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (EOFException ex) {
            System.out.println("Finished reading data from " + String.valueOf(inputFile));
        }
        catch (Exception ex) {
            System.err.println("ERROR: IOException reading: " + String.valueOf(inputFile));
            System.exit(1);
        }
    }

    public String[] getComponents() {
        return ECLIPSE_COMPONENTS;
    }

    public Set<String> getCurrentScenarios() {
        return CURRENT_SCENARIO_DATA.keySet();
    }

    public Set<String> getBaselineScenarios() {
        return BASELINE_SCENARIO_DATA.keySet();
    }

    public Double[] getData(String build, String scenarioID) {
        Sample sample = null;
        sample = build == "current" ? CURRENT_SCENARIO_DATA.get(scenarioID) : BASELINE_SCENARIO_DATA.get(scenarioID);
        DataPoint[] data = sample.getDataPoints();
        Double elapsedProcess = 0.0;
        Double cpuTime = 0.0;
        DataPoint[] dataPointArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            Dim[] dimensions;
            DataPoint datum = dataPointArray[n2];
            Dim[] dimArray = dimensions = datum.getDimensions();
            int n3 = dimensions.length;
            int n4 = 0;
            while (n4 < n3) {
                Double decimalValue;
                String value;
                Scalar scalar;
                Dim dim = dimArray[n4];
                if (dim.getName().contains("Elapsed Process")) {
                    scalar = datum.getScalar(dim);
                    value = dim.getDisplayValue(scalar);
                    if (value.substring(value.length() - 1).equals("K")) {
                        value = value.substring(0, value.length() - 1);
                        decimalValue = Double.parseDouble(value);
                        decimalValue = decimalValue * 1000.0;
                        elapsedProcess = elapsedProcess + decimalValue;
                    } else {
                        elapsedProcess = elapsedProcess + Double.parseDouble(value);
                    }
                }
                if (dim.getName().contains("CPU Time")) {
                    scalar = datum.getScalar(dim);
                    value = dim.getDisplayValue(scalar);
                    if (value.substring(value.length() - 1).equals("K")) {
                        value = value.substring(0, value.length() - 1);
                        decimalValue = Double.parseDouble(value);
                        decimalValue = decimalValue * 1000.0;
                        cpuTime = cpuTime + decimalValue;
                    } else {
                        cpuTime = cpuTime + Double.parseDouble(value);
                    }
                }
                ++n4;
            }
            ++n2;
        }
        Double[] currentData = new Double[]{elapsedProcess, cpuTime};
        return currentData;
    }
}

