/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.test.internal.performance.eval;

import org.eclipse.test.internal.performance.PerformanceTestPlugin;
import org.eclipse.test.internal.performance.data.Dim;
import org.eclipse.test.internal.performance.data.Scalar;
import org.eclipse.test.internal.performance.eval.AssertChecker;
import org.eclipse.test.internal.performance.eval.StatisticsSession;

public class AbsoluteBandChecker
extends AssertChecker {
    private long fLowerBand;
    private long fUpperBand;

    public AbsoluteBandChecker(Dim dimension, long lowerBand, long upperBand) {
        super(dimension);
        this.fLowerBand = lowerBand;
        this.fUpperBand = upperBand;
    }

    @Override
    public boolean test(StatisticsSession reference, StatisticsSession measured, StringBuffer message) {
        double test;
        Dim dimension = this.getDimension();
        if (!measured.contains(dimension)) {
            PerformanceTestPlugin.logWarning("collected data provides no dimension '" + dimension.getName() + "'");
            return true;
        }
        if (!reference.contains(dimension)) {
            PerformanceTestPlugin.logWarning("reference data provides no dimension '" + dimension.getName() + "'");
            return true;
        }
        double actual = measured.getAverage(dimension);
        if (actual > (double)this.fUpperBand + (test = reference.getAverage(dimension)) || actual < test - (double)this.fLowerBand) {
            message.append("\n" + dimension.getName() + ": " + dimension.getDisplayValue(actual) + " is not within [-" + dimension.getDisplayValue(new Scalar(null, this.fLowerBand)) + ", +" + dimension.getDisplayValue(new Scalar(null, this.fUpperBand)) + "] of " + dimension.getDisplayValue(test));
            return false;
        }
        return true;
    }
}

