/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.test.internal.performance.eval;

import org.eclipse.test.internal.performance.PerformanceTestPlugin;
import org.eclipse.test.internal.performance.data.Dim;
import org.eclipse.test.internal.performance.eval.AssertChecker;
import org.eclipse.test.internal.performance.eval.StatisticsSession;

public class RelativeBandChecker
extends AssertChecker {
    private final double fLowerBand;
    private final double fUpperBand;

    public RelativeBandChecker(Dim dimension, double lowerBand, double upperBand) {
        super(dimension);
        this.fLowerBand = lowerBand;
        this.fUpperBand = upperBand;
    }

    @Override
    public boolean test(StatisticsSession reference, StatisticsSession measured, StringBuffer message) {
        Dim dimension = this.getDimension();
        if (!measured.contains(dimension)) {
            PerformanceTestPlugin.logWarning("collected data provides no dimension '" + dimension.getName() + "'");
            return true;
        }
        if (!reference.contains(dimension)) {
            PerformanceTestPlugin.logWarning("reference data provides no dimension '" + dimension.getName() + "'");
            return true;
        }
        double actual = measured.getAverage(dimension);
        double test = reference.getAverage(dimension);
        if (test < 0.001 && test > -0.001) {
            PerformanceTestPlugin.logWarning("ref value for '" + dimension.getName() + "' is too small");
            return true;
        }
        if (actual < 0.0) {
            PerformanceTestPlugin.logWarning("actual value for '" + dimension.getName() + "' is negative");
            return true;
        }
        if (actual > this.fUpperBand * test || actual < this.fLowerBand * test) {
            message.append("\n" + dimension.getName() + ": " + dimension.getDisplayValue(actual) + " is not within [" + Math.round(this.fLowerBand * 100.0) + "%, " + Math.round(this.fUpperBand * 100.0) + "%] of " + dimension.getDisplayValue(test));
            return false;
        }
        return true;
    }
}

