/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.test.internal.performance.tests;

import org.eclipse.test.internal.performance.db.Variations;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class VariationsTests {
    @Test
    public void testVariations() {
        Variations v1 = new Variations();
        v1.put("k1", "foo");
        Assertions.assertEquals((Object)"|k1=foo|", (Object)v1.toExactMatchString());
        Assertions.assertEquals((Object)"%|k1=foo|%", (Object)v1.toQueryPattern());
        Variations v2 = new Variations();
        v2.put("k1", "foo");
        v2.put("k2", "bar");
        Assertions.assertEquals((Object)"|k1=foo||k2=bar|", (Object)v2.toExactMatchString());
        Assertions.assertEquals((Object)"%|k1=foo|%|k2=bar|%", (Object)v2.toQueryPattern());
        Variations v3 = new Variations();
        v3.put("k1", "foo");
        v3.put("k2", "bar");
        v3.put("k3", "xyz");
        Assertions.assertEquals((Object)"|k1=foo||k2=bar||k3=xyz|", (Object)v3.toExactMatchString());
        Assertions.assertEquals((Object)"%|k1=foo|%|k2=bar|%|k3=xyz|%", (Object)v3.toQueryPattern());
    }

    @Test
    public void testParseVariations() {
        Variations v1 = new Variations();
        v1.put("k1", "foo");
        Variations v = new Variations();
        v.parseDB(v1.toExactMatchString());
        Assertions.assertEquals((Object)v1, (Object)v);
        Variations v2 = new Variations();
        v2.put("k1", "foo");
        v2.put("k2", "bar");
        v = new Variations();
        v.parseDB(v2.toExactMatchString());
        Assertions.assertEquals((Object)v2, (Object)v);
        Variations v3 = new Variations();
        v3.put("k1", "foo");
        v3.put("k2", "bar");
        v3.put("k3", "xyz");
        v = new Variations();
        v.parseDB(v3.toExactMatchString());
        Assertions.assertEquals((Object)v3, (Object)v);
    }
}

