/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.test.performance;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.test.internal.performance.data.ResultsData;

public class BasicResultsTable
implements IApplication {
    private static String CURRENT_BUILD;
    private static String BASELINE_BUILD;
    private static ArrayList<Path> inputFiles;
    private static Path phpTemplateFile;
    private static String buildDirectory;
    private static String EOL;
    private static String T;
    private static String T2;

    static {
        BASELINE_BUILD = "";
        inputFiles = new ArrayList();
        phpTemplateFile = null;
        buildDirectory = "";
        EOL = System.lineSeparator();
        T = "\t";
        T2 = "\t\t";
    }

    public Object start(IApplicationContext context) {
        String[] args = (String[])context.getArguments().get("application.args");
        if (args.length > 0) {
            System.out.println(EOL + T + "= = Raw arguments ('application.args') passed to performance import application: = =");
            String[] stringArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                String arg = stringArray[n2];
                System.out.println(T2 + ">" + arg + "<");
                ++n2;
            }
        }
        BasicResultsTable.run(args);
        return EXIT_OK;
    }

    public void stop() {
    }

    public static void run(String[] args) {
        Object scenarioParts;
        BasicResultsTable.parse(args);
        ResultsData results = new ResultsData(CURRENT_BUILD, BASELINE_BUILD);
        try {
            System.out.println("INFO: Start importing " + inputFiles.size() + " performance data files.");
            for (Path inputFile : inputFiles) {
                results.importData(inputFile);
            }
        }
        catch (Exception ex) {
            System.out.println("Performance data import failed with exception!" + String.valueOf(ex));
            System.exit(1);
        }
        Set<String> scenarioIDs = results.getCurrentScenarios();
        ArrayList<String> usedComponents = new ArrayList<String>();
        HashMap<String, ArrayList<String>> componentMap = new HashMap<String, ArrayList<String>>();
        for (String scenarioID : scenarioIDs) {
            ArrayList<Object> componentScenarios;
            scenarioParts = scenarioID.split("\\.");
            Object scenarioComponent = "";
            String[] stringArray = scenarioParts;
            int n = ((String[])scenarioParts).length;
            int n2 = 0;
            while (n2 < n) {
                String part = stringArray[n2];
                if (part.equals("tests") || part.equals("test")) break;
                scenarioComponent = (String)scenarioComponent + part + ".";
                ++n2;
            }
            if (usedComponents.contains(scenarioComponent = ((String)scenarioComponent).substring(0, ((String)scenarioComponent).length() - 1))) {
                componentScenarios = componentMap.get(scenarioComponent);
                componentScenarios.add(scenarioID);
                componentMap.replace((String)scenarioComponent, componentScenarios);
                continue;
            }
            componentScenarios = new ArrayList();
            componentScenarios.add(scenarioID);
            componentMap.put((String)scenarioComponent, componentScenarios);
            usedComponents.add((String)scenarioComponent);
        }
        BasicResultsTable.createResultsTables(results, usedComponents, componentMap);
        BasicResultsTable.createIndex(usedComponents);
        String phpFileName = buildDirectory + "/basicPerformance.php";
        File phpFile = new File(phpFileName);
        try {
            scenarioParts = null;
            Object var8_12 = null;
            try (BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(phpFile));){
                ((OutputStream)outputStream).write(Files.readAllBytes(phpTemplateFile));
            }
            catch (Throwable throwable) {
                if (scenarioParts == null) {
                    scenarioParts = throwable;
                } else if (scenarioParts != throwable) {
                    ((Throwable)scenarioParts).addSuppressed(throwable);
                }
                throw scenarioParts;
            }
        }
        catch (FileNotFoundException ex) {
            System.err.println(EOL + "ERROR: File not found exception while writing: " + phpFile.getPath());
            System.exit(1);
        }
        catch (IOException ex) {
            System.err.println(EOL + "ERROR: IOException writing: " + phpFile.getPath());
            System.exit(1);
        }
    }

    private static void createIndex(ArrayList<String> usedComponents) {
        Object htmlString = EOL;
        for (String component : usedComponents) {
            htmlString = (String)htmlString + "<a href=\"./basicPerformance.php?name=" + component + "&build=" + CURRENT_BUILD + "&baseline=" + BASELINE_BUILD + "\">" + component + "*</a><br>" + EOL;
        }
        String outputFileName = buildDirectory + "/BasicResultsIndex.html";
        File outputFile = new File(outputFileName);
        try {
            Throwable throwable = null;
            Object var5_8 = null;
            try (BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(outputFile));){
                ((OutputStream)outputStream).write(((String)htmlString).getBytes());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException ex) {
            System.err.println("ERROR: File not found exception while writing: " + outputFile.getPath());
            System.exit(1);
        }
        catch (IOException ex) {
            System.err.println("ERROR: IOException writing: " + outputFile.getPath());
            System.exit(1);
        }
    }

    private static void createResultsTables(ResultsData results, ArrayList<String> usedComponents, HashMap<String, ArrayList<String>> componentMap) {
        Set<String> baselineScenarios = results.getBaselineScenarios();
        for (String component : usedComponents) {
            Serializable classEPBaseline;
            ArrayList<String> scenarioList = componentMap.get(component);
            scenarioList.sort(String::compareToIgnoreCase);
            Double componentEPCurrent = 0.0;
            Double componentEPBaseline = 0.0;
            Double componentCPUCurrent = 0.0;
            Double componentCPUBaseline = 0.0;
            HashMap<String, Double[]> classMap = new HashMap<String, Double[]>();
            Object scenarioTable = BasicResultsTable.makeHeader(true);
            for (String scenario : scenarioList) {
                String[] scenarioClassName = new String[]{"", ""};
                if (scenario.contains("swt")) {
                    scenarioParts = scenario.split("\\.");
                    scenarioClassName[1] = scenarioParts[scenarioParts.length - 1];
                    int i = 0;
                    while (i < scenarioParts.length - 1) {
                        scenarioClassName[0] = scenarioClassName[0] + scenarioParts[i] + ".";
                        ++i;
                    }
                    scenarioClassName[0] = scenarioClassName[0].substring(0, scenarioClassName[0].length() - 1);
                } else {
                    scenarioParts = scenario.split("#");
                    scenarioClassName[0] = scenarioParts[0];
                    scenarioClassName[1] = scenarioParts[1];
                }
                Double[] currentData = results.getData("current", scenario);
                Double[] baselineData = new Double[]{0.0, 0.0};
                if (baselineScenarios.contains(scenario)) {
                    baselineData = results.getData("baseline", scenario);
                    if (classMap.containsKey(scenarioClassName[0])) {
                        classData = (Double[])classMap.get(scenarioClassName[0]);
                        Double classEPCurrent = classData[0] + currentData[0];
                        Double classCPUCurrent = classData[1] + currentData[1];
                        classEPBaseline = Double.valueOf(classData[2] + baselineData[0]);
                        Double classCPUBaseline = classData[3] + baselineData[1];
                        Double[] newClassData = new Double[]{classEPCurrent, classCPUCurrent, classEPBaseline, classCPUBaseline};
                        classMap.replace(scenarioClassName[0], newClassData);
                        componentEPCurrent = componentEPCurrent + currentData[0];
                        componentCPUCurrent = componentCPUCurrent + currentData[1];
                        componentEPBaseline = componentEPBaseline + baselineData[0];
                        componentCPUBaseline = componentCPUBaseline + baselineData[1];
                    } else {
                        classData = new Double[]{currentData[0], currentData[1], baselineData[0], baselineData[1]};
                        classMap.put(scenarioClassName[0], classData);
                        componentEPCurrent = componentEPCurrent + currentData[0];
                        componentCPUCurrent = componentCPUCurrent + currentData[1];
                        componentEPBaseline = componentEPBaseline + baselineData[0];
                        componentCPUBaseline = componentCPUBaseline + baselineData[1];
                    }
                }
                String scenarioRow = BasicResultsTable.makeTableRow(scenarioClassName, currentData, baselineData);
                scenarioTable = (String)scenarioTable + (String)scenarioRow;
            }
            scenarioTable = (String)scenarioTable + "</table>" + EOL;
            Object componentTable = BasicResultsTable.makeHeader(false);
            String componentRow = BasicResultsTable.makeTableRow(new String[]{component, ""}, new Double[]{componentEPCurrent, componentCPUCurrent}, new Double[]{componentEPBaseline, componentCPUBaseline});
            componentTable = (String)componentTable + componentRow + "</table>" + EOL;
            Object classTable = BasicResultsTable.makeHeader(false);
            Set classNames = classMap.keySet();
            for (String className : classNames) {
                Double[] classData = (Double[])classMap.get(className);
                String classRow = BasicResultsTable.makeTableRow(new String[]{className, ""}, new Double[]{classData[0], classData[1]}, new Double[]{classData[2], classData[3]});
                classTable = (String)classTable + classRow;
            }
            classTable = (String)classTable + "</table>" + EOL;
            String style = BasicResultsTable.getStyleString();
            String htmlString = style + EOL + "<p>Times are given in milliseconds.</p>" + EOL + "<h3>Total Component Time:</h3>" + EOL + (String)componentTable + EOL + "<h3>Total Class Times:</h3>" + EOL + (String)classTable + EOL + "<h3>All " + scenarioList.size() + " individual scenarios:</h3>" + EOL + (String)scenarioTable + EOL;
            String outputFileName = buildDirectory + "/" + component + "_BasicTable.html";
            File outputFile = new File(outputFileName);
            try {
                classEPBaseline = null;
                Object var22_26 = null;
                try (BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(outputFile));){
                    ((OutputStream)outputStream).write(htmlString.getBytes());
                }
                catch (Throwable throwable) {
                    if (classEPBaseline == null) {
                        classEPBaseline = throwable;
                    } else if (classEPBaseline != throwable) {
                        classEPBaseline.addSuppressed(throwable);
                    }
                    throw classEPBaseline;
                }
            }
            catch (FileNotFoundException ex) {
                System.err.println("ERROR: File not found exception while writing: " + outputFile.getPath());
                System.exit(1);
            }
            catch (IOException ex) {
                System.err.println("ERROR: IOException writing: " + outputFile.getPath());
                System.exit(1);
            }
        }
    }

    private static String makeHeader(boolean scenario) {
        String htmlString = "<table cellpadding=\"5\" class=\"details\">" + EOL + T + "<tr>" + EOL + T2 + "<th>Class</th>" + EOL;
        if (scenario) {
            htmlString = htmlString + T2 + "<th>Scenario</th>" + EOL;
        }
        htmlString = htmlString + T2 + "<th>Elapsed Process (Current)</th>" + EOL + T2 + "<th>Elapsed Process (Baseline)</th>" + EOL + T2 + "<th>Difference</th>" + EOL + T2 + "<th>CPU Time (Current)</th>" + EOL + T2 + "<th>CPU Time (Baseline)</th>" + EOL + T2 + "<th>Difference</th>" + EOL + T + "</tr>" + EOL;
        return htmlString;
    }

    private static String makeTableRow(String[] className, Double[] currentData, Double[] baselineData) {
        String elapsedCurrent = String.valueOf(currentData[0]);
        String cpuCurrent = String.valueOf(currentData[1]);
        String elapsedBaseline = "N/A";
        String cpuBaseline = "N/A";
        Object elapsedPercent = "N/A";
        Object cpuPercent = "N/A";
        String elapsedColor = "#4CE600";
        String cpuColor = "#4CE600";
        if (baselineData[0] != 0.0) {
            elapsedBaseline = String.valueOf(baselineData[0]);
            cpuBaseline = String.valueOf(baselineData[1]);
            Double elapsedDifference = baselineData[0] - currentData[0];
            Double cpuDifference = baselineData[1] - currentData[1];
            Double elapsedPercentValue = Math.abs(elapsedDifference / baselineData[0]) * 100.0;
            Double cpuPercentValue = Math.abs(cpuDifference / baselineData[1]) * 100.0;
            elapsedPercent = String.format("%.2f", elapsedPercentValue) + "%";
            cpuPercent = String.format("%.2f", cpuPercentValue) + "%";
            if (elapsedDifference < 0.0) {
                elapsedColor = "D7191C";
            }
            if (cpuDifference < 0.0) {
                cpuColor = "D7191C";
            }
        }
        String htmlString = T + "<tr>" + EOL + T2 + "<td>" + className[0] + "</td>" + EOL;
        if (className[1] != "") {
            htmlString = htmlString + T2 + "<td>" + className[1] + "</td>" + EOL;
        }
        htmlString = htmlString + T2 + "<td>" + elapsedCurrent + "</td>" + EOL + T2 + "<td>" + elapsedBaseline + "</td>" + EOL + T2 + "<td bgcolor=\"" + elapsedColor + "\">" + (String)elapsedPercent + "</td>" + EOL + T2 + "<td>" + cpuCurrent + "</td>" + EOL + T2 + "<td>" + cpuBaseline + "</td>" + EOL + T2 + "<td bgcolor=\"" + cpuColor + "\">" + (String)cpuPercent + "</td>" + EOL + T + "</tr>" + EOL;
        return htmlString;
    }

    private static String getStyleString() {
        return "<style type=\"text/css\">" + EOL + T + "body {" + EOL + T2 + "font:normal verdana,arial,helvetica;" + EOL + T2 + "color:#000000;" + EOL + T + "}" + EOL + T + "table.details tr th{" + EOL + T2 + "font-weight: bold;" + EOL + T2 + "text-align:left;" + EOL + T2 + "background:#a6caf0;" + EOL + T + "}" + EOL + T + "table.details tr {" + EOL + T2 + "background:#eeeee0;" + EOL + T + "}" + EOL + T + "p {" + EOL + T2 + "margin-top:0.5em; margin-bottom:1.0em;" + EOL + T + "}" + EOL + T + "h3 {" + EOL + T2 + "margin-bottom: 0.5em; font: bold 115% verdana,arial,helvetica" + EOL + T + "}" + EOL + "</style>" + EOL;
    }

    private static void parse(String[] args) {
        if (args.length == 0) {
            BasicResultsTable.printUsage();
        }
        int i = 0;
        while (i < args.length) {
            String arg = args[i];
            if (arg.equals("-current")) {
                CURRENT_BUILD = args[i + 1];
                if (CURRENT_BUILD.startsWith("-")) {
                    System.out.println("Missing value for " + arg + " parameter");
                    BasicResultsTable.printUsage();
                }
                ++i;
                ++i;
                continue;
            }
            if (arg.equals("-baseline")) {
                BASELINE_BUILD = args[i + 1];
                if (BASELINE_BUILD.startsWith("-")) {
                    System.out.println("Missing value for " + arg + " parameter");
                    BasicResultsTable.printUsage();
                }
                ++i;
                ++i;
                continue;
            }
            if (arg.equals("-buildDirectory")) {
                buildDirectory = args[i + 1];
                if (buildDirectory.startsWith("-")) {
                    System.out.println("Missing value for " + arg + " parameter");
                    BasicResultsTable.printUsage();
                }
                ++i;
                ++i;
                continue;
            }
            if (arg.equals("-phpFile")) {
                Path inputFilePath;
                String inputFile = args[i + 1];
                if (inputFile.startsWith("-")) {
                    System.out.println("Missing value for " + arg + " parameter");
                    BasicResultsTable.printUsage();
                }
                if (Files.isReadable(inputFilePath = Paths.get(inputFile, new String[0]))) {
                    phpTemplateFile = inputFilePath;
                } else {
                    System.err.println("ERROR: invalid input argument. Cannot read file: " + inputFile);
                }
                ++i;
                ++i;
                continue;
            }
            if (arg.equals("-inputFiles")) {
                int j = 1;
                while (j < 5) {
                    Path inputFilePath;
                    String inputFile = args[i + j];
                    if (inputFile.startsWith("-")) {
                        System.out.println("Missing value for " + arg + " parameter");
                        BasicResultsTable.printUsage();
                    }
                    if (Files.isReadable(inputFilePath = Paths.get(inputFile, new String[0]))) {
                        inputFiles.add(inputFilePath);
                    } else {
                        System.err.println("ERROR: invalid input argument. Cannot read file: " + inputFile);
                    }
                    ++j;
                }
                i += 5;
                continue;
            }
            System.err.println("ERROR: Unrecognized argument (arg) found, with value of >" + arg + "<");
            ++i;
        }
    }

    private static void printUsage() {
        System.out.println("Usage:\n-baseline: Build id for the baseline build.\n-current: Build id for the current build.\n-buildDirectory: Directory of performance.php file, usually /home/data/httpd/download.eclipse.org/eclipse/downloads/drops4/${BUILD_ID}/performance.\n-phpFile: Location of the basicPerformance.php file, also known as template file.\n-inputFiles: List of the dat files from which to extract performance data (will grab the next 4 args as filenames).\n");
        System.exit(1);
    }
}

