/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.security.tests.storage;

import java.security.Provider;
import java.security.Security;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.equinox.internal.security.storage.JavaEncryption;
import org.junit.Assert;
import org.junit.Test;

public class DetectPBECiphersTest {
    @Test
    public void testPBEDetect() {
        Provider p;
        Provider[] providers;
        int cipherJVMCount = 0;
        HashSet<String> keyFactories = new HashSet<String>();
        Provider[] providerArray = providers = Security.getProviders();
        int n = providers.length;
        int n2 = 0;
        while (n2 < n) {
            p = providerArray[n2];
            for (Provider.Service service : p.getServices()) {
                if (!service.getType().equals("SecretKeyFactory") || service.getAlgorithm().indexOf(32) != -1) continue;
                keyFactories.add(service.getAlgorithm());
            }
            ++n2;
        }
        providerArray = providers;
        n = providers.length;
        n2 = 0;
        while (n2 < n) {
            p = providerArray[n2];
            for (Provider.Service service : p.getServices()) {
                if (!service.getType().equals("Cipher") || !service.getAlgorithm().startsWith("PBE") || !keyFactories.contains(service.getAlgorithm())) continue;
                ++cipherJVMCount;
            }
            ++n2;
        }
        JavaEncryption encryption = new JavaEncryption();
        HashMap detectedCiphers = encryption.detect();
        Assert.assertTrue((!detectedCiphers.isEmpty() ? 1 : 0) != 0);
        Assert.assertEquals((long)cipherJVMCount, (long)detectedCiphers.size());
    }
}

