/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.security.tests.storage;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.eclipse.core.tests.harness.BundleTestingHelper;
import org.eclipse.equinox.internal.security.storage.StorageUtils;
import org.eclipse.equinox.internal.security.tests.SecurityTestsActivator;
import org.eclipse.equinox.internal.security.tests.storage.StorageAbstractTest;
import org.eclipse.equinox.internal.security.tests.storage.WaitingRegistryListener;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.StorageException;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

public class DynamicPreferencesTest
extends StorageAbstractTest {
    private static final int MAX_TIME_PER_BUNDLE = 10000;
    public static final String TEST_FILES_ROOT = "Plugin_Testing/";
    private static final String key = "password";
    private static final String unassignedKey = "unknown";
    private static final String value = "p[[pkknb#";
    private static final String defaultValue = "default";
    private static final String key2 = "password2";
    private static final String value2 = "34534534535";
    private static final String clearTextKey = "data";
    private static final String clearTextValue = "-> this should not be encrypted <-";

    private void check(ISecurePreferences prefs) throws StorageException {
        ISecurePreferences node1 = prefs.node("/abc");
        Assert.assertEquals((Object)value, (Object)node1.get(key, defaultValue));
        Assert.assertEquals((Object)defaultValue, (Object)node1.get(unassignedKey, defaultValue));
    }

    @Test
    public void testDynamicMemory() throws Exception {
        Bundle bundle01 = null;
        Bundle bundle02 = null;
        try {
            bundle01 = this.installBundle("priority/low");
            ISecurePreferences preferences = this.newPreferences(this.getStorageLocation(), this.getOptions());
            ISecurePreferences node1 = preferences.node("/abc");
            node1.put(key, value, true);
            bundle02 = this.installBundle("priority/high");
            this.check(preferences);
            node1.put(key2, value2, true);
            node1.put(clearTextKey, clearTextValue, false);
            ISecurePreferences node2 = preferences.node("/abc/high");
            node2.put(key, value, true);
            node2.put(clearTextKey, clearTextValue, false);
            if (this.uninstallBundle(bundle02)) {
                bundle02 = null;
            }
            this.checkUnreadable(node1, key2);
            this.checkUnreadable(node2, key);
            Assert.assertEquals((Object)clearTextValue, (Object)node1.get(clearTextKey, defaultValue));
            Assert.assertEquals((Object)clearTextValue, (Object)node2.get(clearTextKey, defaultValue));
            this.check(preferences);
        }
        finally {
            if (bundle02 != null) {
                bundle02.uninstall();
            }
            if (bundle01 != null) {
                bundle01.uninstall();
            }
        }
    }

    @Test
    public void testDynamicPersisted() throws Exception {
        URL location = this.getStorageLocation();
        Assert.assertNotNull((Object)location);
        Bundle bundle01 = null;
        Bundle bundle02 = null;
        try {
            bundle01 = this.installBundle("priority/low");
            ISecurePreferences preferences = this.newPreferences(location, this.getOptions());
            ISecurePreferences node1 = preferences.node("/abc");
            node1.put(key, value, true);
            preferences.flush();
            this.closePreferences(preferences);
            bundle02 = this.installBundle("priority/high");
            preferences = this.newPreferences(location, this.getOptions());
            this.check(preferences);
            node1 = preferences.node("/abc");
            node1.put(key2, value2, true);
            ISecurePreferences node2 = preferences.node("/abc/high");
            node2.put(key, value, true);
            preferences.flush();
            this.closePreferences(preferences);
            if (this.uninstallBundle(bundle02)) {
                bundle02 = null;
            }
            preferences = this.newPreferences(location, this.getOptions());
            node1 = preferences.node("/abc");
            node2 = preferences.node("/abc/high");
            this.checkUnreadable(node1, key2);
            this.checkUnreadable(node2, key);
            this.check(preferences);
        }
        finally {
            if (bundle02 != null) {
                bundle02.uninstall();
            }
            if (bundle01 != null) {
                bundle01.uninstall();
            }
            StorageUtils.delete((URL)location);
        }
    }

    protected void checkUnreadable(ISecurePreferences node, String keyToCheck) {
        boolean exception = false;
        try {
            node.get(keyToCheck, defaultValue);
        }
        catch (StorageException e) {
            exception = true;
        }
        Assert.assertTrue((boolean)exception);
    }

    protected Map<String, Object> getOptions() {
        return this.getOptions(null);
    }

    protected Bundle installBundle(String bundlePath) throws MalformedURLException, BundleException, IOException {
        BundleContext bundleContext = SecurityTestsActivator.getDefault().getBundleContext();
        Bundle bundle = null;
        WaitingRegistryListener listener = new WaitingRegistryListener();
        listener.register("org.eclipse.equinox.security.secureStorage");
        try {
            bundle = BundleTestingHelper.installBundle((String)"0.1", (BundleContext)bundleContext, (String)(TEST_FILES_ROOT + bundlePath));
            BundleTestingHelper.refreshPackages((BundleContext)bundleContext, (Bundle[])new Bundle[]{bundle});
            Assert.assertTrue((listener.waitFor(1, 10000L) == 1 ? 1 : 0) != 0);
        }
        finally {
            listener.unregister();
        }
        return bundle;
    }

    protected boolean uninstallBundle(Bundle bundle) throws BundleException {
        WaitingRegistryListener listener = new WaitingRegistryListener();
        listener.register("org.eclipse.equinox.security.secureStorage");
        try {
            bundle.uninstall();
            bundle = null;
            Assert.assertTrue((listener.waitFor(1, 100000L) == 1 ? 1 : 0) != 0);
            return true;
        }
        finally {
            listener.unregister();
            if (bundle != null) {
                bundle.uninstall();
            }
        }
    }
}

