/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.security.tests.storage;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.equinox.internal.security.storage.friends.InternalExchangeUtils;
import org.eclipse.equinox.internal.security.storage.friends.PasswordProviderDescription;
import org.eclipse.equinox.internal.security.storage.provider.IValidatingPasswordProvider;
import org.eclipse.equinox.internal.security.tests.SecurityTestsActivator;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class ObsoletesTest {
    private static final String LINUX_BUNDLE = "org.eclipse.equinox.security.linux";
    private static final String EXTENSION_POINT = "org.eclipse.equinox.security.secureStorage";
    private static final String LINUX_PASSWORD_PROVIDER = "org.eclipse.equinox.security.securestorage.linuxkeystoreintegrationjna";
    private static final String CLASS_NAME = "class";

    @Before
    public void setUp() {
        Assume.assumeTrue((boolean)ObsoletesTest.hasBundle(LINUX_BUNDLE));
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        IExtensionPoint point = registry.getExtensionPoint(EXTENSION_POINT);
        IExtension[] extensions = point.getExtensions();
        IExtension linuxExtension = null;
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            String moduleID = extension.getUniqueIdentifier();
            if (moduleID != null && (moduleID = moduleID.toLowerCase()).equals(LINUX_PASSWORD_PROVIDER)) {
                linuxExtension = extension;
                break;
            }
            ++n2;
        }
        Assume.assumeTrue((linuxExtension != null ? 1 : 0) != 0);
        IConfigurationElement[] elements = linuxExtension.getConfigurationElements();
        Assume.assumeTrue((elements.length > 0 ? 1 : 0) != 0);
        IConfigurationElement element = elements[0];
        try {
            Object clazz = element.createExecutableExtension(CLASS_NAME);
            Assume.assumeTrue((clazz instanceof IValidatingPasswordProvider && ((IValidatingPasswordProvider)clazz).isValid() ? 1 : 0) != 0);
        }
        catch (CoreException e) {
            Assume.assumeNoException((Throwable)e);
        }
    }

    @Test
    public void testObsoletes() {
        List descs = InternalExchangeUtils.passwordProvidersFind((String)"org.eclipse.equinox.security.linuxkeystoreintegration");
        Assert.assertNotNull((Object)descs);
        Assert.assertEquals((long)1L, (long)descs.size());
        PasswordProviderDescription desc = (PasswordProviderDescription)descs.get(0);
        Assert.assertEquals((Object)"org.eclipse.equinox.security.linuxkeystoreintegrationjna", (Object)desc.getId());
    }

    private static boolean hasBundle(String symbolicID) {
        Bundle[] bundles;
        BundleContext context = SecurityTestsActivator.getDefault().getBundleContext();
        Bundle[] bundleArray = bundles = context.getBundles();
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            String bundleName = bundle.getSymbolicName();
            if (symbolicID.equals(bundleName)) {
                int bundleState = bundle.getState();
                return bundleState != 2 && bundleState != 1;
            }
            ++n2;
        }
        return false;
    }
}

