/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.security.tests.storage;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.eclipse.core.tests.harness.BundleTestingHelper;
import org.eclipse.equinox.internal.security.storage.friends.InternalExchangeUtils;
import org.eclipse.equinox.internal.security.storage.friends.ReEncrypter;
import org.eclipse.equinox.internal.security.tests.SecurityTestsActivator;
import org.eclipse.equinox.internal.security.tests.storage.StorageAbstractTest;
import org.eclipse.equinox.internal.security.tests.storage.WaitingRegistryListener;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.StorageException;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

public class ReEncrypterTest
extends StorageAbstractTest {
    private static final int MAX_TIME_PER_BUNDLE = 10000;
    private static final String TEST_FILES_ROOT = "Plugin_Testing/";
    private static final String key = "password";
    private static final String value = "p[[pkknb#";
    private static final String clearTextKey = "data";
    private static final String clearTextValue = "-> this should not be encrypted <-";
    private static final String defaultValue = "default";

    @Test
    public void testFlushAfterEncrypt() throws IOException, StorageException, BundleException {
        URL location = this.getStorageLocation();
        Assert.assertNotNull((Object)location);
        Bundle bundle = null;
        try {
            bundle = this.installBundle("controlled_provider");
            ISecurePreferences preferences = this.newPreferences(location, this.getOptions());
            this.fill(preferences);
            preferences.flush();
            this.closePreferences(preferences);
            preferences = this.newPreferences(location, this.getOptions());
            ReEncrypter reEncrypter = new ReEncrypter(preferences, this.getModuleID());
            boolean decryptResult = reEncrypter.decrypt();
            Assert.assertTrue((boolean)decryptResult);
            boolean switchToNewPasswordResult = reEncrypter.switchToNewPassword();
            Assert.assertTrue((boolean)switchToNewPasswordResult);
            boolean encryptResult = reEncrypter.encrypt();
            Assert.assertTrue((boolean)encryptResult);
            preferences = this.newPreferences(location, this.getOptions());
            this.check(preferences);
        }
        finally {
            if (bundle != null) {
                bundle.uninstall();
            }
        }
    }

    @Override
    protected String getModuleID() {
        return "org.eclipse.equinox.security.controlledpasswordprovider.controlledpasswordprovider";
    }

    protected Map<String, Object> getOptions() {
        return this.getOptions(null);
    }

    private void fill(ISecurePreferences preferences) throws StorageException {
        Assert.assertFalse((boolean)this.isModified(preferences));
        preferences.put(key, value, true);
        preferences.put(clearTextKey, clearTextValue, false);
        Assert.assertTrue((boolean)this.isModified(preferences));
    }

    private void check(ISecurePreferences preferences) throws StorageException {
        Assert.assertFalse((boolean)this.isModified(preferences));
        Assert.assertEquals((Object)value, (Object)preferences.get(key, defaultValue));
        Assert.assertEquals((Object)clearTextValue, (Object)preferences.get(clearTextKey, defaultValue));
    }

    private boolean isModified(ISecurePreferences node) {
        return InternalExchangeUtils.isModified((ISecurePreferences)node);
    }

    protected Bundle installBundle(String bundlePath) throws MalformedURLException, BundleException, IOException {
        BundleContext bundleContext = SecurityTestsActivator.getDefault().getBundleContext();
        Bundle bundle = null;
        WaitingRegistryListener listener = new WaitingRegistryListener();
        listener.register("org.eclipse.equinox.security.secureStorage");
        try {
            bundle = BundleTestingHelper.installBundle((String)"0.1", (BundleContext)bundleContext, (String)(TEST_FILES_ROOT + bundlePath));
            BundleTestingHelper.refreshPackages((BundleContext)bundleContext, (Bundle[])new Bundle[]{bundle});
            Assert.assertTrue((listener.waitFor(1, 10000L) == 1 ? 1 : 0) != 0);
        }
        finally {
            listener.unregister();
        }
        return bundle;
    }
}

