/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.security.tests.storage;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.equinox.internal.security.storage.friends.InternalExchangeUtils;
import org.eclipse.equinox.internal.security.tests.SecurityTestsActivator;
import org.eclipse.equinox.internal.security.tests.storage.StorageAbstractTest;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.StorageException;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.framework.BundleContext;

public abstract class SecurePreferencesTest
extends StorageAbstractTest {
    private static final String sampleLocation = "/SecurePrefsSample/1/secure_storage.equinox";
    private static final String path1 = "/test/abc";
    private static final String path2 = "/test/cvs/eclipse.org";
    private static final String path3 = "/test/cvs/eclipse.org/account1";
    private static final String key = "password";
    private static final String unassignedKey = "unknown";
    private static final String value = "p[[pkknb#";
    private static final String defaultValue = "default";
    private static final String secondKey = "/   sdfdsf / sf";
    private static final String secondValue = "one";
    private static final String clearTextKey = "data";
    private static final String clearTextValue = "-> this should not be encrypted <-";
    private static final String unicodeKey = "unicodeKey";
    private static final String unicodeValue = "va\u0432lue\u0433";

    protected Map<String, Object> getOptions() {
        return this.getOptions("password1");
    }

    private void fill(ISecurePreferences preferences) throws StorageException {
        preferences.put(key, value, true);
        ISecurePreferences node1 = preferences.node(path1);
        node1.put(key, value, true);
        node1.put(clearTextKey, clearTextValue, false);
        ISecurePreferences node2 = preferences.node(path2);
        node2.put(key, value, true);
        node2.put(secondKey, secondValue, true);
        ISecurePreferences node3 = preferences.node(path3);
        node3.put(key, value, true);
        node3.put(secondKey, secondValue, true);
        node3.put(clearTextKey, clearTextValue, false);
        node3.put(unicodeKey, unicodeValue, true);
        node2.remove(secondKey);
        Assert.assertTrue((boolean)this.isModified(node2));
        Assert.assertTrue((boolean)this.isModified(preferences));
    }

    private boolean isModified(ISecurePreferences node) {
        return InternalExchangeUtils.isModified((ISecurePreferences)node);
    }

    private void check(ISecurePreferences preferences) throws StorageException {
        Assert.assertFalse((boolean)this.isModified(preferences));
        Assert.assertEquals((Object)value, (Object)preferences.get(key, defaultValue));
        Assert.assertEquals((Object)defaultValue, (Object)preferences.get(unassignedKey, defaultValue));
        ISecurePreferences node1 = preferences.node(path1);
        Assert.assertFalse((boolean)this.isModified(node1));
        Assert.assertEquals((Object)value, (Object)node1.get(key, defaultValue));
        Assert.assertEquals((Object)defaultValue, (Object)node1.get(unassignedKey, defaultValue));
        Assert.assertEquals((Object)clearTextValue, (Object)node1.get(clearTextKey, defaultValue));
        ISecurePreferences node2 = preferences.node(path2);
        Assert.assertFalse((boolean)this.isModified(node2));
        Assert.assertEquals((Object)value, (Object)node2.get(key, defaultValue));
        Assert.assertNull((Object)node2.get(secondKey, null));
        Assert.assertEquals((Object)defaultValue, (Object)node2.get(unassignedKey, defaultValue));
        ISecurePreferences node3 = preferences.node(path3);
        Assert.assertFalse((boolean)this.isModified(node3));
        Assert.assertEquals((Object)value, (Object)node3.get(key, defaultValue));
        Assert.assertEquals((Object)secondValue, (Object)node3.get(secondKey, defaultValue));
        Assert.assertEquals((Object)defaultValue, (Object)node3.get(unassignedKey, defaultValue));
        Assert.assertEquals((Object)clearTextValue, (Object)node3.get(clearTextKey, defaultValue));
        Assert.assertEquals((Object)unicodeValue, (Object)node3.get(unicodeKey, defaultValue));
        String[] leafKeys = node3.keys();
        Assert.assertNotNull((Object)leafKeys);
        Assert.assertEquals((long)leafKeys.length, (long)4L);
        this.findAll(new String[]{clearTextKey, key, secondKey, unicodeKey}, leafKeys);
    }

    @Test
    public void testPreferences() throws IOException, StorageException {
        URL location = this.getStorageLocation();
        Assert.assertNotNull((Object)location);
        ISecurePreferences preferences = this.newPreferences(this.getStorageLocation(), this.getOptions());
        this.fill(preferences);
        preferences.flush();
        this.closePreferences(preferences);
        preferences = this.newPreferences(this.getStorageLocation(), this.getOptions());
        this.check(preferences);
    }

    @Test
    public void testNames() throws IOException, StorageException {
        ISecurePreferences preferences = this.newPreferences(this.getStorageLocation(), this.getOptions());
        this.fill(preferences);
        Assert.assertNull((Object)preferences.name());
        Assert.assertEquals((Object)"/", (Object)preferences.absolutePath());
        String[] childrenNames = preferences.node("test").childrenNames();
        Assert.assertNotNull((Object)childrenNames);
        boolean order1 = "abc".equals(childrenNames[0]) && "cvs".equals(childrenNames[1]);
        boolean order2 = "abc".equals(childrenNames[1]) && "cvs".equals(childrenNames[0]);
        Assert.assertTrue((order1 || order2 ? 1 : 0) != 0);
        Assert.assertEquals((long)childrenNames.length, (long)2L);
        ISecurePreferences node1 = preferences.node("test/cvs");
        Assert.assertEquals((Object)"cvs", (Object)node1.name());
        Assert.assertEquals((Object)"/test/cvs", (Object)node1.absolutePath());
        String[] childrenNames1 = node1.childrenNames();
        Assert.assertNotNull((Object)childrenNames1);
        Assert.assertEquals((long)childrenNames1.length, (long)1L);
        Assert.assertEquals((Object)"eclipse.org", (Object)childrenNames1[0]);
        ISecurePreferences node2 = node1.node("eclipse.org");
        Assert.assertEquals((Object)"eclipse.org", (Object)node2.name());
        Assert.assertEquals((Object)path2, (Object)node2.absolutePath());
        String[] childrenNames2 = node2.childrenNames();
        Assert.assertNotNull((Object)childrenNames2);
        Assert.assertEquals((long)childrenNames2.length, (long)1L);
        Assert.assertEquals((Object)"account1", (Object)childrenNames2[0]);
        ISecurePreferences node3 = node2.node("account1");
        Assert.assertEquals((Object)"account1", (Object)node3.name());
        Assert.assertEquals((Object)path3, (Object)node3.absolutePath());
        String[] childrenNames3 = node3.childrenNames();
        Assert.assertNotNull((Object)childrenNames3);
        Assert.assertEquals((long)childrenNames3.length, (long)0L);
    }

    @Test
    public void testNodeResolution() throws IOException, StorageException {
        ISecurePreferences preferences = this.newPreferences(this.getStorageLocation(), this.getOptions());
        this.fill(preferences);
        Assert.assertTrue((boolean)preferences.nodeExists(null));
        ISecurePreferences nodeRoot = preferences.node(null);
        Assert.assertNotNull((Object)nodeRoot);
        Assert.assertTrue((boolean)preferences.nodeExists("/test/cvs"));
        Assert.assertFalse((boolean)preferences.nodeExists("/test/nonExistent"));
        ISecurePreferences node1 = preferences.node("/test/cvs");
        Assert.assertNotNull((Object)node1);
        Assert.assertTrue((boolean)preferences.nodeExists(path2));
        Assert.assertFalse((boolean)preferences.nodeExists("/test/nonExistent/cvs"));
        Assert.assertFalse((boolean)preferences.nodeExists("/test/cvs/nonExistent"));
        ISecurePreferences node2 = preferences.node(path2);
        Assert.assertNotNull((Object)node2);
        Assert.assertTrue((boolean)preferences.nodeExists(path3));
        Assert.assertFalse((boolean)preferences.nodeExists("/test/cvs/nonExistent/cvs"));
        ISecurePreferences node3 = preferences.node(path3);
        Assert.assertNotNull((Object)node3);
        Assert.assertNull((Object)preferences.parent());
        Assert.assertEquals((Object)nodeRoot, (Object)preferences);
        Assert.assertTrue((boolean)nodeRoot.nodeExists("test/cvs"));
        Assert.assertFalse((boolean)nodeRoot.nodeExists("test/nonExistent"));
        ISecurePreferences relativeNode1 = nodeRoot.node("test/cvs");
        Assert.assertNotNull((Object)relativeNode1);
        Assert.assertEquals((Object)node1, (Object)relativeNode1);
        Assert.assertEquals((Object)nodeRoot, (Object)relativeNode1.parent().parent());
        Assert.assertTrue((boolean)relativeNode1.nodeExists("eclipse.org"));
        Assert.assertFalse((boolean)relativeNode1.nodeExists("nonExistent"));
        ISecurePreferences relativeNode2 = relativeNode1.node("eclipse.org");
        Assert.assertNotNull((Object)relativeNode2);
        Assert.assertEquals((Object)node2, (Object)relativeNode2);
        Assert.assertEquals((Object)node1, (Object)relativeNode2.parent());
        Assert.assertTrue((boolean)relativeNode2.nodeExists("account1"));
        Assert.assertFalse((boolean)relativeNode2.nodeExists("nonExistent"));
        ISecurePreferences relativeNode3 = relativeNode2.node("account1");
        Assert.assertNotNull((Object)relativeNode3);
        Assert.assertEquals((Object)node3, (Object)relativeNode3);
        Assert.assertEquals((Object)relativeNode2, (Object)relativeNode3.parent());
        preferences.flush();
        this.check(preferences);
    }

    @Test
    public void testNodeRemoval() throws IOException, StorageException {
        URL location = this.getStorageLocation();
        Assert.assertNotNull((Object)location);
        ISecurePreferences preferences = this.newPreferences(location, this.getOptions());
        this.fill(preferences);
        ISecurePreferences nodeToRemove = preferences.node(path2);
        Assert.assertNotNull((Object)nodeToRemove);
        nodeToRemove.removeNode();
        Assert.assertFalse((boolean)preferences.nodeExists(path3));
        Assert.assertFalse((boolean)preferences.nodeExists(path2));
        preferences.flush();
        this.closePreferences(preferences);
        preferences = this.newPreferences(location, this.getOptions());
        Assert.assertTrue((boolean)preferences.nodeExists(null));
        Assert.assertFalse((boolean)preferences.nodeExists(path3));
        Assert.assertFalse((boolean)preferences.nodeExists(path2));
        ISecurePreferences node = preferences.node("/test/cvs");
        String[] children = node.childrenNames();
        Assert.assertNotNull((Object)children);
        Assert.assertEquals((long)children.length, (long)0L);
        ISecurePreferences node2 = preferences.node(null).node("test");
        String[] children2 = node2.childrenNames();
        Assert.assertNotNull((Object)children2);
        Assert.assertEquals((long)children2.length, (long)2L);
        ISecurePreferences nodeToRemove2 = node2.node("/test/cvs");
        Assert.assertNotNull((Object)nodeToRemove2);
        nodeToRemove2.removeNode();
        String[] children3 = node2.childrenNames();
        Assert.assertNotNull((Object)children3);
        Assert.assertEquals((long)children3.length, (long)1L);
        Assert.assertEquals((Object)"abc", (Object)children3[0]);
        preferences.removeNode();
        boolean exception = false;
        try {
            preferences.nodeExists(null);
        }
        catch (IllegalStateException e) {
            exception = true;
        }
        Assert.assertTrue((boolean)exception);
    }

    @Test
    public void testPathValidation() throws Throwable {
        ISecurePreferences preferences = this.newPreferences(this.getStorageLocation(), this.getOptions());
        boolean exception = false;
        try {
            preferences.node("/test/cvs/eclipse.org//account1");
        }
        catch (IllegalArgumentException e) {
            exception = true;
        }
        Assert.assertTrue((boolean)exception);
        exception = false;
        try {
            preferences.node("/test/cvs/eclipse.org/");
        }
        catch (IllegalArgumentException e) {
            exception = true;
        }
        Assert.assertTrue((boolean)exception);
        exception = false;
        try {
            preferences.node("/test/cvs/eclipse.org//");
        }
        catch (IllegalArgumentException e) {
            exception = true;
        }
        Assert.assertTrue((boolean)exception);
    }

    @Test
    public void testLocation() throws MalformedURLException {
        URL invalidURL = new URL("http", "eclipse.org", "testEquinoxFile");
        boolean exception = false;
        try {
            this.newPreferences(invalidURL, this.getOptions());
        }
        catch (IOException e) {
            exception = true;
        }
        Assert.assertTrue((boolean)exception);
    }

    @Test
    public void testDataTypes() throws StorageException, MalformedURLException, IOException {
        ISecurePreferences preferences = this.newPreferences(this.getStorageLocation(), this.getOptions());
        ISecurePreferences node = preferences.node("/test");
        byte[] byArray = new byte[8];
        byArray[1] = 4;
        byArray[2] = 12;
        byArray[3] = 75;
        byArray[4] = 84;
        byArray[5] = 12;
        byArray[6] = 1;
        byArray[7] = -1;
        byte[] testArray = byArray;
        boolean encrypt = true;
        node.putBoolean("trueBoolean", true, encrypt);
        node.putBoolean("falseBoolean", false, encrypt);
        node.putInt("oneInteger", 1, encrypt);
        node.putLong("twoLong", 2L, encrypt);
        node.putFloat("threeFloat", 3.12f, encrypt);
        node.putDouble("fourDouble", 4.1, encrypt);
        Assert.assertTrue((boolean)node.getBoolean("trueBoolean", false));
        Assert.assertFalse((boolean)node.getBoolean("falseBoolean", true));
        Assert.assertTrue((boolean)node.getBoolean("unknownBoolean", true));
        Assert.assertFalse((boolean)node.getBoolean("unknownBoolean", false));
        Assert.assertEquals((long)node.getInt("oneInteger", 0), (long)1L);
        Assert.assertEquals((long)node.getInt("unknownInteger", 5), (long)5L);
        Assert.assertEquals((long)node.getLong("twoLong", 0L), (long)2L);
        Assert.assertEquals((long)node.getLong("unknownLong", 5L), (long)5L);
        Assert.assertEquals((float)node.getFloat("threeFloat", 0.0f), (float)3.12f, (float)0.0f);
        Assert.assertEquals((float)node.getFloat("unknownFloat", 1.23f), (float)1.23f, (float)0.0f);
        Assert.assertEquals((double)node.getDouble("fourDouble", 0.0), (double)4.1, (double)0.0);
        Assert.assertEquals((double)node.getDouble("unknownDouble", 1.23), (double)1.23, (double)0.0);
        node.putByteArray("fiveArray", testArray, encrypt);
        byte[] array = node.getByteArray("fiveArray", null);
        this.compareArrays(testArray, array);
    }

    @Test
    public void testIncorrectData() throws IOException {
        URL location = this.getFilePath(sampleLocation);
        ISecurePreferences preferences = this.newPreferences(location, this.getOptions("password1"));
        try {
            ISecurePreferences node = preferences.node("/abc");
            boolean exception = false;
            try {
                node.get("password1", defaultValue);
            }
            catch (StorageException e) {
                Assert.assertEquals((long)0L, (long)e.getErrorCode());
                exception = true;
            }
            Assert.assertTrue((boolean)exception);
            exception = false;
            try {
                node.get("password2", defaultValue);
            }
            catch (StorageException e) {
                Assert.assertEquals((long)0L, (long)e.getErrorCode());
                exception = true;
            }
            Assert.assertTrue((boolean)exception);
        }
        finally {
            this.closePreferences(preferences);
        }
    }

    @Test
    public void testIncorrectPassword() throws IOException {
        URL location = this.getFilePath(sampleLocation);
        Map<String, Object> options = this.getOptions("wrong");
        ISecurePreferences preferences = this.newPreferences(location, options);
        try {
            ISecurePreferences node = preferences.node("/cvs/eclipse.org");
            boolean exception = false;
            try {
                node.get(key, defaultValue);
            }
            catch (StorageException e) {
                Assert.assertEquals((long)0L, (long)e.getErrorCode());
                exception = true;
            }
            Assert.assertTrue((boolean)exception);
        }
        finally {
            this.closePreferences(preferences);
        }
    }

    @Test
    public void testModules() throws IOException {
        URL location = this.getFilePath(sampleLocation);
        ISecurePreferences preferences = this.newPreferences(location, this.getOptions(null));
        try {
            ISecurePreferences node = preferences.node("/cvs/eclipse.org/account1");
            boolean exception = false;
            try {
                node.get("password1", defaultValue);
            }
            catch (StorageException e) {
                Assert.assertEquals((long)1L, (long)e.getErrorCode());
                exception = true;
            }
            Assert.assertTrue((boolean)exception);
            exception = false;
            try {
                node.get("password2", defaultValue);
            }
            catch (StorageException e) {
                Assert.assertEquals((long)3L, (long)e.getErrorCode());
                exception = true;
            }
            Assert.assertTrue((boolean)exception);
        }
        finally {
            this.closePreferences(preferences);
        }
    }

    @Test
    public void testEdgeCases() throws StorageException, MalformedURLException, IOException {
        byte[] expectedEmptyArray = new byte[]{};
        byte[] wrongArray = new byte[]{1, 2, 3};
        ISecurePreferences preferences = this.newPreferences(this.getStorageLocation(), this.getOptions());
        ISecurePreferences node = preferences.node("/testEdge");
        node.put("emptyString1", "", true);
        node.put("emptyString2", "", false);
        node.put("nullString1", null, true);
        node.put("nullString2", null, false);
        node.putByteArray("emptyArray1", new byte[0], true);
        node.putByteArray("emptyArray2", new byte[0], false);
        node.putByteArray("nullArray1", null, true);
        node.putByteArray("nullArray2", null, false);
        Assert.assertEquals((Object)"", (Object)node.get("emptyString1", "wrong"));
        Assert.assertEquals((Object)"", (Object)node.get("emptyString2", "wrong"));
        Assert.assertNull((Object)node.get("nullString1", "wrong"));
        Assert.assertNull((Object)node.get("nullString2", "wrong"));
        this.compareArrays(expectedEmptyArray, node.getByteArray("emptyArray1", wrongArray));
        this.compareArrays(expectedEmptyArray, node.getByteArray("emptyArray2", wrongArray));
        Assert.assertNull((Object)node.getByteArray("nullString1", wrongArray));
        Assert.assertNull((Object)node.getByteArray("nullString2", wrongArray));
        preferences.flush();
        this.closePreferences(preferences);
        preferences = this.newPreferences(this.getStorageLocation(), this.getOptions());
        node = preferences.node("/testEdge");
        Assert.assertEquals((Object)"", (Object)node.get("emptyString1", "wrong"));
        Assert.assertEquals((Object)"", (Object)node.get("emptyString2", "wrong"));
        Assert.assertNull((Object)node.get("nullString1", "wrong"));
        Assert.assertNull((Object)node.get("nullString2", "wrong"));
        this.compareArrays(expectedEmptyArray, node.getByteArray("emptyArray1", wrongArray));
        this.compareArrays(expectedEmptyArray, node.getByteArray("emptyArray2", wrongArray));
        Assert.assertNull((Object)node.getByteArray("nullString1", wrongArray));
        Assert.assertNull((Object)node.getByteArray("nullString2", wrongArray));
    }

    private void findAll(String[] array1, String[] array2) {
        Assert.assertNotNull((Object)array1);
        Assert.assertNotNull((Object)array2);
        Assert.assertEquals((long)array1.length, (long)array2.length);
        String[] stringArray = array1;
        int n = array1.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            boolean found = false;
            String[] stringArray2 = array2;
            int n3 = array2.length;
            int n4 = 0;
            while (n4 < n3) {
                String s2 = stringArray2[n4];
                if (s.equals(s2)) {
                    found = true;
                    break;
                }
                ++n4;
            }
            Assert.assertTrue((boolean)found);
            ++n2;
        }
    }

    private void compareArrays(byte[] array1, byte[] array2) {
        Assert.assertNotNull((Object)array1);
        Assert.assertNotNull((Object)array2);
        Assert.assertEquals((long)array1.length, (long)array2.length);
        int i = 0;
        while (i < array1.length) {
            Assert.assertEquals((long)array1[i], (long)array2[i]);
            ++i;
        }
    }

    private URL getFilePath(String path) throws IOException {
        BundleContext bundleContext = SecurityTestsActivator.getDefault().getBundleContext();
        URL url = bundleContext.getBundle().getEntry(path);
        return FileLocator.toFileURL((URL)url);
    }
}

