/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.security.tests.storage;

import java.util.Map;
import org.eclipse.equinox.internal.security.tests.SecurityTestsActivator;
import org.eclipse.equinox.internal.security.tests.storage.SecurePreferencesTest;
import org.junit.Assume;
import org.junit.Before;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class WinPreferencesTest
extends SecurePreferencesTest {
    private static final String WIN_BUNDLE = "org.eclipse.equinox.security.win32";
    private static final String WIN_64BIT_MODULE_ID = "org.eclipse.equinox.security.WindowsPasswordProvider64bit";

    @Before
    public void setUp() {
        Assume.assumeTrue((boolean)WinPreferencesTest.hasBundle(WIN_BUNDLE));
    }

    @Override
    protected String getModuleID() {
        return WIN_64BIT_MODULE_ID;
    }

    @Override
    protected Map<String, Object> getOptions() {
        return this.getOptions(null);
    }

    private static boolean hasBundle(String symbolicID) {
        Bundle[] bundles;
        BundleContext context = SecurityTestsActivator.getDefault().getBundleContext();
        Bundle[] bundleArray = bundles = context.getBundles();
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            String bundleName = bundle.getSymbolicName();
            if (symbolicID.equals(bundleName)) {
                int bundleState = bundle.getState();
                return bundleState != 2 && bundleState != 1;
            }
            ++n2;
        }
        return false;
    }
}

