/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.rcp;

import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.tests.rcp.util.WorkbenchAdvisorObserver;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class IWorkbenchPageTest {
    private Display display = null;

    @BeforeEach
    public void setUp() throws Exception {
        Assertions.assertNull((Object)this.display);
        this.display = PlatformUI.createDisplay();
        Assertions.assertNotNull((Object)this.display);
    }

    @AfterEach
    public void tearDown() throws Exception {
        Assertions.assertNotNull((Object)this.display);
        this.display.dispose();
        Assertions.assertTrue((boolean)this.display.isDisposed());
    }

    @Test
    public void test70080() {
        WorkbenchAdvisorObserver wa = new WorkbenchAdvisorObserver(1){

            @Override
            public void preWindowOpen(IWorkbenchWindowConfigurer configurer) {
                super.preWindowOpen(configurer);
                configurer.setShowPerspectiveBar(false);
            }

            @Override
            public void postStartup() {
                try {
                    IWorkbenchWindow window = this.getWorkbenchConfigurer().getWorkbench().getActiveWorkbenchWindow();
                    IWorkbenchPage page = window.getActivePage();
                    page.showView("org.eclipse.ui.tests.rcp.util.EmptyView");
                    Assertions.assertNotNull((Object)page.findView("org.eclipse.ui.tests.rcp.util.EmptyView"));
                    page.resetPerspective();
                    Assertions.assertNull((Object)page.findView("org.eclipse.ui.tests.rcp.util.EmptyView"));
                }
                catch (PartInitException e) {
                    Assertions.fail((String)e.toString());
                }
            }
        };
        int code = PlatformUI.createAndRunWorkbench((Display)this.display, (WorkbenchAdvisor)wa);
        Assertions.assertEquals((int)0, (int)code);
    }
}

