/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.rcp;

import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.tests.harness.util.RCPTestWorkbenchAdvisor;
import org.eclipse.ui.tests.rcp.CheckForWorkbench;
import org.eclipse.ui.tests.rcp.util.WorkbenchAdvisorObserver;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;

public class PlatformUITest {
    @Test
    public void testEarlyGetWorkbench() {
        Assertions.assertFalse((boolean)PlatformUI.isWorkbenchRunning());
        Assertions.assertThrows(IllegalStateException.class, () -> {
            IWorkbench iWorkbench = PlatformUI.getWorkbench();
        });
    }

    @Test
    public void testCreateDisplay() {
        Display disp = PlatformUI.createDisplay();
        Assertions.assertNotNull((Object)disp);
        Assertions.assertFalse((boolean)disp.isDisposed());
        disp.dispose();
        Assertions.assertTrue((boolean)disp.isDisposed());
    }

    @Test
    public void testCreateAndRunWorkbench() {
        Display display = PlatformUI.createDisplay();
        Assertions.assertNotNull((Object)display);
        CheckForWorkbench wa = new CheckForWorkbench(2);
        int code = PlatformUI.createAndRunWorkbench((Display)display, (WorkbenchAdvisor)wa);
        Assertions.assertEquals((int)0, (int)code);
        Assertions.assertTrue((boolean)wa.checkComplete);
        display.dispose();
        Assertions.assertTrue((boolean)display.isDisposed());
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertFalse((boolean)RCPTestWorkbenchAdvisor.asyncDuringStartup, (String)"Async run during startup.  See RCPTestWorkbenchAdvisor.preStartup()"), () -> Assertions.assertTrue((boolean)RCPTestWorkbenchAdvisor.syncWithDisplayAccess, (String)"Sync from qualified thread did not run during startup.  See RCPTestWorkbenchAdvisor.preStartup()"), () -> Assertions.assertTrue((boolean)RCPTestWorkbenchAdvisor.asyncWithDisplayAccess, (String)"Async from qualified thread did not run during startup.  See RCPTestWorkbenchAdvisor.preStartup()"), () -> Assertions.assertFalse((boolean)RCPTestWorkbenchAdvisor.syncWithoutDisplayAccess, (String)"Sync from un-qualified thread ran during startup.  See RCPTestWorkbenchAdvisor.preStartup()"), () -> Assertions.assertFalse((boolean)RCPTestWorkbenchAdvisor.asyncWithoutDisplayAccess, (String)"Async from un-qualified thread ran during startup.  See RCPTestWorkbenchAdvisor.preStartup()"), () -> Assertions.assertFalse((boolean)RCPTestWorkbenchAdvisor.displayAccessInUIThreadAllowed, (String)"DisplayAccess.accessDisplayDuringStartup() in UI thread did not result in exception.")});
    }

    @Disabled
    @Test
    public void testCreateAndRunWorkbenchWithExceptionOnStartup() {
        Display display = PlatformUI.createDisplay();
        Assertions.assertNotNull((Object)display);
        WorkbenchAdvisorObserver wa = new WorkbenchAdvisorObserver(1){

            @Override
            public void preStartup() {
                throw new IllegalArgumentException("Thrown deliberately by PlatformUITest");
            }
        };
        int code = PlatformUI.createAndRunWorkbench((Display)display, (WorkbenchAdvisor)wa);
        Assertions.assertEquals((int)2, (int)code);
        Assertions.assertFalse((boolean)PlatformUI.isWorkbenchRunning());
        display.dispose();
        Assertions.assertTrue((boolean)display.isDisposed());
    }
}

