/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.rcp;

import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.application.IWorkbenchConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.tests.rcp.WorkbenchAdvisorExceptionObserver;
import org.eclipse.ui.tests.rcp.util.WorkbenchAdvisorObserver;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class WorkbenchAdvisorTest {
    private Display display = null;

    @BeforeEach
    public void setUp() {
        Assertions.assertNull((Object)this.display);
        this.display = PlatformUI.createDisplay();
        Assertions.assertNotNull((Object)this.display);
    }

    @AfterEach
    public void tearDown() {
        Assertions.assertNotNull((Object)this.display);
        this.display.dispose();
        Assertions.assertTrue((boolean)this.display.isDisposed());
    }

    @Test
    public void testEarlyGetWorkbench() {
        WorkbenchAdvisorObserver wa = new WorkbenchAdvisorObserver(1){

            @Override
            public void initialize(IWorkbenchConfigurer configurer) {
                super.initialize(configurer);
                Assertions.assertNotNull((Object)PlatformUI.getWorkbench());
            }
        };
        int code = PlatformUI.createAndRunWorkbench((Display)this.display, (WorkbenchAdvisor)wa);
        Assertions.assertEquals((int)0, (int)code);
    }

    @Test
    public void testTwoDisplays() {
        WorkbenchAdvisorObserver wa = new WorkbenchAdvisorObserver(1);
        int code = PlatformUI.createAndRunWorkbench((Display)this.display, (WorkbenchAdvisor)wa);
        Assertions.assertEquals((int)0, (int)code);
        Assertions.assertFalse((boolean)this.display.isDisposed());
        this.display.dispose();
        Assertions.assertTrue((boolean)this.display.isDisposed());
        this.display = PlatformUI.createDisplay();
        Assertions.assertNotNull((Object)this.display);
        WorkbenchAdvisorObserver wa2 = new WorkbenchAdvisorObserver(1);
        int code2 = PlatformUI.createAndRunWorkbench((Display)this.display, (WorkbenchAdvisor)wa2);
        Assertions.assertEquals((int)0, (int)code2);
    }

    @Test
    public void testTrivialOpenClose() {
        WorkbenchAdvisorObserver wa = new WorkbenchAdvisorObserver(1){
            private boolean windowOpenCalled;
            private boolean windowCloseCalled;
            {
                this.windowOpenCalled = false;
                this.windowCloseCalled = false;
            }

            @Override
            public void initialize(IWorkbenchConfigurer c) {
                super.initialize(c);
                c.getWorkbench().addWindowListener(new IWindowListener(){

                    public void windowActivated(IWorkbenchWindow window) {
                    }

                    public void windowDeactivated(IWorkbenchWindow window) {
                    }

                    public void windowClosed(IWorkbenchWindow window) {
                        windowCloseCalled = true;
                    }

                    public void windowOpened(IWorkbenchWindow window) {
                        windowOpenCalled = true;
                    }
                });
            }

            @Override
            public void preWindowOpen(IWorkbenchWindowConfigurer c) {
                Assertions.assertFalse((boolean)this.windowOpenCalled);
                super.preWindowOpen(c);
            }

            @Override
            public void postWindowOpen(IWorkbenchWindowConfigurer c) {
                Assertions.assertTrue((boolean)this.windowOpenCalled);
                super.postWindowOpen(c);
            }

            @Override
            public boolean preWindowShellClose(IWorkbenchWindowConfigurer c) {
                Assertions.assertFalse((boolean)this.windowCloseCalled);
                return super.preWindowShellClose(c);
            }

            public void postWindowClose(IWorkbenchWindowConfigurer c) {
                super.postWindowClose(c);
            }
        };
        int code = PlatformUI.createAndRunWorkbench((Display)this.display, (WorkbenchAdvisor)wa);
        Assertions.assertEquals((int)0, (int)code);
        wa.resetOperationIterator();
        wa.assertNextOperation("initialize");
        wa.assertNextOperation("preStartup");
        wa.assertNextOperation("preWindowOpen");
        wa.assertNextOperation("fillActionBars");
        wa.assertNextOperation("postWindowRestore");
        wa.assertNextOperation("postWindowOpen");
        wa.assertNextOperation("postStartup");
        wa.assertNextOperation("preShutdown");
        wa.assertNextOperation("postShutdown");
        wa.assertAllOperationsExamined();
    }

    @Test
    public void testTrivialRestoreClose() {
        WorkbenchAdvisorObserver wa = new WorkbenchAdvisorObserver(1){

            @Override
            public void initialize(IWorkbenchConfigurer c) {
                super.initialize(c);
                c.setSaveAndRestore(true);
            }

            public void eventLoopIdle(Display d) {
                this.workbenchConfig.getWorkbench().restart();
            }
        };
        int code = PlatformUI.createAndRunWorkbench((Display)this.display, (WorkbenchAdvisor)wa);
        Assertions.assertEquals((int)1, (int)code);
        Assertions.assertFalse((boolean)this.display.isDisposed());
        this.display.dispose();
        Assertions.assertTrue((boolean)this.display.isDisposed());
        this.display = PlatformUI.createDisplay();
        WorkbenchAdvisorObserver wa2 = new WorkbenchAdvisorObserver(1){

            @Override
            public void initialize(IWorkbenchConfigurer c) {
                super.initialize(c);
                c.setSaveAndRestore(true);
            }
        };
        int code2 = PlatformUI.createAndRunWorkbench((Display)this.display, (WorkbenchAdvisor)wa2);
        Assertions.assertEquals((int)0, (int)code2);
        wa2.resetOperationIterator();
        wa2.assertNextOperation("initialize");
        wa2.assertNextOperation("preStartup");
        wa2.assertNextOperation("preWindowOpen");
        wa2.assertNextOperation("fillActionBars");
        wa2.assertNextOperation("postWindowRestore");
        wa2.assertNextOperation("postWindowOpen");
        wa2.assertNextOperation("postStartup");
        wa2.assertNextOperation("preShutdown");
        wa2.assertNextOperation("postShutdown");
        wa2.assertAllOperationsExamined();
    }

    @Test
    public void testCloseFromPostStartup() {
        WorkbenchAdvisorObserver wa = new WorkbenchAdvisorObserver(1){

            @Override
            public void postStartup() {
                super.postStartup();
                Assertions.assertTrue((boolean)PlatformUI.getWorkbench().close());
            }
        };
        int code = PlatformUI.createAndRunWorkbench((Display)this.display, (WorkbenchAdvisor)wa);
        Assertions.assertEquals((int)0, (int)code);
        wa.resetOperationIterator();
        wa.assertNextOperation("initialize");
        wa.assertNextOperation("preStartup");
        wa.assertNextOperation("preWindowOpen");
        wa.assertNextOperation("fillActionBars");
        wa.assertNextOperation("postWindowRestore");
        wa.assertNextOperation("postWindowOpen");
        wa.assertNextOperation("postStartup");
        wa.assertNextOperation("preShutdown");
        wa.assertNextOperation("postShutdown");
        wa.assertAllOperationsExamined();
    }

    @Test
    public void testEventLoopCrash() {
        WorkbenchAdvisorExceptionObserver wa = new WorkbenchAdvisorExceptionObserver();
        int code = PlatformUI.createAndRunWorkbench((Display)this.display, (WorkbenchAdvisor)wa);
        Assertions.assertEquals((int)0, (int)code);
        Assertions.assertTrue((boolean)wa.exceptionCaught);
    }

    @Test
    public void testFillAllActionBar() {
        WorkbenchAdvisorObserver wa = new WorkbenchAdvisorObserver(1){

            @Override
            public void fillActionBars(IWorkbenchWindow window, IActionBarConfigurer configurer, int flags) {
                super.fillActionBars(window, configurer, flags);
                Assertions.assertEquals((int)4, (int)(flags & 4));
                Assertions.assertEquals((int)2, (int)(flags & 2));
                Assertions.assertEquals((int)8, (int)(flags & 8));
                Assertions.assertEquals((int)0, (int)(flags & 1));
            }
        };
        int code = PlatformUI.createAndRunWorkbench((Display)this.display, (WorkbenchAdvisor)wa);
        Assertions.assertEquals((int)0, (int)code);
    }

    @Test
    public void testEmptyProgressRegion() {
        WorkbenchAdvisorObserver wa = new WorkbenchAdvisorObserver(1){

            @Override
            public void preWindowOpen(IWorkbenchWindowConfigurer configurer) {
                super.preWindowOpen(configurer);
                configurer.setShowProgressIndicator(false);
            }
        };
        int code = PlatformUI.createAndRunWorkbench((Display)this.display, (WorkbenchAdvisor)wa);
        Assertions.assertEquals((int)0, (int)code);
    }

    @Test
    public void testShellClose() {
        WorkbenchAdvisorObserver wa = new WorkbenchAdvisorObserver(){

            public void eventLoopIdle(Display disp) {
                Shell[] shells;
                super.eventLoopIdle(disp);
                Shell[] shellArray = shells = disp.getShells();
                int n = shells.length;
                int n2 = 0;
                while (n2 < n) {
                    Shell shell = shellArray[n2];
                    if (shell != null && !shell.isDisposed()) {
                        shell.close();
                    }
                    ++n2;
                }
            }
        };
        int code = PlatformUI.createAndRunWorkbench((Display)this.display, (WorkbenchAdvisor)wa);
        Assertions.assertEquals((int)0, (int)code);
        wa.resetOperationIterator();
        wa.assertNextOperation("initialize");
        wa.assertNextOperation("preStartup");
        wa.assertNextOperation("preWindowOpen");
        wa.assertNextOperation("fillActionBars");
        wa.assertNextOperation("postWindowRestore");
        wa.assertNextOperation("postWindowOpen");
        wa.assertNextOperation("postStartup");
        wa.assertNextOperation("preWindowShellClose");
        wa.assertNextOperation("preShutdown");
        wa.assertNextOperation("postShutdown");
        wa.assertAllOperationsExamined();
    }
}

