/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.rcp;

import java.util.ArrayList;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.tests.rcp.util.WorkbenchAdvisorObserver;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class WorkbenchListenerTest {
    private Display display = null;

    @BeforeEach
    public void setUp() throws Exception {
        Assertions.assertNull((Object)this.display);
        this.display = PlatformUI.createDisplay();
        Assertions.assertNotNull((Object)this.display);
    }

    @AfterEach
    public void tearDown() throws Exception {
        Assertions.assertNotNull((Object)this.display);
        this.display.dispose();
        Assertions.assertTrue((boolean)this.display.isDisposed());
    }

    @Test
    public void testPreAndPostShutdown() {
        final boolean[] proceed = new boolean[1];
        final ArrayList operations = new ArrayList();
        WorkbenchAdvisorObserver wa = new WorkbenchAdvisorObserver(1){

            @Override
            public void postStartup() {
                IWorkbench workbench = this.getWorkbenchConfigurer().getWorkbench();
                workbench.addWorkbenchListener(new IWorkbenchListener(){

                    public boolean preShutdown(IWorkbench workbench, boolean forced) {
                        operations.add("preShutdown");
                        return proceed[0];
                    }

                    public void postShutdown(IWorkbench workbench) {
                        operations.add("postShutdown");
                    }
                });
                proceed[0] = false;
                Assertions.assertEquals((Object)false, (Object)workbench.close());
                proceed[0] = true;
                Assertions.assertEquals((Object)true, (Object)workbench.close());
            }
        };
        int code = PlatformUI.createAndRunWorkbench((Display)this.display, (WorkbenchAdvisor)wa);
        Assertions.assertEquals((int)0, (int)code);
        Assertions.assertEquals((int)3, (int)operations.size());
        Assertions.assertEquals((Object)"preShutdown", operations.get(0));
        Assertions.assertEquals((Object)"preShutdown", operations.get(1));
        Assertions.assertEquals((Object)"postShutdown", operations.get(2));
    }
}

