/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.rcp;

import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.ActivityManagerEvent;
import org.eclipse.ui.activities.IActivityManager;
import org.eclipse.ui.activities.IActivityManagerListener;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.tests.harness.util.RCPTestWorkbenchAdvisor;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class WorkbenchTest {
    @Test
    public void testWorkbenchShutdownProducesNoActivityManagerEvents() {
        final IActivityManagerListener activityListener = (IActivityManagerListener)Mockito.mock(IActivityManagerListener.class);
        RCPTestWorkbenchAdvisor closeAfterStartupAdvisor = new RCPTestWorkbenchAdvisor(){

            public void postStartup() {
                IWorkbench workbench = this.getWorkbenchConfigurer().getWorkbench();
                IActivityManager activityManager = workbench.getActivitySupport().getActivityManager();
                activityManager.addActivityManagerListener(activityListener);
                workbench.close();
            }
        };
        this.runWorkbench((WorkbenchAdvisor)closeAfterStartupAdvisor);
        ((IActivityManagerListener)Mockito.verify((Object)activityListener, (VerificationMode)Mockito.never())).activityManagerChanged((ActivityManagerEvent)ArgumentMatchers.any());
    }

    private void runWorkbench(WorkbenchAdvisor workbenchAdvisor) {
        Display display = PlatformUI.createDisplay();
        PlatformUI.createAndRunWorkbench((Display)display, (WorkbenchAdvisor)workbenchAdvisor);
    }
}

