/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.tests.rcp.util;

import org.eclipse.swt.widgets.Display;
import org.eclipse.test.performance.PerformanceMeter;
import org.eclipse.ui.application.IWorkbenchConfigurer;
import org.eclipse.ui.tests.harness.util.RCPTestWorkbenchAdvisor;

public class RestoreWorkbenchIntervalMonitor
extends RCPTestWorkbenchAdvisor {
    private final PerformanceMeter startupMeter;
    private final PerformanceMeter shutdownMeter;
    private boolean createRestorableWorkbench = false;
    private IWorkbenchConfigurer workbenchConfigurer;

    public RestoreWorkbenchIntervalMonitor(PerformanceMeter startupMeter, PerformanceMeter shutdownMeter, boolean createRestorableWorkbench) {
        super(2);
        this.startupMeter = startupMeter;
        this.shutdownMeter = shutdownMeter;
        this.createRestorableWorkbench = createRestorableWorkbench;
    }

    public void initialize(IWorkbenchConfigurer configurer) {
        super.initialize(configurer);
        this.workbenchConfigurer = configurer;
        this.workbenchConfigurer.setSaveAndRestore(true);
    }

    public void postStartup() {
        this.startupMeter.stop();
        super.postStartup();
    }

    public boolean preShutdown() {
        boolean ret = super.preShutdown();
        this.shutdownMeter.start();
        return ret;
    }

    public void eventLoopIdle(Display d) {
        if (this.createRestorableWorkbench) {
            this.workbenchConfigurer.getWorkbench().restart();
        } else {
            super.eventLoopIdle(d);
        }
    }
}

