/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.ole.win32;

import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class OlePlugin
extends AbstractUIPlugin {
    private static OlePlugin plugin;
    private static ResourceBundle resourceBundle;
    static final int biBack = 0;
    static final int biForward = 1;
    static final int biHome = 2;
    static final int biStop = 3;
    static final int biRefresh = 4;
    static final int biSearch = 5;
    static final String[] imageLocations;
    static Image[] images;
    static Font browserFont;

    static {
        imageLocations = new String[]{"icons/backward_nav.gif", "icons/forward_nav.gif", "icons/home_nav.gif", "icons/stop_nav.gif", "icons/refresh_nav.gif", "icons/search_nav.gif"};
    }

    public OlePlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        resourceBundle = Platform.getResourceBundle((Bundle)this.getBundle());
    }

    public void stop(BundleContext context) throws Exception {
        OlePlugin.freeResources();
        super.stop(context);
    }

    public static OlePlugin getDefault() {
        return plugin;
    }

    public static String getResourceString(String key) {
        try {
            return resourceBundle.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
        catch (NullPointerException nullPointerException) {
            return "!" + key + "!";
        }
    }

    public static String getResourceString(String key, Object[] args) {
        try {
            return MessageFormat.format(OlePlugin.getResourceString(key), args);
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
        catch (NullPointerException nullPointerException) {
            return "!" + key + "!";
        }
    }

    public static void logError(String message, Throwable exception) {
        plugin.getLog().log((IStatus)new Status(4, plugin.getBundle().getSymbolicName(), 0, message, exception));
    }

    public static void initResources() {
        if (images == null) {
            images = new Image[imageLocations.length];
            int i = 0;
            while (i < imageLocations.length) {
                OlePlugin.images[i] = OlePlugin.getImageFromPlugin(plugin.getBundle(), imageLocations[i]);
                if (images[i] == null) {
                    OlePlugin.freeResources();
                    OlePlugin.logError(OlePlugin.getResourceString("error.CouldNotLoadResources"), null);
                    throw new IllegalStateException();
                }
                ++i;
            }
        }
        if (browserFont == null) {
            try {
                browserFont = new Font(null, "MS Sans Serif", 8, 0);
            }
            catch (Throwable throwable) {}
        }
        if (images == null || browserFont == null) {
            OlePlugin.freeResources();
            OlePlugin.logError(OlePlugin.getResourceString("error.CouldNotLoadResources"), null);
            throw new IllegalStateException();
        }
    }

    public static void freeResources() {
        if (images != null) {
            Image[] imageArray = images;
            int n = images.length;
            int n2 = 0;
            while (n2 < n) {
                Image image = imageArray[n2];
                if (image != null) {
                    image.dispose();
                }
                ++n2;
            }
            images = null;
        }
        if (browserFont != null) {
            browserFont.dispose();
        }
        browserFont = null;
    }

    private static Image getImageFromPlugin(Bundle bundle, String iconPath) {
        URL installUrl = bundle.getEntry("/");
        try {
            Throwable throwable = null;
            Object var4_5 = null;
            try (InputStream is = new URL(installUrl, iconPath).openConnection().getInputStream();){
                ImageData source = new ImageData(is);
                ImageData mask = source.getTransparencyMask();
                Image image = new Image(null, source, mask);
                return image;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Throwable throwable) {
            return null;
        }
    }
}

