/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.saveparticipant2;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.ISavedState;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.tests.resources.ResourceDeltaVerifier;

public class SaveParticipant2Plugin
extends Plugin
implements ISaveParticipant {
    private final ResourceDeltaVerifier deltaVerifier;
    private int expectedPreviousSaveNumber;
    private int saveKind;
    protected MultiStatus saveLifecycleLog;
    private static final String SAVE_NUMBER_LOCATION = "saveNumber";
    private static SaveParticipant2Plugin instance;

    public SaveParticipant2Plugin() {
        instance = this;
        this.deltaVerifier = new ResourceDeltaVerifier();
    }

    public void addExpectedChange(IResource[] resources, int status, int changeFlags) {
        this.deltaVerifier.addExpectedChange(resources, status, changeFlags);
    }

    public void addExpectedChange(IResource resource, int status, int changeFlags) {
        this.deltaVerifier.addExpectedChange(resource, status, changeFlags);
    }

    public void addExpectedChange(IResource resource, IResource topLevelParent, int status, int changeFlags) {
        this.deltaVerifier.addExpectedChange(resource, topLevelParent, status, changeFlags);
    }

    public void deregisterAsSaveParticipant() {
        this.getWorkspace().removeSaveParticipant(this.getPluginId());
    }

    public void doneSaving(ISaveContext context) {
        try {
            this.writeExpectedSaveNumber(context.getSaveNumber());
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    public ResourceDeltaVerifier getDeltaVerifier() {
        return this.deltaVerifier;
    }

    private String getMessage(int expectedPreviousSaveNumber, int previousSaveNumber) {
        StringBuilder message = new StringBuilder();
        message.append("Expected previous saved id was: ");
        message.append(expectedPreviousSaveNumber);
        message.append("\nPrevious saved id is: ");
        message.append(previousSaveNumber);
        message.append("\n");
        return message.toString();
    }

    public String getPluginId() {
        return this.getBundle().getSymbolicName();
    }

    public IStatus getSaveLifecycleLog() {
        return this.saveLifecycleLog;
    }

    private IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public void prepareToSave(ISaveContext context) throws CoreException {
        this.resetSaveLifecycleLog();
        IStatus status = this.validate(context);
        if (!status.isOK()) {
            this.saveLifecycleLog.addAll(status);
        }
        context.needDelta();
        context.needSaveNumber();
    }

    private void readExpectedSavedNumber() {
        IPath location = this.getStateLocation().append(SAVE_NUMBER_LOCATION);
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (DataInputStream input = new DataInputStream(Files.newInputStream(location.toPath(), new OpenOption[0]));){
                this.expectedPreviousSaveNumber = input.readInt();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            this.expectedPreviousSaveNumber = 0;
        }
    }

    public IStatus registerAsSaveParticipant() throws CoreException {
        ISavedState state = this.getWorkspace().addSaveParticipant(this.getPluginId(), (ISaveParticipant)this);
        this.readExpectedSavedNumber();
        return this.validate(state);
    }

    public void resetDeltaVerifier() {
        this.deltaVerifier.reset();
    }

    protected void resetSaveLifecycleLog() {
        String message = "save lifecycle log for SaveParticipantPlugin";
        this.saveLifecycleLog = new MultiStatus(this.getPluginId(), 0, message, null);
    }

    public void rollback(ISaveContext context) {
    }

    public void saving(ISaveContext context) throws CoreException {
    }

    public void setExpectedSaveKind(int saveKind) {
        this.saveKind = saveKind;
    }

    private IStatus validate(ISaveContext context) {
        if (context.getPreviousSaveNumber() != 0 || this.expectedPreviousSaveNumber != 0) {
            try {
                if (context.getPreviousSaveNumber() != this.expectedPreviousSaveNumber) {
                    String message = this.getMessage(this.expectedPreviousSaveNumber, context.getPreviousSaveNumber());
                    return new Status(4, this.getPluginId(), 4, message, null);
                }
            }
            catch (NullPointerException e) {
                String message = this.getMessage(this.expectedPreviousSaveNumber, context.getPreviousSaveNumber());
                return new Status(4, this.getPluginId(), 4, message, (Throwable)e);
            }
        }
        if (context.getKind() != this.saveKind) {
            String message = "Save kind was different than expected.";
            return new Status(4, this.getPluginId(), 4, message, null);
        }
        return new Status(0, this.getPluginId(), 0, "OK", null);
    }

    private IStatus validate(ISavedState state) {
        if (state == null && this.expectedPreviousSaveNumber == 0) {
            return new Status(0, this.getPluginId(), 0, "OK", null);
        }
        try {
            state.processResourceChangeEvents((IResourceChangeListener)this.deltaVerifier);
            if (state.getSaveNumber() != this.expectedPreviousSaveNumber) {
                String message = "saved id is different than expected";
                return new Status(4, this.getPluginId(), 4, message, null);
            }
            if (!this.deltaVerifier.isDeltaValid()) {
                Object message = "delta is different than expected\n";
                message = (String)message + this.deltaVerifier.getMessage();
                return new Status(4, this.getPluginId(), 4, (String)message, null);
            }
        }
        catch (NullPointerException e) {
            String message = "ISavedState is different than expected";
            return new Status(4, this.getPluginId(), 4, message, (Throwable)e);
        }
        return new Status(0, this.getPluginId(), 0, "OK", null);
    }

    private void writeExpectedSaveNumber(int saveNumber) throws IOException {
        IPath location = this.getStateLocation().append(SAVE_NUMBER_LOCATION);
        Throwable throwable = null;
        Object var4_5 = null;
        try (DataOutputStream output = new DataOutputStream(new FileOutputStream(location.toOSString()));){
            output.writeInt(saveNumber);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static SaveParticipant2Plugin getInstance() {
        return instance;
    }
}

