/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.unittest.junit.launcher;

import java.time.Duration;
import java.util.Arrays;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.jdt.ui.unittest.junit.JUnitTestPlugin;
import org.eclipse.jdt.ui.unittest.junit.internal.launcher.RemoteTestRunnerClient;
import org.eclipse.unittest.model.ITestCaseElement;
import org.eclipse.unittest.model.ITestElement;
import org.eclipse.unittest.model.ITestRunSession;
import org.eclipse.unittest.model.ITestSuiteElement;

public class JUnitRemoteTestRunnerClient
extends RemoteTestRunnerClient {
    private ITestElement fFailedTest;
    private ITestElement.Result fFailureKind;
    private boolean fFailedAssumption;
    private final StringBuilder fFailedTrace = new StringBuilder();
    private final StringBuilder fExpectedResult = new StringBuilder();
    private final StringBuilder fActualResult = new StringBuilder();
    private final StringBuilder fFailedRerunTrace = new StringBuilder();
    private ITestSuiteElement currentSuite;
    ProcessingState fDefaultState = new DefaultProcessingState();
    ProcessingState fTraceState = new TraceProcessingState();
    ProcessingState fExpectedState = new AppendingProcessingState(this.fExpectedResult, "%EXPECTE");
    ProcessingState fActualState = new AppendingProcessingState(this.fActualResult, "%ACTUALE");
    ProcessingState fRerunState = new AppendingProcessingState(this.fFailedRerunTrace, "%RTRACEE");
    ProcessingState fCurrentState = this.fDefaultState;

    public JUnitRemoteTestRunnerClient(int port, ITestRunSession session) {
        super(port, session);
    }

    public synchronized void stopTest() {
        this.fWriter.println(">STOP   ");
        this.fWriter.flush();
        ILaunch launch = this.fTestRunSession.getLaunch();
        try {
            launch.terminate();
        }
        catch (Exception ex) {
            JUnitTestPlugin.log(ex);
        }
    }

    @Override
    public void receiveMessage(String message) {
        this.fCurrentState = this.fCurrentState.readMessage(message);
    }

    private void scanOldReranMessage(String arg) {
        int c = arg.indexOf(" ");
        int t = arg.indexOf(" ", c + 1);
        String className = arg.substring(0, c);
        String testName = arg.substring(c + 1, t);
        String status = arg.substring(t + 1);
        String testId = className + testName;
        this.notifyTestReran(testId, className, testName, status);
    }

    private void scanReranMessage(String arg) {
        int i = arg.indexOf(32);
        int c = arg.indexOf(32, i + 1);
        int t = arg.endsWith("ERROR") ? arg.length() - "ERROR".length() - 1 : (arg.endsWith("FAILURE") ? arg.length() - "FAILURE".length() - 1 : (arg.endsWith("OK") ? arg.length() - "OK".length() - 1 : arg.indexOf(32, c + 1)));
        String testId = arg.substring(0, i);
        String className = arg.substring(i + 1, c);
        String testName = arg.substring(c + 1, t);
        String status = arg.substring(t + 1);
        this.notifyTestReran(testId, className, testName, status);
    }

    protected String[] extractTestId(String arg) {
        String[] result = new String[2];
        if (!this.hasTestId()) {
            result[0] = arg;
            result[1] = arg;
            return result;
        }
        int i = arg.indexOf(44);
        result[0] = arg.substring(0, i);
        result[1] = arg.substring(i + 1, arg.length());
        return result;
    }

    protected boolean hasTestId() {
        if (this.fVersion == null) {
            return true;
        }
        return this.fVersion.equals("v2");
    }

    private void notifyTestTreeEntry(String treeEntry) {
        String uniqueId;
        String displayName;
        String parentId;
        int testCount;
        String fixedTreeEntry = this.hasTestId() ? treeEntry : this.fakeTestId(treeEntry);
        int index0 = fixedTreeEntry.indexOf(44);
        String id = fixedTreeEntry.substring(0, index0);
        StringBuilder testNameBuffer = new StringBuilder(100);
        int index1 = this.scanTestName(fixedTreeEntry, index0 + 1, testNameBuffer);
        String testName = testNameBuffer.toString().trim();
        int index2 = fixedTreeEntry.indexOf(44, index1 + 1);
        boolean isSuite = fixedTreeEntry.substring(index1 + 1, index2).equals("true");
        StringBuilder displayNameBuffer = new StringBuilder(100);
        StringBuilder parameterTypesBuffer = new StringBuilder(200);
        StringBuilder uniqueIdBuffer = new StringBuilder(200);
        int index3 = fixedTreeEntry.indexOf(44, index2 + 1);
        if (index3 == -1) {
            testCount = Integer.parseInt(fixedTreeEntry.substring(index2 + 1));
            parentId = null;
            displayName = null;
            Object parameterTypes = null;
            uniqueId = null;
        } else {
            int index5;
            testCount = Integer.parseInt(fixedTreeEntry.substring(index2 + 1, index3));
            int index4 = fixedTreeEntry.indexOf(44, index3 + 1);
            parentId = fixedTreeEntry.substring(index4 + 1, index5 = fixedTreeEntry.indexOf(44, index4 + 1));
            if (parentId.equals("-1")) {
                parentId = null;
            }
            int index6 = this.scanTestName(fixedTreeEntry, index5 + 1, displayNameBuffer);
            displayName = displayNameBuffer.toString().replace('\u0000', ' ').trim();
            if (displayName.equals(testName)) {
                displayName = null;
            }
            int index7 = this.scanTestName(fixedTreeEntry, index6 + 1, parameterTypesBuffer);
            String parameterTypesString = parameterTypesBuffer.toString().trim();
            if (parameterTypesString.isEmpty()) {
                Object parameterTypes = null;
            } else {
                String[] parameterTypes = parameterTypesString.split(",");
                Arrays.parallelSetAll(parameterTypes, i -> parameterTypes[i].trim());
            }
            this.scanTestName(fixedTreeEntry, index7 + 1, uniqueIdBuffer);
            uniqueId = uniqueIdBuffer.toString().trim();
            if (uniqueId.isEmpty()) {
                uniqueId = null;
            }
        }
        ITestSuiteElement parent = this.getTestSuite(parentId);
        if (parent == null && this.currentSuite != null) {
            parent = this.currentSuite;
        }
        if (isSuite) {
            this.currentSuite = this.fTestRunSession.newTestSuite(id, testName, Integer.valueOf(testCount), parent, displayName, uniqueId);
        } else {
            this.fTestRunSession.newTestCase(id, testName, parent, displayName, uniqueId);
        }
    }

    private ITestSuiteElement getTestSuite(String parentId) {
        ITestElement element = this.fTestRunSession.getTestElement(parentId);
        return element instanceof ITestSuiteElement ? (ITestSuiteElement)element : null;
    }

    private int scanTestName(String s, int start, StringBuilder testName) {
        boolean inQuote = false;
        int i = start;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c == '\\' && !inQuote) {
                inQuote = true;
            } else if (inQuote) {
                inQuote = false;
                testName.append(c);
            } else {
                if (c == ',') break;
                testName.append(c);
            }
            ++i;
        }
        return i;
    }

    private String fakeTestId(String treeEntry) {
        int index0 = treeEntry.indexOf(44);
        String testName = treeEntry.substring(0, index0).trim();
        return testName + "," + treeEntry;
    }

    private void extractFailure(ITestElement failedTest, ITestElement.Result status, boolean isAssumptionFailed) {
        this.fFailedTest = failedTest;
        this.fFailureKind = status;
        this.fFailedAssumption = isAssumptionFailed;
    }

    private void notifyTestReran(String testId, String className, String testName, String status) {
        ITestElement.Result statusCode = ITestElement.Result.OK;
        if (status.equals("FAILURE")) {
            statusCode = ITestElement.Result.FAILURE;
        } else if (status.equals("ERROR")) {
            statusCode = ITestElement.Result.ERROR;
        }
        String trace = "";
        if (statusCode != ITestElement.Result.OK) {
            trace = this.fFailedRerunTrace.toString();
        }
        ITestCaseElement element = this.fTestRunSession.newTestCase(testId, testName, null, testName, className);
        if (statusCode != ITestElement.Result.OK) {
            this.fTestRunSession.notifyTestFailed((ITestElement)element, statusCode, false, new ITestElement.FailureTrace(trace, JUnitRemoteTestRunnerClient.nullifyEmpty(this.fExpectedResult), JUnitRemoteTestRunnerClient.nullifyEmpty(this.fActualResult)));
        }
        this.fTestRunSession.notifyTestEnded((ITestElement)element, false);
    }

    private static String nullifyEmpty(StringBuilder buf) {
        int length = buf.length();
        if (length == 0) {
            return null;
        }
        char last = buf.charAt(length - 1);
        if (last == '\n') {
            if (length > 1 && buf.charAt(length - 2) == '\r') {
                return buf.substring(0, length - 2);
            }
            return buf.substring(0, length - 1);
        }
        if (last == '\r') {
            return buf.substring(0, length - 1);
        }
        return buf.toString();
    }

    class AppendingProcessingState
    extends ProcessingState {
        private final StringBuilder fBuffer;
        private String fEndString;

        AppendingProcessingState(StringBuilder buffer, String endString) {
            this.fBuffer = buffer;
            this.fEndString = endString;
        }

        @Override
        ProcessingState readMessage(String message) {
            if (message.startsWith(this.fEndString)) {
                this.entireStringRead();
                return JUnitRemoteTestRunnerClient.this.fDefaultState;
            }
            this.fBuffer.append(message);
            if (JUnitRemoteTestRunnerClient.this.fLastLineDelimiter != null) {
                this.fBuffer.append(JUnitRemoteTestRunnerClient.this.fLastLineDelimiter);
            }
            return this;
        }

        void entireStringRead() {
        }
    }

    class DefaultProcessingState
    extends ProcessingState {
        DefaultProcessingState() {
        }

        @Override
        ProcessingState readMessage(String message) {
            if (JUnitRemoteTestRunnerClient.this.fDebug) {
                System.out.println("JUnitRemoteTestRunnerClient.DefaultProcessingState.readMessage: " + message);
            }
            if (message.startsWith("%TRACES ")) {
                JUnitRemoteTestRunnerClient.this.fFailedTrace.setLength(0);
                return JUnitRemoteTestRunnerClient.this.fTraceState;
            }
            if (message.startsWith("%EXPECTS")) {
                JUnitRemoteTestRunnerClient.this.fExpectedResult.setLength(0);
                return JUnitRemoteTestRunnerClient.this.fExpectedState;
            }
            if (message.startsWith("%ACTUALS")) {
                JUnitRemoteTestRunnerClient.this.fActualResult.setLength(0);
                return JUnitRemoteTestRunnerClient.this.fActualState;
            }
            if (message.startsWith("%RTRACES")) {
                JUnitRemoteTestRunnerClient.this.fFailedRerunTrace.setLength(0);
                return JUnitRemoteTestRunnerClient.this.fRerunState;
            }
            String arg = message.substring(8);
            if (message.startsWith("%TESTC  ")) {
                int count = 0;
                int v = arg.indexOf(32);
                if (v == -1) {
                    JUnitRemoteTestRunnerClient.this.fVersion = "v1";
                    count = Integer.parseInt(arg);
                } else {
                    JUnitRemoteTestRunnerClient.this.fVersion = arg.substring(v + 1);
                    String sc = arg.substring(0, v);
                    count = Integer.parseInt(sc);
                }
                JUnitRemoteTestRunnerClient.this.fTestRunSession.notifyTestSessionStarted(Integer.valueOf(count));
                return this;
            }
            if (message.startsWith("%TESTS  ")) {
                String[] s = JUnitRemoteTestRunnerClient.this.extractTestId(arg);
                ITestElement test = JUnitRemoteTestRunnerClient.this.fTestRunSession.getTestElement(s[0]);
                JUnitRemoteTestRunnerClient.this.fTestRunSession.notifyTestStarted(test);
                return this;
            }
            if (message.startsWith("%TESTE  ")) {
                String[] s = JUnitRemoteTestRunnerClient.this.extractTestId(arg);
                boolean isIgnored = s[1].startsWith("@Ignore: ");
                ITestElement testElement = JUnitRemoteTestRunnerClient.this.fTestRunSession.getTestElement(s[0]);
                JUnitRemoteTestRunnerClient.this.fTestRunSession.notifyTestEnded(testElement, isIgnored);
                return this;
            }
            if (message.startsWith("%ERROR  ")) {
                String[] s = JUnitRemoteTestRunnerClient.this.extractTestId(arg);
                ITestElement testElement = JUnitRemoteTestRunnerClient.this.fTestRunSession.getTestElement(s[0]);
                boolean isAssumptionFailed = s[1].startsWith("@AssumptionFailure: ");
                JUnitRemoteTestRunnerClient.this.extractFailure(testElement, ITestElement.Result.ERROR, isAssumptionFailed);
                return this;
            }
            if (message.startsWith("%FAILED ")) {
                String[] s = JUnitRemoteTestRunnerClient.this.extractTestId(arg);
                ITestElement testElement = JUnitRemoteTestRunnerClient.this.fTestRunSession.getTestElement(s[0]);
                boolean isAssumptionFailed = s[1].startsWith("@AssumptionFailure: ");
                JUnitRemoteTestRunnerClient.this.extractFailure(testElement, ITestElement.Result.FAILURE, isAssumptionFailed);
                return this;
            }
            if (message.startsWith("%RUNTIME")) {
                JUnitRemoteTestRunnerClient.this.fTestRunSession.notifyTestSessionCompleted(Duration.ofMillis(Long.parseLong(arg)));
                return this;
            }
            if (message.startsWith("%TSTSTP ")) {
                JUnitRemoteTestRunnerClient.this.fTestRunSession.notifyTestSessionAborted(Duration.ofMillis(Long.parseLong(arg)), null);
                JUnitRemoteTestRunnerClient.this.shutDown();
                return this;
            }
            if (message.startsWith("%TSTTREE")) {
                JUnitRemoteTestRunnerClient.this.notifyTestTreeEntry(arg);
                return this;
            }
            if (message.startsWith("%TSTRERN")) {
                if (JUnitRemoteTestRunnerClient.this.hasTestId()) {
                    JUnitRemoteTestRunnerClient.this.scanReranMessage(arg);
                } else {
                    JUnitRemoteTestRunnerClient.this.scanOldReranMessage(arg);
                }
                return this;
            }
            return this;
        }
    }

    public abstract class ListenerSafeRunnable
    implements ISafeRunnable {
        public void handleException(Throwable exception) {
            JUnitTestPlugin.log(exception);
        }
    }

    abstract class ProcessingState {
        ProcessingState() {
        }

        abstract ProcessingState readMessage(String var1);
    }

    class TraceProcessingState
    extends AppendingProcessingState {
        TraceProcessingState() {
            super(JUnitRemoteTestRunnerClient.this.fFailedTrace, "%TRACEE ");
        }

        @Override
        void entireStringRead() {
            JUnitRemoteTestRunnerClient.this.fTestRunSession.notifyTestFailed(JUnitRemoteTestRunnerClient.this.fFailedTest, JUnitRemoteTestRunnerClient.this.fFailureKind, JUnitRemoteTestRunnerClient.this.fFailedAssumption, new ITestElement.FailureTrace(JUnitRemoteTestRunnerClient.this.fFailedTrace.toString(), JUnitRemoteTestRunnerClient.nullifyEmpty(JUnitRemoteTestRunnerClient.this.fExpectedResult), JUnitRemoteTestRunnerClient.nullifyEmpty(JUnitRemoteTestRunnerClient.this.fActualResult)));
            JUnitRemoteTestRunnerClient.this.fExpectedResult.setLength(0);
            JUnitRemoteTestRunnerClient.this.fActualResult.setLength(0);
        }

        @Override
        ProcessingState readMessage(String message) {
            if (message.startsWith("%TRACEE ")) {
                JUnitRemoteTestRunnerClient.this.fTestRunSession.notifyTestFailed(JUnitRemoteTestRunnerClient.this.fFailedTest, JUnitRemoteTestRunnerClient.this.fFailureKind, JUnitRemoteTestRunnerClient.this.fFailedAssumption, new ITestElement.FailureTrace(JUnitRemoteTestRunnerClient.this.fFailedTrace.toString(), JUnitRemoteTestRunnerClient.nullifyEmpty(JUnitRemoteTestRunnerClient.this.fExpectedResult), JUnitRemoteTestRunnerClient.nullifyEmpty(JUnitRemoteTestRunnerClient.this.fActualResult)));
                JUnitRemoteTestRunnerClient.this.fFailedTrace.setLength(0);
                JUnitRemoteTestRunnerClient.this.fActualResult.setLength(0);
                JUnitRemoteTestRunnerClient.this.fExpectedResult.setLength(0);
                return JUnitRemoteTestRunnerClient.this.fDefaultState;
            }
            JUnitRemoteTestRunnerClient.this.fFailedTrace.append(message);
            if (JUnitRemoteTestRunnerClient.this.fLastLineDelimiter != null) {
                JUnitRemoteTestRunnerClient.this.fFailedTrace.append(JUnitRemoteTestRunnerClient.this.fLastLineDelimiter);
            }
            return this;
        }
    }
}

