/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.unittest.junit.ui;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.corext.util.JavaConventionsUtil;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.ui.unittest.junit.JUnitTestPlugin;
import org.eclipse.jdt.ui.unittest.junit.ui.BasicElementLabels;
import org.eclipse.jdt.ui.unittest.junit.ui.JUnitMessages;
import org.eclipse.jdt.ui.unittest.junit.ui.JUnitTestViewSupport;
import org.eclipse.jdt.ui.unittest.junit.ui.OpenEditorAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.unittest.model.ITestCaseElement;
import org.eclipse.unittest.model.ITestElement;
import org.eclipse.unittest.model.ITestRunSession;

public class OpenTestAction
extends OpenEditorAction {
    private String fMethodName;
    private String[] fMethodParamTypes;
    private IMethod fMethod;
    private int fLineNumber = -1;
    private IType fType;

    public OpenTestAction(Shell shell, ITestCaseElement testCase, String[] methodParamTypes) {
        this(shell, JUnitTestViewSupport.getClassName((ITestElement)testCase), OpenTestAction.extractRealMethodName(testCase), methodParamTypes, true, testCase.getTestRunSession());
        ITestElement.FailureTrace trace = testCase.getFailureTrace();
        if (trace != null) {
            String rawClassName = JUnitTestViewSupport.extractRawClassName(testCase.getTestName());
            rawClassName = rawClassName.replaceAll("\\.", "\\\\.");
            Pattern pattern = Pattern.compile("at " + (rawClassName = rawClassName.replaceAll("\\$", "\\\\\\$")) + "." + this.fMethodName + "\\(.*:(\\d+)\\)");
            Matcher matcher = pattern.matcher(trace.getTrace());
            if (matcher.find()) {
                try {
                    this.fLineNumber = Integer.parseInt(matcher.group(1));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }

    public OpenTestAction(Shell shell, String className, ITestRunSession session) {
        this(shell, className, null, null, true, session);
    }

    public OpenTestAction(Shell shell, String className, String method, String[] methodParamTypes, boolean activate, ITestRunSession session) {
        super(shell, className, activate, session);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.unittest.junit.open_test_action_context");
        this.fMethodName = method;
        this.fMethodParamTypes = methodParamTypes;
    }

    private static String extractRealMethodName(ITestCaseElement testCase) {
        if (testCase.isIgnored() && JavaConventions.validateJavaTypeName((String)testCase.getTestName(), (String)"1.5", (String)"1.5", null).getSeverity() != 4) {
            return null;
        }
        String testMethodName = JUnitTestViewSupport.getTestMethodName((ITestElement)testCase);
        int i = 0;
        while (i < testMethodName.length()) {
            if (!Character.isJavaIdentifierPart(testMethodName.charAt(i))) {
                return testMethodName.substring(0, i);
            }
            ++i;
        }
        return testMethodName;
    }

    @Override
    protected IJavaElement findElement(IJavaProject project, String className) throws JavaModelException {
        IMethod method;
        IType type;
        block8: {
            type = this.findType(project, className);
            if (type == null) {
                return null;
            }
            if (this.fMethodName == null) {
                this.fType = type;
                return type;
            }
            method = null;
            try {
                IType[] supertypes;
                method = this.findMethod(type);
                if (method != null) break block8;
                ITypeHierarchy typeHierarchy = type.newSupertypeHierarchy(null);
                IType[] iTypeArray = supertypes = typeHierarchy.getAllSupertypes(type);
                int n = supertypes.length;
                int n2 = 0;
                while (n2 < n) {
                    IType supertype = iTypeArray[n2];
                    method = this.findMethod(supertype);
                    if (method == null) {
                        ++n2;
                        continue;
                    }
                    break;
                }
            }
            catch (OperationCanceledException typeHierarchy) {
                // empty catch block
            }
        }
        if (method == null) {
            if (this.fLineNumber < 0) {
                String title = JUnitMessages.OpenTestAction_dialog_title;
                String message = MessageFormat.format(JUnitMessages.OpenTestAction_error_methodNoFound, BasicElementLabels.getJavaElementName(this.fMethodName));
                MessageDialog.openInformation((Shell)this.getShell(), (String)title, (String)message);
            }
            return type;
        }
        this.fMethod = method;
        return method;
    }

    private IMethod findMethod(IType type) {
        IMethod method;
        ArrayList<IMethod> foundMethods;
        block16: {
            IStatus status = JavaConventionsUtil.validateMethodName((String)this.fMethodName, (IJavaElement)type);
            if (!status.isOK()) {
                return null;
            }
            foundMethods = new ArrayList<IMethod>();
            try {
                PlatformUI.getWorkbench().getProgressService().busyCursorWhile(monitor -> {
                    String methodPattern = type.getFullyQualifiedName('.') + "." + this.fMethodName;
                    if (this.fMethodParamTypes != null && this.fMethodParamTypes.length > 0) {
                        String paramTypes = Arrays.stream(this.fMethodParamTypes).map(paramType -> {
                            try {
                                paramType = Signature.toString((String)paramType);
                                return paramType;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                return paramType.replace('$', '.');
                            }
                        }).collect(Collectors.joining(", ", "(", ")"));
                        methodPattern = methodPattern + paramTypes;
                    } else {
                        methodPattern = methodPattern + "()";
                    }
                    int matchRule = 24;
                    SearchPattern searchPattern = SearchPattern.createPattern((String)methodPattern, (int)1, (int)0, (int)matchRule);
                    if (searchPattern == null) {
                        return;
                    }
                    SearchRequestor requestor = new SearchRequestor(){

                        public void acceptSearchMatch(SearchMatch match) throws CoreException {
                            Object element = match.getElement();
                            if (element instanceof IMethod) {
                                foundMethods.add((IMethod)element);
                            }
                        }
                    };
                    SearchParticipant[] participants = new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()};
                    IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{type});
                    try {
                        new SearchEngine().search(searchPattern, participants, scope, requestor, monitor);
                    }
                    catch (CoreException e2) {
                        JUnitTestPlugin.log(e2);
                    }
                });
            }
            catch (InvocationTargetException e) {
                JUnitTestPlugin.log(e);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (foundMethods.size() == 1) {
                return (IMethod)foundMethods.get(0);
            }
            if (foundMethods.size() > 1) {
                method = this.openSelectionDialog(foundMethods);
                if (method == null) {
                    throw new OperationCanceledException();
                }
                return method;
            }
            try {
                IMethod[] iMethodArray = type.getMethods();
                int n = iMethodArray.length;
                int n2 = 0;
                while (n2 < n) {
                    method = iMethodArray[n2];
                    String methodName = method.getElementName();
                    if (this.fMethodName.equals(methodName)) {
                        int numOfParams = method.getNumberOfParameters();
                        int requiredNumOfParams = 0;
                        if (this.fMethodParamTypes != null) {
                            requiredNumOfParams = this.fMethodParamTypes.length;
                        }
                        if (numOfParams == requiredNumOfParams) {
                            foundMethods.add(method);
                        }
                    }
                    ++n2;
                }
                if (!foundMethods.isEmpty()) break block16;
                return null;
            }
            catch (JavaModelException javaModelException) {
                return null;
            }
        }
        if (foundMethods.size() > 1) {
            method = this.openSelectionDialog(foundMethods);
            if (method == null) {
                throw new OperationCanceledException();
            }
            return method;
        }
        return (IMethod)foundMethods.get(0);
    }

    private IMethod openSelectionDialog(List<IMethod> foundMethods) {
        IMethod[] elements = foundMethods.toArray(new IMethod[foundMethods.size()]);
        String title = JUnitMessages.OpenTestAction_dialog_title;
        String message = JUnitMessages.OpenTestAction_select_element;
        return (IMethod)SelectionConverter.selectJavaElement((IJavaElement[])elements, (Shell)this.getShell(), (String)title, (String)message);
    }

    @Override
    protected void reveal(ITextEditor textEditor) {
        if (this.fLineNumber >= 0) {
            try {
                IDocument document = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput());
                int lineOffset = document.getLineOffset(this.fLineNumber - 1);
                int lineLength = document.getLineLength(this.fLineNumber - 1);
                if (this.fMethod != null) {
                    try {
                        ISourceRange sr = this.fMethod.getSourceRange();
                        if (sr == null || sr.getOffset() == -1 || lineOffset < sr.getOffset() || sr.getOffset() + sr.getLength() < lineOffset + lineLength) {
                            throw new BadLocationException();
                        }
                    }
                    catch (JavaModelException javaModelException) {
                        // empty catch block
                    }
                }
                textEditor.selectAndReveal(lineOffset, lineLength);
                return;
            }
            catch (BadLocationException document) {
                // empty catch block
            }
        }
        if (this.fMethod != null) {
            try {
                ISourceRange range = this.fMethod.getNameRange();
                if (range != null && range.getOffset() >= 0) {
                    textEditor.selectAndReveal(range.getOffset(), range.getLength());
                }
                return;
            }
            catch (JavaModelException range) {
                // empty catch block
            }
        }
        if (this.fType != null) {
            try {
                ISourceRange range = this.fType.getNameRange();
                if (range != null && range.getOffset() >= 0) {
                    textEditor.selectAndReveal(range.getOffset(), range.getLength());
                }
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
        }
    }
}

