/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.examples.undo.views;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IOperationApprover;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.ObjectUndoContext;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.examples.undo.AddBoxOperation;
import org.eclipse.ui.examples.undo.Box;
import org.eclipse.ui.examples.undo.Boxes;
import org.eclipse.ui.examples.undo.ClearBoxesOperation;
import org.eclipse.ui.examples.undo.MoveBoxOperation;
import org.eclipse.ui.examples.undo.PromptingUserApprover;
import org.eclipse.ui.examples.undo.UndoExampleMessages;
import org.eclipse.ui.examples.undo.UndoPlugin;
import org.eclipse.ui.operations.RedoActionHandler;
import org.eclipse.ui.operations.UndoActionHandler;
import org.eclipse.ui.part.ViewPart;

public class BoxView
extends ViewPart {
    private Canvas paintCanvas;
    private GC gc;
    private final Boxes boxes = new Boxes();
    private UndoActionHandler undoAction;
    private RedoActionHandler redoAction;
    private IAction clearBoxesAction;
    private IUndoContext undoContext;
    private IOperationApprover operationApprover;
    private IPropertyChangeListener propertyChangeListener;
    private boolean dragInProgress = false;
    private boolean moveInProgress = false;
    private Box movingBox;
    int diffX;
    int diffY;
    private final Point anchorPosition = new Point(-1, -1);
    private final Point tempPosition = new Point(-1, -1);
    private Point rubberbandPosition = new Point(-1, -1);

    public BoxView() {
        this.initializeOperationHistory();
    }

    public void createPartControl(Composite parent) {
        this.paintCanvas = new Canvas(parent, 0x100B00);
        this.gc = new GC((Drawable)this.paintCanvas);
        this.gc.setForeground(this.paintCanvas.getForeground());
        this.gc.setLineStyle(1);
        this.addListeners();
        this.makeActions();
        this.hookContextMenu();
        this.createGlobalActionHandlers();
        this.contributeToActionBars();
    }

    private void addListeners() {
        this.paintCanvas.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent event) {
                if (event.button != 1) {
                    return;
                }
                if (BoxView.this.dragInProgress || BoxView.this.moveInProgress) {
                    return;
                }
                BoxView.this.tempPosition.x = event.x;
                BoxView.this.tempPosition.y = event.y;
                Box box = BoxView.this.boxes.getBox(event.x, event.y);
                if (box != null) {
                    BoxView.this.moveInProgress = true;
                    BoxView.this.movingBox = box;
                    BoxView.this.anchorPosition.x = box.x1;
                    BoxView.this.anchorPosition.y = box.y1;
                    BoxView.this.diffX = event.x - box.x1;
                    BoxView.this.diffY = event.y - box.y1;
                } else {
                    BoxView.this.dragInProgress = true;
                    BoxView.this.anchorPosition.x = event.x;
                    BoxView.this.anchorPosition.y = event.y;
                }
            }

            public void mouseUp(MouseEvent event) {
                if (event.button != 1) {
                    BoxView.this.resetDrag(true);
                    return;
                }
                if (BoxView.this.anchorPosition.x == -1) {
                    return;
                }
                if (BoxView.this.dragInProgress) {
                    Box box = new Box(BoxView.this.anchorPosition.x, BoxView.this.anchorPosition.y, BoxView.this.tempPosition.x, BoxView.this.tempPosition.y);
                    if (box.getWidth() > 0 && box.getHeight() > 0) {
                        try {
                            BoxView.this.getOperationHistory().execute((IUndoableOperation)new AddBoxOperation(UndoExampleMessages.BoxView_Add, BoxView.this.undoContext, BoxView.this.boxes, box, BoxView.this.paintCanvas), null, null);
                        }
                        catch (ExecutionException executionException) {
                            // empty catch block
                        }
                        BoxView.this.dragInProgress = false;
                    }
                } else if (BoxView.this.moveInProgress) {
                    try {
                        BoxView.this.getOperationHistory().execute((IUndoableOperation)new MoveBoxOperation(UndoExampleMessages.BoxView_Move, BoxView.this.undoContext, BoxView.this.movingBox, BoxView.this.paintCanvas, BoxView.this.anchorPosition), null, null);
                    }
                    catch (ExecutionException executionException) {
                        // empty catch block
                    }
                    BoxView.this.moveInProgress = false;
                    BoxView.this.movingBox = null;
                }
                BoxView.this.resetDrag(false);
                BoxView.this.paintCanvas.redraw();
            }

            public void mouseDoubleClick(MouseEvent event) {
            }
        });
        this.paintCanvas.addMouseMoveListener(event -> {
            if (this.dragInProgress) {
                this.clearRubberBandSelection();
                this.tempPosition.x = event.x;
                this.tempPosition.y = event.y;
                this.addRubberBandSelection();
            } else if (this.moveInProgress) {
                this.clearRubberBandSelection();
                this.anchorPosition.x = event.x - this.diffX;
                this.anchorPosition.y = event.y - this.diffY;
                this.tempPosition.x = this.anchorPosition.x + this.movingBox.getWidth();
                this.tempPosition.y = this.anchorPosition.y + this.movingBox.getHeight();
                this.addRubberBandSelection();
            }
        });
        this.paintCanvas.addPaintListener(event -> {
            event.gc.setForeground(this.paintCanvas.getForeground());
            this.boxes.draw(event.gc);
        });
        this.paintCanvas.addDisposeListener(event -> {
            this.gc.dispose();
            this.removeListeners();
        });
        this.propertyChangeListener = event -> {
            if (event.getProperty() == "prefUndoLimit") {
                int limit = UndoPlugin.getDefault().getPreferenceStore().getInt("prefUndoLimit");
                this.getOperationHistory().setLimit(this.undoContext, limit);
            }
        };
        UndoPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.propertyChangeListener);
    }

    private void removeListeners() {
        UndoPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.propertyChangeListener);
        this.getOperationHistory().removeOperationApprover(this.operationApprover);
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(this::fillContextMenu);
        Menu menu = menuMgr.createContextMenu((Control)this.paintCanvas);
        this.paintCanvas.setMenu(menu);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.undoAction);
        manager.add((IAction)this.redoAction);
        manager.add((IContributionItem)new Separator());
        manager.add(this.clearBoxesAction);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.undoAction);
        manager.add((IAction)this.redoAction);
        manager.add((IContributionItem)new Separator());
        manager.add(this.clearBoxesAction);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add(this.clearBoxesAction);
    }

    private void makeActions() {
        this.clearBoxesAction = new Action(){

            public void run() {
                try {
                    BoxView.this.getOperationHistory().execute((IUndoableOperation)new ClearBoxesOperation(UndoExampleMessages.BoxView_ClearBoxes, BoxView.this.undoContext, BoxView.this.boxes, BoxView.this.paintCanvas), null, null);
                }
                catch (ExecutionException executionException) {
                    // empty catch block
                }
            }
        };
        this.clearBoxesAction.setText(UndoExampleMessages.BoxView_ClearBoxes);
        this.clearBoxesAction.setToolTipText(UndoExampleMessages.BoxView_ClearBoxesToolTipText);
        this.clearBoxesAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE"));
    }

    private void createGlobalActionHandlers() {
        this.undoAction = new UndoActionHandler(this.getSite(), this.undoContext);
        this.redoAction = new RedoActionHandler(this.getSite(), this.undoContext);
        IActionBars actionBars = this.getViewSite().getActionBars();
        actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), (IAction)this.undoAction);
        actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), (IAction)this.redoAction);
    }

    public void setFocus() {
        this.paintCanvas.setFocus();
    }

    private void resetDrag(boolean clearRubberband) {
        if (clearRubberband) {
            this.clearRubberBandSelection();
        }
        this.dragInProgress = false;
        this.moveInProgress = false;
        this.movingBox = null;
        this.rubberbandPosition.y = -1;
        this.rubberbandPosition.x = -1;
        this.tempPosition.y = -1;
        this.tempPosition.x = -1;
        this.anchorPosition.y = -1;
        this.anchorPosition.x = -1;
    }

    private void clearRubberBandSelection() {
        this.gc.setForeground(this.paintCanvas.getBackground());
        this.gc.drawRectangle(this.anchorPosition.x, this.anchorPosition.y, this.rubberbandPosition.x - this.anchorPosition.x, this.rubberbandPosition.y - this.anchorPosition.y);
        this.paintCanvas.redraw(this.anchorPosition.x, this.anchorPosition.y, this.rubberbandPosition.x - this.anchorPosition.x, this.rubberbandPosition.y - this.anchorPosition.y, false);
        this.paintCanvas.update();
        this.rubberbandPosition = new Point(-1, -1);
        this.gc.setForeground(this.paintCanvas.getForeground());
    }

    private void addRubberBandSelection() {
        this.rubberbandPosition = this.tempPosition;
        this.gc.drawRectangle(this.anchorPosition.x, this.anchorPosition.y, this.rubberbandPosition.x - this.anchorPosition.x, this.rubberbandPosition.y - this.anchorPosition.y);
    }

    private void initializeOperationHistory() {
        this.undoContext = new ObjectUndoContext((Object)this);
        int limit = UndoPlugin.getDefault().getPreferenceStore().getInt("prefUndoLimit");
        this.getOperationHistory().setLimit(this.undoContext, limit);
        this.operationApprover = new PromptingUserApprover(this.undoContext);
        this.getOperationHistory().addOperationApprover(this.operationApprover);
    }

    private IOperationHistory getOperationHistory() {
        return PlatformUI.getWorkbench().getOperationSupport().getOperationHistory();
    }
}

