/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.examples.propertysheet;

import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.ui.examples.propertysheet.MessageUtil;
import org.eclipse.ui.views.properties.ComboBoxPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class Birthday
implements IPropertySource {
    private Integer day;
    private Integer month;
    private Integer year;
    public static final String P_ID_DAY = "Birthday.day";
    public static final String P_ID_MONTH = "Birthday.month";
    public static final String P_ID_YEAR = "Birthday.year";
    public static final String P_DAY = MessageUtil.getString("day");
    public static final String P_MONTH = MessageUtil.getString("month");
    public static final String P_YEAR = MessageUtil.getString("year");
    private static final Integer DAY_DEFAULT = 1;
    private static final Integer MONTH_DEFAULT = 1;
    private static final Integer YEAR_DEFAULT = 2000;
    private static final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("EEEE, MMMM d, yyyy").withZone(ZoneId.systemDefault());
    private static ArrayList<PropertyDescriptor> descriptors = new ArrayList();

    static {
        String[] dayValues = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31"};
        ComboBoxPropertyDescriptor days = new ComboBoxPropertyDescriptor((Object)P_ID_DAY, P_DAY, dayValues);
        days.setLabelProvider((ILabelProvider)new DayLabelProvider());
        descriptors.add((PropertyDescriptor)days);
        String[] monthValues = new String[]{MessageUtil.getString("January"), MessageUtil.getString("February"), MessageUtil.getString("March"), MessageUtil.getString("April"), MessageUtil.getString("May"), MessageUtil.getString("June"), MessageUtil.getString("July"), MessageUtil.getString("August"), MessageUtil.getString("September"), MessageUtil.getString("October"), MessageUtil.getString("November"), MessageUtil.getString("December")};
        ComboBoxPropertyDescriptor months = new ComboBoxPropertyDescriptor((Object)P_ID_MONTH, P_MONTH, monthValues);
        months.setLabelProvider((ILabelProvider)new MonthLabelProvider());
        descriptors.add((PropertyDescriptor)months);
        descriptors.add((PropertyDescriptor)new TextPropertyDescriptor((Object)P_ID_YEAR, P_YEAR));
    }

    Birthday() {
    }

    public Birthday(int day, int month, int year) {
        this.setDay(day);
        this.setMonth(month);
        this.setYear(year);
    }

    private Integer getDay() {
        if (this.day == null) {
            this.day = DAY_DEFAULT;
        }
        return this.day;
    }

    private static ArrayList<PropertyDescriptor> getDescriptors() {
        return descriptors;
    }

    public Object getEditableValue() {
        return this.toString();
    }

    private Integer getMonth() {
        if (this.month == null) {
            this.month = MONTH_DEFAULT;
        }
        return this.month;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return Birthday.getDescriptors().toArray(new IPropertyDescriptor[Birthday.getDescriptors().size()]);
    }

    public Object getPropertyValue(Object propKey) {
        if (propKey.equals(P_ID_DAY)) {
            return this.getDay() - 1;
        }
        if (propKey.equals(P_ID_MONTH)) {
            return this.getMonth() - 1;
        }
        if (propKey.equals(P_ID_YEAR)) {
            return this.getYear().toString();
        }
        return null;
    }

    private Integer getYear() {
        if (this.year == null) {
            this.year = YEAR_DEFAULT;
        }
        return this.year;
    }

    public boolean isPropertySet(Object property) {
        if (P_ID_DAY.equals(property)) {
            return this.getDay() != DAY_DEFAULT;
        }
        if (P_ID_MONTH.equals(property)) {
            return this.getMonth() != MONTH_DEFAULT;
        }
        if (P_ID_YEAR.equals(property)) {
            return this.getYear() != YEAR_DEFAULT;
        }
        return false;
    }

    public void resetPropertyValue(Object property) {
        if (P_ID_DAY.equals(property)) {
            this.setDay(DAY_DEFAULT);
            return;
        }
        if (P_ID_MONTH.equals(property)) {
            this.setMonth(MONTH_DEFAULT);
            return;
        }
        if (P_ID_YEAR.equals(property)) {
            this.setYear(YEAR_DEFAULT);
            return;
        }
    }

    private void setDay(Integer newDay) {
        this.day = newDay;
    }

    private void setMonth(Integer newMonth) {
        this.month = newMonth;
    }

    public void setPropertyValue(Object name, Object value) {
        if (P_ID_DAY.equals(name)) {
            this.setDay((Integer)value + 1);
            return;
        }
        if (P_ID_MONTH.equals(name)) {
            this.setMonth((Integer)value + 1);
            return;
        }
        if (P_ID_YEAR.equals(name)) {
            try {
                this.setYear(Integer.valueOf((String)value));
            }
            catch (NumberFormatException e) {
                this.setYear(YEAR_DEFAULT);
            }
            return;
        }
    }

    private void setYear(Integer newYear) {
        this.year = newYear;
    }

    public String toString() {
        Date bday = new GregorianCalendar(this.getYear(), this.getMonth() - 1, this.getDay()).getTime();
        return formatter.format(bday.toInstant());
    }

    private static class DayLabelProvider
    extends LabelProvider {
        private DayLabelProvider() {
        }

        public String getText(Object element) {
            String[] dayValues = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31"};
            return dayValues[(Integer)element];
        }
    }

    private static class MonthLabelProvider
    extends LabelProvider {
        private MonthLabelProvider() {
        }

        public String getText(Object element) {
            String[] monthValues = new String[]{MessageUtil.getString("January"), MessageUtil.getString("February"), MessageUtil.getString("March"), MessageUtil.getString("April"), MessageUtil.getString("May"), MessageUtil.getString("June"), MessageUtil.getString("July"), MessageUtil.getString("August"), MessageUtil.getString("September"), MessageUtil.getString("October"), MessageUtil.getString("November"), MessageUtil.getString("December")};
            return monthValues[(Integer)element];
        }
    }
}

