/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.examples.propertysheet;

import java.util.ArrayList;
import org.eclipse.ui.examples.propertysheet.MessageUtil;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class Name
implements IPropertySource {
    private String firstName = "";
    private String lastName = "";
    private String initial = "";
    public static String P_ID_FIRSTNAME = "Name.FirstName";
    public static String P_ID_LASTNAME = "Name.LastName";
    public static String P_ID_MIDDLENAME = "Name.Middle";
    public static String P_FIRSTNAME = MessageUtil.getString("FirstName");
    public static String P_LASTNAME = MessageUtil.getString("LastName");
    public static String P_MIDDLENAME = MessageUtil.getString("Middle");
    private static final String FIRSTNAME_DEFAULT = null;
    private static final String LASTNAME_DEFAULT = null;
    private static final String MIDDLENAME_DEFAULT = null;
    public static final String P_DESCRIPTORS = "properties";
    private static ArrayList<TextPropertyDescriptor> descriptors = new ArrayList();

    static {
        descriptors.add(new TextPropertyDescriptor((Object)P_ID_FIRSTNAME, P_FIRSTNAME));
        descriptors.add(new TextPropertyDescriptor((Object)P_ID_LASTNAME, P_LASTNAME));
        descriptors.add(new TextPropertyDescriptor((Object)P_ID_MIDDLENAME, P_MIDDLENAME));
    }

    public Name(String name) {
        int index2;
        int index1 = name.indexOf(32);
        if (index1 < 0) {
            index1 = name.length();
        }
        if ((index2 = name.lastIndexOf(32)) > 0) {
            this.lastName = name.substring(index2 + 1);
        }
        this.firstName = name.substring(0, index1);
        if (index1 < index2) {
            this.initial = name.substring(index1 + 1, index2);
        }
    }

    private static ArrayList<TextPropertyDescriptor> getDescriptors() {
        return descriptors;
    }

    public Object getEditableValue() {
        return this.toString();
    }

    private String getFirstName() {
        return this.firstName;
    }

    private String getInitial() {
        return this.initial;
    }

    private String getLastName() {
        return this.lastName;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return Name.getDescriptors().toArray(new IPropertyDescriptor[Name.getDescriptors().size()]);
    }

    public Object getPropertyValue(Object propKey) {
        if (P_ID_FIRSTNAME.equals(propKey)) {
            return this.getFirstName();
        }
        if (P_ID_LASTNAME.equals(propKey)) {
            return this.getLastName();
        }
        if (P_ID_MIDDLENAME.equals(propKey)) {
            return this.getInitial();
        }
        return null;
    }

    public boolean isPropertySet(Object key) {
        if (key.equals(P_ID_FIRSTNAME)) {
            return this.getFirstName() != FIRSTNAME_DEFAULT;
        }
        if (key.equals(P_ID_LASTNAME)) {
            return this.getLastName() != LASTNAME_DEFAULT;
        }
        if (key.equals(P_ID_MIDDLENAME)) {
            return this.getInitial() != MIDDLENAME_DEFAULT;
        }
        return false;
    }

    public void resetPropertyValue(Object property) {
        if (P_ID_FIRSTNAME.equals(property)) {
            this.setFirstName(FIRSTNAME_DEFAULT);
            return;
        }
        if (P_ID_LASTNAME.equals(property)) {
            this.setLastName(LASTNAME_DEFAULT);
            return;
        }
        if (P_ID_MIDDLENAME.equals(property)) {
            this.setInitial(MIDDLENAME_DEFAULT);
            return;
        }
    }

    private void setFirstName(String newFirstName) {
        this.firstName = newFirstName;
    }

    private void setInitial(String newInitial) {
        this.initial = newInitial;
    }

    private void setLastName(String newLastName) {
        this.lastName = newLastName;
    }

    public void setPropertyValue(Object propName, Object val) {
        if (P_ID_FIRSTNAME.equals(propName)) {
            this.setFirstName((String)val);
            return;
        }
        if (P_ID_LASTNAME.equals(propName)) {
            this.setLastName((String)val);
            return;
        }
        if (P_ID_MIDDLENAME.equals(propName)) {
            this.setInitial((String)val);
            return;
        }
    }

    public String toString() {
        StringBuilder outStringBuilder = new StringBuilder();
        if (this.getFirstName() != FIRSTNAME_DEFAULT) {
            outStringBuilder.append(this.getFirstName());
            outStringBuilder.append(" ");
        }
        if (this.getInitial() != MIDDLENAME_DEFAULT) {
            outStringBuilder.append(this.getInitial());
            outStringBuilder.append(" ");
        }
        if (this.getLastName() != LASTNAME_DEFAULT) {
            outStringBuilder.append(this.getLastName());
        }
        return outStringBuilder.toString();
    }
}

