/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.examples.propertysheet;

import java.util.ArrayList;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.examples.propertysheet.Address;
import org.eclipse.ui.examples.propertysheet.Birthday;
import org.eclipse.ui.examples.propertysheet.EmailAddress;
import org.eclipse.ui.examples.propertysheet.EmailAddressValidator;
import org.eclipse.ui.examples.propertysheet.GroupElement;
import org.eclipse.ui.examples.propertysheet.MessageUtil;
import org.eclipse.ui.examples.propertysheet.Name;
import org.eclipse.ui.examples.propertysheet.OrganizationElement;
import org.eclipse.ui.views.properties.ColorPropertyDescriptor;
import org.eclipse.ui.views.properties.ComboBoxPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class UserElement
extends OrganizationElement {
    private Name fullName;
    private Address address;
    private String phoneNumber;
    private EmailAddress emailAddress;
    private Boolean coop;
    private Birthday birthday;
    private Float salary;
    private RGB hairColor;
    private RGB eyeColor;
    private Name fullName_Default;
    private Address address_Default;
    private final String phoneNumber_Default = "555-1111";
    private EmailAddress emailAddress_Default;
    private Boolean coop_Default;
    private Birthday birthday_Default;
    private Float salary_Default;
    private RGB hairColor_Default;
    private RGB eyeColor_Default;
    public static final String P_ID_PHONENUMBER = "User.phonenumber";
    public static final String P_ID_ADDRESS = "User.address";
    public static final String P_ID_FULLNAME = "User.fullname";
    public static final String P_ID_EMAIL = "User.email";
    public static final String P_ID_COOP = "User.coop student";
    public static final String P_ID_BDAY = "User.birthday";
    public static final String P_ID_SALARY = "User.salary";
    public static final String P_ID_HAIRCOLOR = "User.haircolor";
    public static final String P_ID_EYECOLOR = "User.eyecolor";
    public static final String P_PHONENUMBER = MessageUtil.getString("phonenumber");
    public static final String P_ADDRESS = MessageUtil.getString("address");
    public static final String P_FULLNAME = MessageUtil.getString("fullname");
    public static final String P_EMAIL = MessageUtil.getString("email");
    public static final String P_COOP = MessageUtil.getString("coop_student");
    public static final String P_BDAY = MessageUtil.getString("birthday");
    public static final String P_SALARY = MessageUtil.getString("salary");
    public static final String P_HAIRCOLOR = MessageUtil.getString("haircolor");
    public static final String P_EYECOLOR = MessageUtil.getString("eyecolor");
    private static final String PHONE_NUMBER_CONTEXT = "org.eclipse.ui.examples.propertysheet.phone_number_context";
    private static final String ADDRESS_CONTEXT = "org.eclipse.ui.examples.propertysheet.address_context";
    private static final String FULL_NAME_CONTEXT = "org.eclipse.ui.examples.propertysheet.full_name_context";
    private static final String EMAIL_CONTEXT = "org.eclipse.ui.examples.propertysheet.email_context";
    private static final String COOP_CONTEXT = "org.eclipse.ui.examples.propertysheet.coop_context";
    private static final String BIRTHDAY_CONTEXT = "org.eclipse.ui.examples.propertysheet.birthday_context";
    private static final String SALARY_CONTEXT = "org.eclipse.ui.examples.propertysheet.salary_context";
    private static final String HAIR_COLOR__CONTEXT = "org.eclipse.ui.examples.propertysheet.hair_color_context";
    private static final String EYE_COLOR_CONTEXT = "org.eclipse.ui.examples.propertysheet.eye_color_context";
    public static final String P_CONTACTINFO = MessageUtil.getString("contact");
    public static final String P_PERSONELINFO = MessageUtil.getString("personel");
    public static final String P_PERSONALINFO = MessageUtil.getString("personal");
    public static final Integer P_VALUE_TRUE = 0;
    public static final Integer P_VALUE_FALSE = 1;
    public static final String P_VALUE_TRUE_LABEL = MessageUtil.getString("true");
    public static final String P_VALUE_FALSE_LABEL = MessageUtil.getString("false");
    private static ArrayList<PropertyDescriptor> descriptors = new ArrayList();

    static {
        TextPropertyDescriptor propertyDescriptor = new TextPropertyDescriptor((Object)P_ID_PHONENUMBER, P_PHONENUMBER);
        propertyDescriptor.setCategory(P_CONTACTINFO);
        propertyDescriptor.setHelpContextIds((Object)PHONE_NUMBER_CONTEXT);
        descriptors.add((PropertyDescriptor)propertyDescriptor);
        propertyDescriptor = new PropertyDescriptor((Object)P_ID_ADDRESS, P_ADDRESS);
        propertyDescriptor.setCategory(P_CONTACTINFO);
        propertyDescriptor.setHelpContextIds((Object)ADDRESS_CONTEXT);
        descriptors.add((PropertyDescriptor)propertyDescriptor);
        propertyDescriptor = new TextPropertyDescriptor((Object)P_ID_EMAIL, P_EMAIL);
        propertyDescriptor.setCategory(P_CONTACTINFO);
        propertyDescriptor.setHelpContextIds((Object)EMAIL_CONTEXT);
        propertyDescriptor.setValidator((ICellEditorValidator)new EmailAddressValidator());
        descriptors.add((PropertyDescriptor)propertyDescriptor);
        propertyDescriptor = new TextPropertyDescriptor((Object)P_ID_FULLNAME, P_FULLNAME);
        propertyDescriptor.setCategory(P_PERSONELINFO);
        propertyDescriptor.setHelpContextIds((Object)FULL_NAME_CONTEXT);
        descriptors.add((PropertyDescriptor)propertyDescriptor);
        propertyDescriptor = new PropertyDescriptor((Object)P_ID_BDAY, P_BDAY);
        propertyDescriptor.setCategory(P_PERSONELINFO);
        propertyDescriptor.setHelpContextIds((Object)BIRTHDAY_CONTEXT);
        descriptors.add((PropertyDescriptor)propertyDescriptor);
        propertyDescriptor = new ComboBoxPropertyDescriptor((Object)P_ID_COOP, P_COOP, new String[]{P_VALUE_TRUE_LABEL, P_VALUE_FALSE_LABEL});
        propertyDescriptor.setCategory(P_PERSONELINFO);
        propertyDescriptor.setHelpContextIds((Object)COOP_CONTEXT);
        propertyDescriptor.setLabelProvider((ILabelProvider)new BooleanLabelProvider());
        descriptors.add((PropertyDescriptor)propertyDescriptor);
        propertyDescriptor = new TextPropertyDescriptor((Object)P_ID_SALARY, P_SALARY);
        propertyDescriptor.setHelpContextIds((Object)new Object[]{SALARY_CONTEXT});
        propertyDescriptor.setFilterFlags(new String[]{"org.eclipse.ui.views.properties.expert"});
        propertyDescriptor.setValidator(value -> {
            Float trySalary;
            if (value == null) {
                return MessageUtil.getString("salary_is_invalid");
            }
            try {
                trySalary = Float.valueOf(Float.parseFloat((String)value));
            }
            catch (NumberFormatException e) {
                return MessageUtil.getString("salary_is_invalid");
            }
            if ((double)trySalary.floatValue() < 0.0) {
                return MessageUtil.getString("salary_must_be_greator_than_zero");
            }
            return null;
        });
        propertyDescriptor.setCategory(P_PERSONELINFO);
        descriptors.add((PropertyDescriptor)propertyDescriptor);
        propertyDescriptor = new ColorPropertyDescriptor((Object)P_ID_HAIRCOLOR, P_HAIRCOLOR);
        propertyDescriptor.setCategory(P_PERSONALINFO);
        propertyDescriptor.setHelpContextIds((Object)HAIR_COLOR__CONTEXT);
        descriptors.add((PropertyDescriptor)propertyDescriptor);
        propertyDescriptor = new ColorPropertyDescriptor((Object)P_ID_EYECOLOR, P_EYECOLOR);
        propertyDescriptor.setCategory(P_PERSONALINFO);
        propertyDescriptor.setHelpContextIds((Object)EYE_COLOR_CONTEXT);
        descriptors.add((PropertyDescriptor)propertyDescriptor);
        ArrayList<PropertyDescriptor> parentDescriptors = OrganizationElement.getDescriptors();
        descriptors.addAll(parentDescriptors);
    }

    UserElement(String name, GroupElement parent) {
        super(name, parent);
    }

    private Address getAddress() {
        if (this.address == null) {
            this.address = new Address();
        }
        return this.address;
    }

    private Birthday getBirthday() {
        if (this.birthday == null) {
            this.birthday = new Birthday();
        }
        return this.birthday;
    }

    public Object[] getChildren(Object o) {
        return new Object[0];
    }

    private Boolean getCoop() {
        if (this.coop == null) {
            this.coop = Boolean.FALSE;
        }
        return this.coop;
    }

    static ArrayList<PropertyDescriptor> getDescriptors() {
        return descriptors;
    }

    @Override
    public Object getEditableValue() {
        return this.toString();
    }

    EmailAddress getEmailAddress() {
        if (this.emailAddress == null) {
            this.emailAddress = new EmailAddress();
        }
        return this.emailAddress;
    }

    private RGB getEyeColor() {
        if (this.eyeColor == null) {
            this.eyeColor = new RGB(60, 60, 60);
        }
        return this.eyeColor;
    }

    private Name getFullName() {
        if (this.fullName == null) {
            this.fullName = new Name(this.getName());
        }
        return this.fullName;
    }

    private RGB getHairColor() {
        if (this.hairColor == null) {
            this.hairColor = new RGB(255, 255, 255);
        }
        return this.hairColor;
    }

    private String getPhoneNumber() {
        return this.phoneNumber;
    }

    @Override
    public IPropertyDescriptor[] getPropertyDescriptors() {
        return UserElement.getDescriptors().toArray(new IPropertyDescriptor[UserElement.getDescriptors().size()]);
    }

    @Override
    public Object getPropertyValue(Object propKey) {
        if (propKey.equals(P_ID_ADDRESS)) {
            return this.getAddress();
        }
        if (propKey.equals(P_ID_FULLNAME)) {
            return this.getFullName();
        }
        if (propKey.equals(P_ID_PHONENUMBER)) {
            return this.getPhoneNumber();
        }
        if (propKey.equals(P_ID_EMAIL)) {
            return this.getEmailAddress();
        }
        if (propKey.equals(P_ID_COOP)) {
            return this.getCoop() != false ? P_VALUE_TRUE : P_VALUE_FALSE;
        }
        if (propKey.equals(P_ID_BDAY)) {
            return this.getBirthday();
        }
        if (propKey.equals(P_ID_SALARY)) {
            return this.getSalary().toString();
        }
        if (propKey.equals(P_ID_HAIRCOLOR)) {
            return this.getHairColor();
        }
        if (propKey.equals(P_ID_EYECOLOR)) {
            return this.getEyeColor();
        }
        return super.getPropertyValue(propKey);
    }

    private Float getSalary() {
        if (this.salary == null) {
            this.salary = Float.valueOf(0.0f);
        }
        return this.salary;
    }

    @Override
    public boolean isPropertySet(Object property) {
        if (property.equals(P_ID_ADDRESS)) {
            return this.getAddress() != this.address_Default;
        }
        if (property.equals(P_ID_FULLNAME)) {
            return this.getFullName() != this.fullName_Default;
        }
        if (property.equals(P_ID_PHONENUMBER)) {
            return this.getPhoneNumber() != "555-1111";
        }
        if (property.equals(P_ID_EMAIL)) {
            return this.getEmailAddress() != this.emailAddress_Default;
        }
        if (property.equals(P_ID_COOP)) {
            return this.getCoop() != this.coop_Default;
        }
        if (property.equals(P_ID_BDAY)) {
            return this.getBirthday() != this.birthday_Default;
        }
        if (property.equals(P_ID_SALARY)) {
            return this.getSalary() != this.salary_Default;
        }
        if (property.equals(P_ID_HAIRCOLOR)) {
            return this.getHairColor() != this.hairColor_Default;
        }
        if (property.equals(P_ID_EYECOLOR)) {
            return this.getEyeColor() != this.eyeColor_Default;
        }
        return false;
    }

    @Override
    public boolean isUser() {
        return true;
    }

    @Override
    public void resetPropertyValue(Object property) {
        if (property.equals(P_ID_ADDRESS)) {
            this.setAddress(this.address_Default);
            return;
        }
        if (property.equals(P_ID_FULLNAME)) {
            this.setFullName(this.fullName_Default);
            return;
        }
        if (property.equals(P_ID_PHONENUMBER)) {
            this.setPhoneNumber("555-1111");
            return;
        }
        if (property.equals(P_ID_EMAIL)) {
            this.setEmailAddress(this.emailAddress_Default);
            return;
        }
        if (property.equals(P_ID_COOP)) {
            this.setCoop(this.coop_Default);
        }
        if (property.equals(P_ID_BDAY)) {
            this.setBirthday(this.birthday_Default);
            return;
        }
        if (property.equals(P_ID_SALARY)) {
            this.setSalary(this.salary_Default);
            return;
        }
        if (property.equals(P_ID_HAIRCOLOR)) {
            this.setHairColor(this.hairColor_Default);
            return;
        }
        if (property.equals(P_ID_EYECOLOR)) {
            this.setEyeColor(this.eyeColor_Default);
            return;
        }
        super.resetPropertyValue(property);
    }

    public void setAddress(Address newAddress) {
        this.address = newAddress;
    }

    public void setBirthday(Birthday newBirthday) {
        this.birthday = new Birthday();
    }

    public void setCoop(Boolean newCoop) {
        this.coop = newCoop;
    }

    public void setEmailAddress(EmailAddress newEmailAddress) {
        this.emailAddress = newEmailAddress;
    }

    public void setEyeColor(RGB newEyeColor) {
        this.eyeColor = newEyeColor;
    }

    public void setFullName(Name newFullName) {
        this.fullName = newFullName;
    }

    public void setHairColor(RGB newHairColor) {
        this.hairColor = newHairColor;
    }

    public void setPhoneNumber(String newPhoneNumber) {
        this.phoneNumber = newPhoneNumber;
    }

    @Override
    public void setPropertyValue(Object propKey, Object val) {
        if (propKey.equals(P_ID_ADDRESS)) {
            return;
        }
        if (propKey.equals(P_ID_FULLNAME)) {
            this.setFullName(new Name((String)val));
            return;
        }
        if (propKey.equals(P_ID_PHONENUMBER)) {
            this.setPhoneNumber((String)val);
            return;
        }
        if (propKey.equals(P_ID_EMAIL)) {
            this.setEmailAddress(new EmailAddress((String)val));
            return;
        }
        if (propKey.equals(P_ID_COOP)) {
            this.setCoop(((Integer)val).equals(P_VALUE_TRUE) ? Boolean.TRUE : Boolean.FALSE);
        }
        if (propKey.equals(P_ID_BDAY)) {
            return;
        }
        if (propKey.equals(P_ID_SALARY)) {
            try {
                this.setSalary(Float.valueOf(Float.parseFloat((String)val)));
            }
            catch (NumberFormatException e) {
                this.setSalary(this.salary_Default);
            }
            return;
        }
        if (propKey.equals(P_ID_HAIRCOLOR)) {
            this.setHairColor((RGB)val);
            return;
        }
        if (propKey.equals(P_ID_EYECOLOR)) {
            this.setEyeColor((RGB)val);
            return;
        }
        super.setPropertyValue(propKey, val);
    }

    void setSalary(Float newSalary) {
        this.salary = newSalary;
    }

    public RGB getForeground(Object element) {
        return null;
    }

    public RGB getBackground(Object element) {
        return null;
    }

    private static class BooleanLabelProvider
    extends LabelProvider {
        private BooleanLabelProvider() {
        }

        public String getText(Object element) {
            String[] values = new String[]{P_VALUE_TRUE_LABEL, P_VALUE_FALSE_LABEL};
            return values[(Integer)element];
        }
    }
}

