/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.examples.databinding.contentprovider.test;

import java.util.Collections;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.DisplayRealm;
import org.eclipse.jface.databinding.viewers.ListeningLabelProvider;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.examples.databinding.contentprovider.test.RenamableItem;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class LabelProviderTest2 {
    private final Shell shell;
    private final ListViewer list;
    private final WritableList<RenamableItem> listOfRenamables;
    private final Button addButton;
    private final Button removeButton;
    private final Button renameButton;
    private final SelectionListener buttonSelectionListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            Button pressed = (Button)e.widget;
            if (pressed == LabelProviderTest2.this.addButton) {
                LabelProviderTest2.this.listOfRenamables.add((Object)new RenamableItem());
            } else if (pressed == LabelProviderTest2.this.removeButton) {
                LabelProviderTest2.this.listOfRenamables.remove((Object)LabelProviderTest2.this.getCurrentSelection());
            } else if (pressed == LabelProviderTest2.this.renameButton) {
                LabelProviderTest2.this.rename(LabelProviderTest2.this.getCurrentSelection());
            }
            super.widgetSelected(e);
        }
    };
    private final IObservableValue<RenamableItem> selectedRenamable;

    public LabelProviderTest2() {
        this.shell = new Shell(Display.getCurrent());
        this.listOfRenamables = new WritableList();
        this.list = new ListViewer((Composite)this.shell);
        ObservableListContentProvider contentProvider = new ObservableListContentProvider();
        this.list.setContentProvider((IContentProvider)contentProvider);
        this.list.setLabelProvider((IBaseLabelProvider)new ListeningLabelProvider<RenamableItem>(contentProvider.getKnownElements()){
            RenamableItem.Listener listener;
            {
                this.listener = item -> this.fireChangeEvent(Collections.singleton(item));
            }

            public void updateLabel(ViewerLabel label, Object element) {
                if (element instanceof RenamableItem) {
                    RenamableItem item = (RenamableItem)element;
                    label.setText(item.getName());
                }
            }

            protected void addListenerTo(RenamableItem next) {
                next.addListener(this.listener);
            }

            protected void removeListenerFrom(RenamableItem next) {
                next.removeListener(this.listener);
            }
        });
        this.list.setInput(this.listOfRenamables);
        this.selectedRenamable = ViewerProperties.singleSelection(RenamableItem.class).observe((Viewer)this.list);
        Composite buttonBar = new Composite((Composite)this.shell, 0);
        this.addButton = new Button(buttonBar, 8);
        this.addButton.setText("Add");
        this.addButton.addSelectionListener(this.buttonSelectionListener);
        this.removeButton = new Button(buttonBar, 8);
        this.removeButton.addSelectionListener(this.buttonSelectionListener);
        this.removeButton.setText("Remove");
        this.renameButton = new Button(buttonBar, 8);
        this.renameButton.addSelectionListener(this.buttonSelectionListener);
        this.renameButton.setText("Rename");
        this.selectedRenamable.addValueChangeListener(event -> {
            boolean shouldEnable = this.selectedRenamable.getValue() != null;
            this.removeButton.setEnabled(shouldEnable);
            this.renameButton.setEnabled(shouldEnable);
        });
        this.removeButton.setEnabled(false);
        this.renameButton.setEnabled(false);
        GridLayoutFactory.fillDefaults().generateLayout(buttonBar);
        GridLayoutFactory.fillDefaults().numColumns(2).margins(LayoutConstants.getMargins()).generateLayout((Composite)this.shell);
    }

    protected void rename(RenamableItem currentSelection) {
        InputDialog inputDialog = new InputDialog(this.shell, "Edit name", "Enter the new item name", currentSelection.getName(), null);
        if (inputDialog.open() == 0) {
            currentSelection.setName(inputDialog.getValue());
        }
    }

    protected RenamableItem getCurrentSelection() {
        return (RenamableItem)this.selectedRenamable.getValue();
    }

    public static void main(String[] args) {
        Display display = Display.getDefault();
        Realm.runWithDefault((Realm)DisplayRealm.getRealm((Display)display), () -> {
            LabelProviderTest2 test = new LabelProviderTest2();
            Shell s = test.getShell();
            s.pack();
            s.setVisible(true);
            while (!s.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        });
        display.dispose();
    }

    private Shell getShell() {
        return this.shell;
    }
}

