/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.examples.databinding.contentprovider.test;

import java.util.Arrays;
import java.util.LinkedHashSet;
import org.eclipse.core.databinding.observable.Observables;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.masterdetail.IObservableFactory;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.UnionSet;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.jface.databinding.swt.DisplayRealm;
import org.eclipse.jface.databinding.viewers.ObservableSetTreeContentProvider;
import org.eclipse.jface.examples.databinding.contentprovider.test.AsynchronousTestSet;
import org.eclipse.jface.examples.databinding.contentprovider.test.SimpleNode;
import org.eclipse.jface.internal.databinding.provisional.viewers.ViewerLabelProvider;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class TreeContentProviderTest {
    private final Shell shell;
    private TreeViewer tree;
    private final AsynchronousTestSet set1 = new AsynchronousTestSet();
    private final AsynchronousTestSet set2 = new AsynchronousTestSet();
    private final AsynchronousTestSet set3 = new AsynchronousTestSet();
    private final UnionSet<Object> union = new UnionSet(new LinkedHashSet<AsynchronousTestSet>(Arrays.asList(this.set1, this.set2, this.set3)));
    private Button randomize;

    public TreeContentProviderTest() {
        this.shell = new Shell(Display.getCurrent());
        this.createTree();
        Composite buttonBar = new Composite((Composite)this.shell, 0);
        buttonBar.setLayout((Layout)new FillLayout(256));
        this.randomize = new Button(buttonBar, 8);
        this.randomize.setText("Randomize");
        this.randomize.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AsynchronousTestSet.recomputeAll();
                super.widgetSelected(e);
            }
        });
        GridLayoutFactory.fillDefaults().generateLayout(buttonBar);
        GridLayoutFactory.fillDefaults().margins(LayoutConstants.getMargins()).generateLayout((Composite)this.shell);
        this.shell.addDisposeListener(e -> this.dispose());
    }

    protected void dispose() {
        this.set1.dispose();
        this.set2.dispose();
        this.set3.dispose();
        this.union.dispose();
    }

    private void createTree() {
        IObservableFactory childrenFactory = element -> {
            if (element == this.tree.getInput()) {
                WritableSet topElements = new WritableSet();
                topElements.add((Object)new SimpleNode("Random Set 1", (IObservableSet<Object>)this.set1));
                topElements.add((Object)new SimpleNode("Random Set 2", (IObservableSet<Object>)this.set2));
                topElements.add((Object)new SimpleNode("Random Set 3", (IObservableSet<Object>)this.set3));
                topElements.add((Object)new SimpleNode("Union of the other sets", (IObservableSet<Object>)this.union));
                return topElements;
            }
            return Observables.proxyObservableSet(((SimpleNode)element).getChildren());
        };
        ViewerLabelProvider labelProvider = new ViewerLabelProvider(){

            public void updateLabel(ViewerLabel label, Object element) {
                if (element instanceof SimpleNode) {
                    SimpleNode node = (SimpleNode)element;
                    label.setText(node.getNodeName());
                }
                if (element instanceof Integer) {
                    Integer node = (Integer)element;
                    label.setText("Integer " + String.valueOf(node));
                }
            }
        };
        this.tree = new TreeViewer((Composite)this.shell, 2816);
        ObservableSetTreeContentProvider contentProvider = new ObservableSetTreeContentProvider(childrenFactory, null);
        this.tree.setContentProvider((IContentProvider)contentProvider);
        this.tree.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.tree.setInput(new Object());
    }

    public static void main(String[] args) {
        Display display = Display.getDefault();
        Realm.runWithDefault((Realm)DisplayRealm.getRealm((Display)display), () -> {
            TreeContentProviderTest test = new TreeContentProviderTest();
            Shell s = test.getShell();
            s.pack();
            s.setVisible(true);
            while (!s.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        });
        display.dispose();
    }

    private Shell getShell() {
        return this.shell;
    }
}

