/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.examples.databinding.ducks;

import java.lang.reflect.Method;

public class ReflectedMethod {
    private final Object subject;
    private Method method;

    public ReflectedMethod(Object subject, String methodName, Class<?> ... paramTypes) {
        this.subject = subject;
        this.method = null;
        try {
            this.method = subject.getClass().getMethod(methodName, paramTypes);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public boolean exists() {
        return this.method != null;
    }

    public Object invoke(Object ... params) {
        if (this.method == null) {
            return null;
        }
        try {
            if (!this.method.isAccessible()) {
                this.method.setAccessible(true);
            }
            return this.method.invoke(this.subject, params);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Class<?> getType() {
        return this.method.getReturnType();
    }
}

