/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.examples.databinding.mask;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.eclipse.jface.examples.databinding.mask.internal.EditMaskParser;
import org.eclipse.jface.examples.databinding.mask.internal.SWTUtil;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;

public class EditMask {
    public static final String FIELD_TEXT = "text";
    public static final String FIELD_RAW_TEXT = "rawText";
    public static final String FIELD_COMPLETE = "complete";
    protected Text text;
    protected EditMaskParser editMaskParser;
    private boolean fireChangeOnKeystroke = true;
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    protected String oldValidRawText = "";
    protected String oldValidText = "";
    protected boolean updating = false;
    protected int oldSelection = 0;
    protected int selection = 0;
    protected String oldRawText = "";
    protected boolean replacedSelectedText = false;
    private final VerifyListener verifyListener = e -> {
        if (this.editMaskParser.isComplete() && e.start == e.end && e.text.length() > 0) {
            e.doit = false;
            return;
        }
        this.oldSelection = this.selection;
        Point selectionRange = this.text.getSelection();
        this.selection = selectionRange.x;
        if (!this.updating) {
            this.replacedSelectedText = false;
            if (selectionRange.y - selectionRange.x > 0 && e.text.length() > 0) {
                this.replacedSelectedText = true;
            }
            SWTUtil.greedyExec(Display.getCurrent(), this.updateTextField);
        }
    };
    private final Runnable updateTextField = new Runnable(){

        @Override
        public void run() {
            EditMask.this.updating = true;
            try {
                if (!EditMask.this.text.isDisposed()) {
                    Boolean oldIsComplete = EditMask.this.editMaskParser.isComplete();
                    EditMask.this.editMaskParser.setInput(EditMask.this.text.getText());
                    EditMask.this.text.setText(EditMask.this.editMaskParser.getFormattedResult());
                    String newRawText = EditMask.this.editMaskParser.getRawResult();
                    this.updateSelectionPosition(newRawText);
                    this.firePropertyChangeEvents(oldIsComplete, newRawText);
                }
            }
            finally {
                EditMask.this.updating = false;
            }
        }

        private void updateSelectionPosition(String newRawText) {
            if (this.isInsertingNewCharacter(newRawText) || EditMask.this.replacedSelectedText) {
                int selectionDelta = EditMask.this.editMaskParser.getNextInputPosition(EditMask.this.oldSelection) - EditMask.this.oldSelection;
                if (selectionDelta == 0) {
                    selectionDelta = EditMask.this.editMaskParser.getNextInputPosition(EditMask.this.selection) - EditMask.this.selection;
                }
                EditMask.this.selection += selectionDelta;
            }
            if (!newRawText.equals(EditMask.this.oldRawText)) {
                int firstIncompletePosition = EditMask.this.editMaskParser.getFirstIncompleteInputPosition();
                if (firstIncompletePosition > 0 && EditMask.this.selection > firstIncompletePosition) {
                    EditMask.this.selection = firstIncompletePosition;
                }
                EditMask.this.text.setSelection(new Point(EditMask.this.selection, EditMask.this.selection));
            } else if (EditMask.this.selection > EditMask.this.oldSelection) {
                EditMask.this.text.setSelection(new Point(EditMask.this.selection - 1, EditMask.this.selection - 1));
            } else {
                EditMask.this.text.setSelection(new Point(EditMask.this.selection, EditMask.this.selection));
            }
            EditMask.this.oldRawText = newRawText;
        }

        private boolean isInsertingNewCharacter(String newRawText) {
            return newRawText.length() > EditMask.this.oldRawText.length();
        }

        private void firePropertyChangeEvents(Boolean oldIsComplete, String newRawText) {
            Boolean newIsComplete = EditMask.this.editMaskParser.isComplete();
            if (!oldIsComplete.equals(newIsComplete)) {
                EditMask.this.firePropertyChange(EditMask.FIELD_COMPLETE, oldIsComplete, newIsComplete);
            }
            if (!newRawText.equals(EditMask.this.oldValidRawText) && (newIsComplete.booleanValue() || "".equals(newRawText) || EditMask.this.fireChangeOnKeystroke)) {
                EditMask.this.firePropertyChange(EditMask.FIELD_RAW_TEXT, EditMask.this.oldValidRawText, newRawText);
                EditMask.this.firePropertyChange(EditMask.FIELD_TEXT, EditMask.this.oldValidText, EditMask.this.text.getText());
                EditMask.this.oldValidText = EditMask.this.text.getText();
                EditMask.this.oldValidRawText = newRawText;
            }
        }
    };
    private final FocusListener focusListener = new FocusAdapter(){

        public void focusGained(FocusEvent e) {
            EditMask.this.selection = EditMask.this.editMaskParser.getFirstIncompleteInputPosition();
            EditMask.this.text.setSelection(EditMask.this.selection, EditMask.this.selection);
        }
    };
    private final DisposeListener disposeListener = e -> {
        this.text.removeVerifyListener(this.verifyListener);
        this.text.removeFocusListener(this.focusListener);
        this.text.removeDisposeListener(this.disposeListener);
    };

    public EditMask(Text text) {
        this.text = text;
    }

    public Text getControl() {
        return this.text;
    }

    public void setMask(String editMask) {
        this.editMaskParser = new EditMaskParser(editMask);
        this.text.addVerifyListener(this.verifyListener);
        this.text.addFocusListener(this.focusListener);
        this.text.addDisposeListener(this.disposeListener);
        this.updateTextField.run();
        this.oldValidText = this.text.getText();
        this.oldValidRawText = this.editMaskParser.getRawResult();
    }

    public void setText(String string) {
        String oldValue = this.text.getText();
        if (this.editMaskParser != null) {
            this.editMaskParser.setInput(string);
            String formattedResult = this.editMaskParser.getFormattedResult();
            this.text.setText(formattedResult);
            this.firePropertyChange(FIELD_TEXT, oldValue, formattedResult);
        } else {
            this.text.setText(string);
            this.firePropertyChange(FIELD_TEXT, oldValue, string);
        }
        this.oldValidText = this.text.getText();
        this.oldValidRawText = this.editMaskParser.getRawResult();
    }

    public String getText() {
        if (this.editMaskParser != null) {
            return this.editMaskParser.getFormattedResult();
        }
        return this.text.getText();
    }

    public void setRawText(String string) {
        if (string == null) {
            string = "";
        }
        if (this.editMaskParser != null) {
            String oldValue = this.editMaskParser.getRawResult();
            this.editMaskParser.setInput(string);
            this.text.setText(this.editMaskParser.getFormattedResult());
            this.firePropertyChange(FIELD_RAW_TEXT, oldValue, string);
        } else {
            String oldValue = this.text.getText();
            this.text.setText(string);
            this.firePropertyChange(FIELD_RAW_TEXT, oldValue, string);
        }
        this.oldValidText = this.text.getText();
        this.oldValidRawText = this.editMaskParser.getRawResult();
    }

    public String getRawText() {
        if (this.editMaskParser != null) {
            return this.editMaskParser.getRawResult();
        }
        return this.text.getText();
    }

    public boolean isComplete() {
        if (this.editMaskParser == null) {
            return true;
        }
        return this.editMaskParser.isComplete();
    }

    public char getPlaceholder() {
        if (this.editMaskParser == null) {
            throw new IllegalArgumentException("Have to set an edit mask first");
        }
        return this.editMaskParser.getPlaceholder();
    }

    public void setPlaceholder(char placeholder) {
        if (this.editMaskParser == null) {
            throw new IllegalArgumentException("Have to set an edit mask first");
        }
        this.editMaskParser.setPlaceholder(placeholder);
        this.updateTextField.run();
        this.oldValidText = this.text.getText();
    }

    public boolean isFireChangeOnKeystroke() {
        return this.fireChangeOnKeystroke;
    }

    public void setFireChangeOnKeystroke(boolean fireChangeOnKeystroke) {
        this.fireChangeOnKeystroke = fireChangeOnKeystroke;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(propertyName, listener);
    }

    private boolean isEitherValueNotNull(Object oldValue, Object newValue) {
        return oldValue != null || newValue != null;
    }

    private void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this.isEitherValueNotNull(oldValue, newValue)) {
            this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
        }
    }
}

