/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.examples.databinding.model;

import java.util.StringTokenizer;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;

public class AggregateObservableValue
extends AbstractObservableValue<Object> {
    private final IObservableValue<Object>[] observableValues;
    private final String delimiter;
    private boolean updating = false;
    private String currentValue;
    private final IValueChangeListener<Object> listener = event -> {
        if (!this.updating) {
            this.fireValueChange(Diffs.createValueDiff((Object)this.currentValue, (Object)this.doGetValue()));
        }
    };

    public AggregateObservableValue(IObservableValue<Object>[] observableValues, String delimiter) {
        this.observableValues = observableValues;
        this.delimiter = delimiter;
        IObservableValue<Object>[] iObservableValueArray = observableValues;
        int n = observableValues.length;
        int n2 = 0;
        while (n2 < n) {
            IObservableValue<Object> observableValue = iObservableValueArray[n2];
            observableValue.addValueChangeListener(this.listener);
            ++n2;
        }
        this.doGetValue();
    }

    public void doSetValue(Object value) {
        Object oldValue = this.doGetValue();
        StringTokenizer tokenizer = new StringTokenizer((String)value, this.delimiter);
        try {
            this.updating = true;
            IObservableValue<Object>[] iObservableValueArray = this.observableValues;
            int n = this.observableValues.length;
            int n2 = 0;
            while (n2 < n) {
                IObservableValue<Object> observableValue = iObservableValueArray[n2];
                if (tokenizer.hasMoreElements()) {
                    observableValue.setValue(tokenizer.nextElement());
                } else {
                    observableValue.setValue(null);
                }
                ++n2;
            }
        }
        finally {
            this.updating = false;
        }
        this.doGetValue();
        this.fireValueChange(Diffs.createValueDiff((Object)oldValue, (Object)value));
    }

    public Object doGetValue() {
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < this.observableValues.length) {
            if (i > 0 & i < this.observableValues.length) {
                result.append(this.delimiter);
            }
            result.append(this.observableValues[i].getValue());
            ++i;
        }
        this.currentValue = result.toString();
        return this.currentValue;
    }

    public Object getValueType() {
        return String.class;
    }

    public synchronized void dispose() {
        IObservableValue<Object>[] iObservableValueArray = this.observableValues;
        int n = this.observableValues.length;
        int n2 = 0;
        while (n2 < n) {
            IObservableValue<Object> observableValue = iObservableValueArray[n2];
            observableValue.removeValueChangeListener(this.listener);
            ++n2;
        }
        super.dispose();
    }
}

