/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.examples.databinding.model;

import org.eclipse.jface.examples.databinding.ModelObject;

public class PriceModelObject
extends ModelObject {
    private double price;

    public double getDouble() {
        return this.price;
    }

    public void setPrice(double aPrice) {
        int oldDollars = this.getDollars();
        int oldCents = this.getCents();
        double oldValue = this.price;
        this.price = aPrice;
        this.firePropertyChange("dollars", oldDollars, this.getDollars());
        this.firePropertyChange("cents", oldCents, this.getCents());
        this.firePropertyChange("price", oldValue, this.price);
    }

    public double getPrice() {
        return this.price;
    }

    public int getCents() {
        return (int)(100.0 * this.price - 100.0 * Math.floor(this.price));
    }

    public void setCents(int cents) {
        double oldPrice = this.getPrice();
        int oldCents = this.getCents();
        this.price = (double)this.getDollars() + (double)cents * 0.01;
        this.firePropertyChange("cents", oldCents, this.getCents());
        this.firePropertyChange("price", oldPrice, this.price);
    }

    public int getDollars() {
        return Double.valueOf(this.price).intValue();
    }

    public void setDollars(int dollars) {
        double oldPrice = this.getPrice();
        int oldDollars = this.getDollars();
        this.price = (double)dollars + (double)this.getCents() * 0.01;
        this.firePropertyChange("dollars", oldDollars, this.getDollars());
        this.firePropertyChange("price", oldPrice, this.price);
    }
}

