/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.examples.databinding.snippets;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.typed.PojoProperties;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.DisplayRealm;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class Snippet000HelloWorld {
    public static void main(String[] args) {
        Display display = new Display();
        Realm.runWithDefault((Realm)DisplayRealm.getRealm((Display)display), () -> {
            ViewModel viewModel = new ViewModel();
            Shell shell = new View(viewModel).createShell();
            while (!shell.isDisposed()) {
                if (display.readAndDispatch()) continue;
                display.sleep();
            }
        });
        display.dispose();
    }

    static class Person {
        String name = "HelloWorld";

        Person() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    static class View {
        private final ViewModel viewModel;
        private Text textName;
        private Person person;

        public View(ViewModel viewModel) {
            this.viewModel = viewModel;
        }

        public Shell createShell() {
            Shell shell = new Shell();
            shell.setLayout((Layout)new GridLayout(1, false));
            this.textName = new Text((Composite)shell, 2048);
            Button button = new Button((Composite)shell, 8);
            button.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            button.setText("Print to console");
            button.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> System.out.println(this.person)));
            DataBindingContext bindingContext = new DataBindingContext();
            this.person = this.viewModel.getPerson();
            bindingContext.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.textName), PojoProperties.value((String)"name").observe((Object)this.person));
            shell.pack();
            shell.open();
            return shell;
        }
    }

    static class ViewModel {
        private final Person person = new Person();

        ViewModel() {
        }

        public Person getPerson() {
            return this.person;
        }
    }
}

